use crate::prelude::*;

pub type wchar_t = c_uint;
pub type time_t = c_long;

pub type clock_t = c_long;
pub type fsblkcnt_t = c_ulong;
pub type fsfilcnt_t = c_ulong;
pub type ino_t = c_ulong;
pub type nlink_t = c_ulong;
pub type off_t = c_long;
pub type fsword_t = c_long;
pub type suseconds_t = c_long;

pub type blksize_t = c_long;
pub type blkcnt_t = c_long;

pub type fsblkcnt64_t = c_ulong;
pub type fsfilcnt64_t = c_ulong;
pub type __u64 = c_ulong;

s! {
    pub struct stat {
        pub st_dev: c_ulong,
        pub __pad1: c_ushort,
        pub st_ino: crate::ino_t,
        pub st_mode: crate::mode_t,
        pub st_nlink: nlink_t,
        pub st_uid: crate::uid_t,
        pub st_gid: crate::gid_t,
        pub st_rdev: c_ulong,
        pub __pad2: c_ushort,
        pub st_size: crate::off64_t,
        pub st_blksize: blksize_t,
        pub st_blocks: crate::blkcnt64_t,
        pub st_atim: crate::timespec,
        pub st_mtim: crate::timespec,
        pub st_ctim: crate::timespec,
        pub __uclibc_unused4: c_ulong,
        pub __uclibc_unused5: c_ulong,
    }

    pub struct stat64 {
        pub st_dev: c_ulong,
        pub __pad1: c_uint,
        pub __st_ino: crate::ino_t,
        pub st_mode: crate::mode_t,
        pub st_nlink: nlink_t,
        pub st_uid: crate::uid_t,
        pub st_gid: crate::gid_t,
        pub st_rdev: c_ulong,
        pub __pad2: c_uint,
        pub st_size: crate::off64_t,
        pub st_blksize: blksize_t,
        pub st_blocks: crate::blkcnt64_t,
        pub st_atim: crate::timespec,
        pub st_mtim: crate::timespec,
        pub st_ctim: crate::timespec,
        pub st_ino: crate::ino64_t,
    }

    pub struct shmid_ds {
        pub shm_perm: crate::ipc_perm,
        pub shm_segsz: crate::size_t,
        pub shm_atime: crate::time_t,
        __unused1: c_ulong,
        pub shm_dtime: crate::time_t,
        __unused2: c_ulong,
        pub shm_ctime: crate::time_t,
        __unused3: c_ulong,
        pub shm_cpid: crate::pid_t,
        pub shm_lpid: crate::pid_t,
        pub shm_nattch: crate::shmatt_t,
        __unused4: c_ulong,
        __unused5: c_ulong,
    }

    #[allow(unpredictable_function_pointer_comparisons)]
    pub struct sigaction {
        pub sa_handler: crate::sighandler_t,
        pub sa_flags: c_ulong,
        pub sa_restorer: Option<extern "C" fn()>,
        pub sa_mask: sigset_t,
    }

    pub struct sigset_t {
        __val: [c_ulong; 1],
    }

    #[repr(align(8))]
    pub struct siginfo_t {
        pub si_signo: c_int,
        pub si_errno: c_int,
        pub si_code: c_int,
        pub _pad: [c_int; 28],
    }

    pub struct stack_t {
        pub ss_sp: *mut c_void,
        pub ss_flags: c_int,
        pub ss_size: crate::size_t,
    }

    pub struct flock {
        pub l_type: c_short,
        pub l_whence: c_short,
        pub l_start: off_t,
        pub l_len: off_t,
        pub l_pid: crate::pid_t,
    }

    pub struct termios {
        pub c_iflag: crate::tcflag_t,
        pub c_oflag: crate::tcflag_t,
        pub c_cflag: crate::tcflag_t,
        pub c_lflag: crate::tcflag_t,
        pub c_line: crate::cc_t,
        pub c_cc: [crate::cc_t; crate::NCCS],
        pub c_ispeed: crate::speed_t,
        pub c_ospeed: crate::speed_t,
    }
}

s_no_extra_traits! {
    pub union sem_t {
        __size: [c_char; 32],
        __align: c_longlong,
    }
}

pub const O_CLOEXEC: c_int = 0o2000000;
pub const __SIZEOF_PTHREAD_ATTR_T: usize = 36;
pub const __SIZEOF_PTHREAD_MUTEX_T: usize = 40;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: usize = 4;
pub const __SIZEOF_PTHREAD_COND_T: usize = 48;
pub const __SIZEOF_PTHREAD_COND_COMPAT_T: usize = 12;
pub const __SIZEOF_PTHREAD_CONDATTR_T: usize = 4;
pub const __SIZEOF_PTHREAD_RWLOCK_T: usize = 56;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: usize = 8;
pub const __SIZEOF_PTHREAD_BARRIER_T: usize = 32;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: usize = 4;

pub const NCCS: usize = 32;

pub const FIOQSIZE: crate::Ioctl = 0x545E;

// I wasn't able to find those constants
// in uclibc build environment for armv7
pub const MAP_HUGETLB: c_int = 0x040000; // from linux/other/mod.rs

// autogenerated constants with hand tuned types
pub const B0: crate::speed_t = 0;
pub const B1000000: crate::speed_t = 0x1008;
pub const B110: crate::speed_t = 0x3;
pub const B115200: crate::speed_t = 0x1002;
pub const B1152000: crate::speed_t = 0x1009;
pub const B1200: crate::speed_t = 0x9;
pub const B134: crate::speed_t = 0x4;
pub const B150: crate::speed_t = 0x5;
pub const B1500000: crate::speed_t = 0x100a;
pub const B1800: crate::speed_t = 0xa;
pub const B19200: crate::speed_t = 0xe;
pub const B200: crate::speed_t = 0x6;
pub const B2000000: crate::speed_t = 0x100b;
pub const B230400: crate::speed_t = 0x1003;
pub const B2400: crate::speed_t = 0xb;
pub const B2500000: crate::speed_t = 0x100c;
pub const B300: crate::speed_t = 0x7;
pub const B3000000: crate::speed_t = 0x100d;
pub const B3500000: crate::speed_t = 0x100e;
pub const B38400: crate::speed_t = 0xf;
pub const B4000000: crate::speed_t = 0x100f;
pub const B460800: crate::speed_t = 0x1004;
pub const B4800: crate::speed_t = 0xc;
pub const B50: crate::speed_t = 0x1;
pub const B500000: crate::speed_t = 0x1005;
pub const B57600: crate::speed_t = 0x1001;
pub const B576000: crate::speed_t = 0x1006;
pub const B600: crate::speed_t = 0x8;
pub const B75: crate::speed_t = 0x2;
pub const B921600: crate::speed_t = 0x1007;
pub const B9600: crate::speed_t = 0xd;
pub const BS1: c_int = 0x2000;
pub const BSDLY: c_int = 0x2000;
pub const CBAUD: crate::tcflag_t = 0x100f;
pub const CBAUDEX: crate::tcflag_t = 0x1000;
pub const CIBAUD: crate::tcflag_t = 0x100f0000;
pub const CLOCAL: crate::tcflag_t = 0x800;
pub const CPU_SETSIZE: c_int = 0x400;
pub const CR1: c_int = 0x200;
pub const CR2: c_int = 0x400;
pub const CR3: c_int = 0x600;
pub const CRDLY: c_int = 0x600;
pub const CREAD: crate::tcflag_t = 0x80;
pub const CS6: crate::tcflag_t = 0x10;
pub const CS7: crate::tcflag_t = 0x20;
pub const CS8: crate::tcflag_t = 0x30;
pub const CSIZE: crate::tcflag_t = 0x30;
pub const CSTOPB: crate::tcflag_t = 0x40;
pub const EADDRINUSE: c_int = 0x62;
pub const EADDRNOTAVAIL: c_int = 0x63;
pub const EADV: c_int = 0x44;
pub const EAFNOSUPPORT: c_int = 0x61;
pub const EALREADY: c_int = 0x72;
pub const EBADE: c_int = 0x34;
pub const EBADFD: c_int = 0x4d;
pub const EBADMSG: c_int = 0x4a;
pub const EBADR: c_int = 0x35;
pub const EBADRQC: c_int = 0x38;
pub const EBADSLT: c_int = 0x39;
pub const EBFONT: c_int = 0x3b;
pub const ECANCELED: c_int = 0x7d;
pub const ECHOCTL: crate::tcflag_t = 0x200;
pub const ECHOE: crate::tcflag_t = 0x10;
pub const ECHOK: crate::tcflag_t = 0x20;
pub const ECHOKE: crate::tcflag_t = 0x800;
pub const ECHONL: crate::tcflag_t = 0x40;
pub const ECHOPRT: crate::tcflag_t = 0x400;
pub const ECHRNG: c_int = 0x2c;
pub const ECOMM: c_int = 0x46;
pub const ECONNABORTED: c_int = 0x67;
pub const ECONNREFUSED: c_int = 0x6f;
pub const ECONNRESET: c_int = 0x68;
pub const EDESTADDRREQ: c_int = 0x59;
pub const EDOTDOT: c_int = 0x49;
pub const EDQUOT: c_int = 0x7a;
pub const EHOSTDOWN: c_int = 0x70;
pub const EHOSTUNREACH: c_int = 0x71;
pub const EIDRM: c_int = 0x2b;
pub const EILSEQ: c_int = 0x54;
pub const EINPROGRESS: c_int = 0x73;
pub const EISCONN: c_int = 0x6a;
pub const EISNAM: c_int = 0x78;
pub const EKEYEXPIRED: c_int = 0x7f;
pub const EKEYREJECTED: c_int = 0x81;
pub const EKEYREVOKED: c_int = 0x80;
pub const EL2HLT: c_int = 0x33;
pub const EL2NSYNC: c_int = 0x2d;
pub const EL3HLT: c_int = 0x2e;
pub const EL3RST: c_int = 0x2f;
pub const ELIBACC: c_int = 0x4f;
pub const ELIBBAD: c_int = 0x50;
pub const ELIBEXEC: c_int = 0x53;
pub const ELIBMAX: c_int = 0x52;
pub const ELIBSCN: c_int = 0x51;
pub const ELNRNG: c_int = 0x30;
pub const ELOOP: c_int = 0x28;
pub const EMEDIUMTYPE: c_int = 0x7c;
pub const EMSGSIZE: c_int = 0x5a;
pub const EMULTIHOP: c_int = 0x48;
pub const ENAMETOOLONG: c_int = 0x24;
pub const ENAVAIL: c_int = 0x77;
pub const ENETDOWN: c_int = 0x64;
pub const ENETRESET: c_int = 0x66;
pub const ENETUNREACH: c_int = 0x65;
pub const ENOANO: c_int = 0x37;
pub const ENOBUFS: c_int = 0x69;
pub const ENOCSI: c_int = 0x32;
pub const ENODATA: c_int = 0x3d;
pub const ENOKEY: c_int = 0x7e;
pub const ENOLCK: c_int = 0x25;
pub const ENOLINK: c_int = 0x43;
pub const ENOMEDIUM: c_int = 0x7b;
pub const ENOMSG: c_int = 0x2a;
pub const ENONET: c_int = 0x40;
pub const ENOPKG: c_int = 0x41;
pub const ENOPROTOOPT: c_int = 0x5c;
pub const ENOSR: c_int = 0x3f;
pub const ENOSTR: c_int = 0x3c;
pub const ENOSYS: c_int = 0x26;
pub const ENOTCONN: c_int = 0x6b;
pub const ENOTEMPTY: c_int = 0x27;
pub const ENOTNAM: c_int = 0x76;
pub const ENOTRECOVERABLE: c_int = 0x83;
pub const ENOTSOCK: c_int = 0x58;
pub const ENOTUNIQ: c_int = 0x4c;
pub const EOPNOTSUPP: c_int = 0x5f;
pub const EOVERFLOW: c_int = 0x4b;
pub const EOWNERDEAD: c_int = 0x82;
pub const EPFNOSUPPORT: c_int = 0x60;
pub const EPOLL_CLOEXEC: c_int = 0x80000;
pub const EPROTO: c_int = 0x47;
pub const EPROTONOSUPPORT: c_int = 0x5d;
pub const EPROTOTYPE: c_int = 0x5b;
pub const EREMCHG: c_int = 0x4e;
pub const EREMOTE: c_int = 0x42;
pub const EREMOTEIO: c_int = 0x79;
pub const ERESTART: c_int = 0x55;
pub const ESHUTDOWN: c_int = 0x6c;
pub const ESOCKTNOSUPPORT: c_int = 0x5e;
pub const ESRMNT: c_int = 0x45;
pub const ESTALE: c_int = 0x74;
pub const ESTRPIPE: c_int = 0x56;
pub const ETIME: c_int = 0x3e;
pub const ETIMEDOUT: c_int = 0x6e;
pub const ETOOMANYREFS: c_int = 0x6d;
pub const EUCLEAN: c_int = 0x75;
pub const EUNATCH: c_int = 0x31;
pub const EUSERS: c_int = 0x57;
pub const EXFULL: c_int = 0x36;
pub const FF1: c_int = 0x8000;
pub const FFDLY: c_int = 0x8000;
pub const FLUSHO: crate::tcflag_t = 0x1000;
pub const F_GETLK: c_int = 0x5;
pub const F_SETLK: c_int = 0x6;
pub const F_SETLKW: c_int = 0x7;
pub const HUPCL: crate::tcflag_t = 0x400;
pub const ICANON: crate::tcflag_t = 0x2;
pub const IEXTEN: crate::tcflag_t = 0x8000;
pub const ISIG: crate::tcflag_t = 0x1;
pub const IXOFF: crate::tcflag_t = 0x1000;
pub const IXON: crate::tcflag_t = 0x400;
pub const MAP_ANON: c_int = 0x20;
pub const MAP_ANONYMOUS: c_int = 0x20;
pub const MAP_DENYWRITE: c_int = 0x800;
pub const MAP_EXECUTABLE: c_int = 0x1000;
pub const MAP_GROWSDOWN: c_int = 0x100;
pub const MAP_LOCKED: c_int = 0x2000;
pub const MAP_NONBLOCK: c_int = 0x10000;
pub const MAP_NORESERVE: c_int = 0x4000;
pub const MAP_POPULATE: c_int = 0x8000;
pub const MAP_STACK: c_int = 0x20000;
pub const MINSIGSTKSZ: c_int = 5120;
pub const NLDLY: crate::tcflag_t = 0x100;
pub const NOFLSH: crate::tcflag_t = 0x80;
pub const OLCUC: crate::tcflag_t = 0x2;
pub const ONLCR: crate::tcflag_t = 0x4;
pub const O_ACCMODE: c_int = 0x3;
pub const O_APPEND: c_int = 0x400;
pub const O_ASYNC: c_int = 0o20000;
pub const O_CREAT: c_int = 0x40;
pub const O_DIRECT: c_int = 0x10000;
pub const O_DIRECTORY: c_int = 0x4000;
pub const O_DSYNC: c_int = O_SYNC;
pub const O_EXCL: c_int = 0x80;
pub const O_FSYNC: c_int = O_SYNC;
pub const O_LARGEFILE: c_int = 0o400000;
pub const O_NDELAY: c_int = O_NONBLOCK;
pub const O_NOATIME: c_int = 0o1000000;
pub const O_NOCTTY: c_int = 0x100;
pub const O_NOFOLLOW: c_int = 0x8000;
pub const O_NONBLOCK: c_int = 0x800;
pub const O_PATH: c_int = 0o10000000;
pub const O_RSYNC: c_int = O_SYNC;
pub const O_SYNC: c_int = 0o10000;
pub const O_TRUNC: c_int = 0x200;
pub const PARENB: crate::tcflag_t = 0x100;
pub const PARODD: crate::tcflag_t = 0x200;
pub const PENDIN: crate::tcflag_t = 0x4000;
pub const POLLWRBAND: c_short = 0x200;
pub const POLLWRNORM: c_short = 0x100;
pub const RTLD_GLOBAL: c_int = 0x00100;

// These are typed unsigned to match sigaction
pub const SA_NOCLDSTOP: c_ulong = 0x1;
pub const SA_NOCLDWAIT: c_ulong = 0x2;
pub const SA_SIGINFO: c_ulong = 0x4;
pub const SA_NODEFER: c_ulong = 0x40000000;
pub const SA_ONSTACK: c_ulong = 0x8000000;
pub const SA_RESETHAND: c_ulong = 0x80000000;
pub const SA_RESTART: c_ulong = 0x10000000;

pub const SIGBUS: c_int = 0x7;
pub const SIGCHLD: c_int = 0x11;
pub const SIGCONT: c_int = 0x12;
pub const SIGIO: c_int = 0x1d;
pub const SIGPOLL: c_int = SIGIO;
pub const SIGPROF: c_int = 0x1b;
pub const SIGPWR: c_int = 0x1e;
pub const SIGSTKFLT: c_int = 0x10;
pub const SIGSTKSZ: c_int = 16384;
pub const SIGSTOP: c_int = 0x13;
pub const SIGSYS: c_int = 0x1f;
pub const SIGTSTP: c_int = 0x14;
pub const SIGTTIN: c_int = 0x15;
pub const SIGTTOU: c_int = 0x16;
pub const SIGURG: c_int = 0x17;
pub const SIGUSR1: c_int = 0xa;
pub const SIGUSR2: c_int = 0xc;
pub const SIGVTALRM: c_int = 0x1a;
pub const SIGWINCH: c_int = 0x1c;
pub const SIGXCPU: c_int = 0x18;
pub const SIGXFSZ: c_int = 0x19;
pub const SIG_BLOCK: c_int = 0;
pub const SIG_UNBLOCK: c_int = 0x1;
pub const SIG_SETMASK: c_int = 0x2;
pub const SOCK_DGRAM: c_int = 0x2;
pub const SOCK_NONBLOCK: c_int = 0o0004000;
pub const SOCK_SEQPACKET: c_int = 0x5;
pub const SOCK_STREAM: c_int = 0x1;

pub const TAB1: c_int = 0x800;
pub const TAB2: c_int = 0x1000;
pub const TAB3: c_int = 0x1800;
pub const TABDLY: c_int = 0x1800;
pub const TCSADRAIN: c_int = 0x1;
pub const TCSAFLUSH: c_int = 0x2;
pub const TCSANOW: c_int = 0;
pub const TOSTOP: crate::tcflag_t = 0x100;
pub const VDISCARD: usize = 0xd;
pub const VEOF: usize = 0x4;
pub const VEOL: usize = 0xb;
pub const VEOL2: usize = 0x10;
pub const VMIN: usize = 0x6;
pub const VREPRINT: usize = 0xc;
pub const VSTART: usize = 0x8;
pub const VSTOP: usize = 0x9;
pub const VSUSP: usize = 0xa;
pub const VSWTC: usize = 0x7;
pub const VT1: c_int = 0x4000;
pub const VTDLY: c_int = 0x4000;
pub const VTIME: usize = 0x5;
pub const VWERASE: usize = 0xe;
pub const XTABS: crate::tcflag_t = 0x1800;
