# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999

CABAL_HACKAGE_REVISION=1

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Lua engine to power custom pandoc conversions"
HOMEPAGE="https://pandoc.org"

LICENSE="GPL-2+"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"

RESTRICT=test # requires network access to fetch .svg

RDEPEND=">=dev-haskell/pandoc-3.1.4:=[profile?] <dev-haskell/pandoc-3.2:=[profile?]
	dev-haskell/aeson:=[profile?]
	>=dev-haskell/citeproc-0.8:=[profile?] <dev-haskell/citeproc-0.9:=[profile?]
	>=dev-haskell/data-default-0.4:=[profile?] <dev-haskell/data-default-0.8:=[profile?]
	>=dev-haskell/doclayout-0.4:=[profile?] <dev-haskell/doclayout-0.5:=[profile?]
	>=dev-haskell/doctemplates-0.11:=[profile?] <dev-haskell/doctemplates-0.12:=[profile?]
	>=dev-haskell/hslua-2.3:=[profile?] <dev-haskell/hslua-2.4:=[profile?]
	>=dev-haskell/hslua-module-doclayout-1.1:=[profile?] <dev-haskell/hslua-module-doclayout-1.2:=[profile?]
	>=dev-haskell/hslua-module-path-1.1:=[profile?] <dev-haskell/hslua-module-path-1.2:=[profile?]
	>=dev-haskell/hslua-module-system-1.1:=[profile?] <dev-haskell/hslua-module-system-1.2:=[profile?]
	>=dev-haskell/hslua-module-text-1.1:=[profile?] <dev-haskell/hslua-module-text-1.2:=[profile?]
	>=dev-haskell/hslua-module-version-1.1:=[profile?] <dev-haskell/hslua-module-version-1.2:=[profile?]
	>=dev-haskell/hslua-module-zip-1.1:=[profile?] <dev-haskell/hslua-module-zip-1.2:=[profile?]
	>=dev-haskell/hslua-repl-0.1.1:=[profile?] <dev-haskell/hslua-repl-0.2:=[profile?]
	>=dev-haskell/lpeg-1.0.4:=[profile?] <dev-haskell/lpeg-1.1:=[profile?]
	>=dev-haskell/pandoc-lua-marshal-0.2.2:=[profile?] <dev-haskell/pandoc-lua-marshal-0.3:=[profile?]
	>=dev-haskell/pandoc-types-1.22:=[profile?] <dev-haskell/pandoc-types-1.24:=[profile?]
	>=dev-haskell/parsec-3.1:=[profile?] <dev-haskell/parsec-3.2:=[profile?]
	>=dev-haskell/sha-1.6:=[profile?] <dev-haskell/sha-1.7:=[profile?]
	>=dev-haskell/text-1.1.1:=[profile?] <dev-haskell/text-2.2:=[profile?]
	>=dev-lang/ghc-8.10.6:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.2.1.0
	test? ( dev-haskell/tasty
		dev-haskell/tasty-golden
		dev-haskell/tasty-hunit
		>=dev-haskell/tasty-lua-1.1 <dev-haskell/tasty-lua-1.2 )
"
