.TH @g@refer @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@refer \- process bibliographic references for
.I groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2024 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_refer_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@refer
.RB [ \-bCenPRS ]
.RB [ \-a\~\c
.IR n ]
.RB [ \-B
.IB field . macro\c
]
.RB [ \-c\~\c
.IR fields ]
.RB [ \-f\~\c
.IR n ]
.RB [ \-i\~\c
.IR fields ]
.RB [ \-k\~\c
.IR field ]
.RB [ \-l\~\c
.IR range-expression ]
.RB [ \-p\~\c
.IR database-file ]
.RB [ \-s\~\c
.IR fields ]
.RB [ \-t\~\c
.IR n ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY @g@refer
.B \-\-help
.YS
.
.
.P
.SY @g@refer
.B \-v
.YS
.
.SY @g@refer
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU implementation of
.I \%refer \" generic
is part of the
.MR groff @MAN1EXT@
document formatting system.
.
.I @g@refer
is a
.MR @g@troff @MAN1EXT@
preprocessor that prepares bibliographic citations by looking up
keywords specified in a
.MR roff @MAN7EXT@
input document,
obviating the need to type such annotations,
and permitting the citation style in formatted output to be altered
independently and systematically.
.
It copies the contents of each
.I file
to the standard output stream,
looking up each
.I citation
between lines starting with
.B .[
and
.B .]\&
and replacing it with a bibliographic reference.
.
GNU
.I refer \" GNU
furthermore interprets lines between those starting with
.B .R1
and
.B .R2
as instructions directing how citations are to be processed.
.
.I @g@refer
interprets and generates
.I roff
.B lf
requests so that file names and line numbers in messages produced by
commands that read its output correctly describe the source document.
.
Normally,
.I @g@refer
is not executed directly by the user,
but invoked by specifying the
.B \-R
option to
.MR groff @MAN1EXT@ .
.
If no
.I file
operands are present,
or if
.I file
is
.RB \[lq] \- \[rq],
.I @g@refer
reads the standard input stream.
.
.
.P
A citation identifies a work by reference to a
.I "bibliographic record"
detailing it.
.
Select a work from a database of records by listing keywords that
uniquely identify its entry.
.
Alternatively,
a document can specify a record for the work at the point its citation
occurs.
.
A document can use either or both strategies as desired.
.
.
.P
For each citation,
.I @g@refer
produces a
.I mark
in the text,
like a superscripted footnote number or \[lq][Lesk1978a]\[rq].
.
A mark consists of a
.I label
between
.I brackets.
.
The mark can be separated from surrounding text
and from other labels in various ways.
.
.I @g@refer
produces
.I roff
language requests usable by a document or a macro package
such as
.\" .IR man ,
.IR me ,
.IR mm ,
.IR mom ,
or
.I ms
to produce a formatted reference for each citation.
.
A citation's reference can be output immediately after it occurs
(as with footnotes),
or references may
.IR accumulate ,
with corresponding output appearing later in the document
(as with endnotes).
.
When references accumulate,
multiple citations of the same reference produce a single formatted
entry.
.
.
.P
Interpretation of lines between
.B .R1
and
.B .R2
tokens as preprocessor commands is a GNU
.I \%refer \" GNU
extension.
.
Documents employing this feature can still be processed by AT&T
.I \%refer \" AT&T
by adding the lines
.
.RS
.EX
\&.de R1
\&.ig R2
\&..
.EE
.RE
.
to the beginning of the document.
.
The foregoing input causes
.I troff \" generic
to ignore everything between
.B .R1
and
.BR .R2 .
.
The effects of some
.I \%refer \" generic
commands can be achieved by command-line options;
these are supported for compatibility with AT&T
.IR \%refer . \" AT&T
.
It is usually more convenient to use commands.
.
.
.\" ====================================================================
.SS "Bibliographic records"
.\" ====================================================================
.
A bibliographic record describes a referenced work in sufficient detail
that it may be cited to accepted standards of scholarly and professional
clarity.
.
The record format permits annotation and extension that a document may
use or ignore.
.
A record is a plain text sequence of
.I fields,
one per line,
each consisting of a percent sign
.BR % ,
an alphanumeric character classifying it,
one space,
and its contents.
.
If a field's contents are empty,
the field is ignored.
.
.
.P
Frequently,
such records are organized into a
.I "bibliographic database,"
with each entry separated by blank lines or file boundaries.
.
This practice relieves documents of the need to maintain bibliographic
data themselves.
.
The programs
.MR @g@lookbib @MAN1EXT@
and
.MR lkbib @MAN1EXT@
consult a bibliographic database,
and
.MR @g@indxbib @MAN1EXT@
indexes one to speed retrieval from it,
reducing document processing time.
.
Use of these tools is optional.
.
.
.br
.ne 4v
.P
The conventional uses of the bibliographic field entries are as
follows.
.
Within a record,
fields other than
.B %A
and
.B %E
replace previous occurrences thereof.
.
The ordering of multiple
.B %A
and
.B %E
fields is significant.
.
.
.TP
.B %A
names an author.
.
If the name contains a suffix such as \[lq]Jr.\&\[rq]
or \[lq]III\[rq],
it should be separated from the surname by a comma.
.
We recommend always supplying an
.B %A
field or a
.B %Q
field.
.
.
.TP
.B %B
records the title of the book within which a cited article
is collected.
.
See
.B %J
and
.BR %T .
.
.
.TP
.B %C
names the city or other place of publication.
.
.
.TP
.B %D
indicates the date of publication.
.
Specify the year in full.
.\" even if the title of the conference proceedings abbreviates it
.
If the month is specified,
use its name rather than its number;
only the first three letters are required.
.
We recommend always supplying a
.B %D
field;
if the date is unknown,
use
.RB \[lq] "in press" \[rq]
or
.RB \[lq] unknown \[rq]
as its contents.
.
.
.TP
.B %E
names an editor of the book within which a cited article is collected.
.
Where a work has editors but no authors,
name the editors in
.B %A
fields and append
.RB \[lq] ,\~(ed.)\& \[rq]
or
.RB \[lq] ,\~(eds.)\& \[rq]
to the last of these.
.
.
.TP
.B %G
records the U.S.\& government ordering number,
ISBN,
DOI,
or other unique identifier.
.
.
.TP
.B %I
names the publisher (issuer).
.
.
.TP
.B %J
records the name of the journal within which a cited article is
collected.
.
See
.B %B
and
.BR %T .
.
.
.TP
.B %K
lists keywords intended to aid searches.
.
.
.TP
.B %L
is a label;
typically unused in database entries,
it can override the label format otherwise determined.
.
.
.TP
.B %N
records the issue number of the journal within which a cited article
is collected.
.
.
.TP
.B %O
presents additional (\[lq]other\[rq]) information,
typically placed at the end of the reference.
.
.
.TP
.B %P
lists the page numbers of a cited work that is part of a larger
collection.
.
Specify a range with
.IB m \- \c
.IR n .
.\" XXX: Why not \[en]?  Does that break?
.
.
.TP
.B %Q
names an institutional author when no
.B %A
fields are present.
.
Only one
.B %Q
field is permitted.
.
.
.TP
.B %R
is an identifier for a report,
thesis,
memorandum,
or other unpublished work.
.
.
.TP
.B %S
records the title of a series to which the cited work belongs.
.
.
.TP
.B %T
is the work's title.
.
See
.B %B
and
.BR %J .
.
.
.TP
.B %V
is the volume number of the journal or book containing the cited work.
.
.
.TP
.B %X
is an annotation.
.
By convention,
it is not formatted in the citing document.
.
.
.P
If the obsolescent \[lq]accent strings\[rq] feature of the
.I ms
or
.I me
macro packages is used,
such strings should follow the character to be accented;
an
.I ms
document must call the
.B AM
macro before using them.
.
Do not quote accent strings:
use one
.B \e
rather than two.
.
See
.MR groff_char @MAN7EXT@
for a modern approach to the problem of diacritics.
.
.
.\" ====================================================================
.SS Citations
.\" ====================================================================
.
Citations have a characteristic format.
.
.RS
.EX
.BI .[ opening-text
.IR "flags keyword\~" .\|.\|.
.I field
\&.\|.\|.
.BI .] closing-text
.EE
.RE
.
.
.P
.IR opening-text ,
.IR closing-text ,
and
.I flags
are optional,
and only one
.I keyword
or
.I field
need be specified.
.
If keywords are present,
.I @g@refer
searches the bibliographic database(s) for a unique reference matching
them.
.
Multiple matches are an error;
add more keywords to disambiguate the reference.
.
In the absence of keywords,
.I fields
constitute the bibliographic record.
.
Otherwise,
.I fields
specify additional data to replace or supplement those in the reference.
.
When references are accumulating and keywords are present,
specify
additional
.I fields
at most on the first citation of a particular
reference;
they apply to all further citations thereof.
.
.
.br
.ne 2v
.P
.I opening-text
and
.I closing-text
are
.I roff
input used to bracket the label,
overriding the
.B \%bracket\-label
command.
.
Leading and trailing spaces are significant.
.
If either of these is non-empty,
the corresponding argument to the
.B \%bracket\-label
command is not used;
alter this behavior with the
.B [
and
.B ]
.I flags.
.
.
.br
.ne 3v
.P
.I flags
is a list of non-alphanumeric characters each of which modifies the
treatment of the particular citation.
.
AT&T
.I \%refer \" AT&T
ignores them since they are non-alphanumeric.
.
They direct GNU
.I \%refer \" GNU
as follows.
.
.
.TP
.B #
Use the label specified by the
.B \%short\-label
command,
if any.
.
.I @g@refer
otherwise uses the normal label.
.
Typically,
a short label implements author-date citation styles consisting of a
name,
a year,
and a disambiguating letter if necessary.
.
.RB \[lq] # \[rq]
is meant to suggest such a (quasi-)numeric label.
.
.
.TP
.B [
Precede
.I opening-text
with the first argument given to the
.B \%bracket\-label
command.
.
.
.TP
.B ]
Follow
.I closing-text
with the second argument given to the
.B \%bracket\-label
command.
.
.
.P
An advantage of the
.B [
and
.B ]
flags over use of
.I opening-text
and
.I closing-text
is that you can update the document's bracketing style in one place
using the
.B \%bracket\-label
command.
.
Another is that sorting and merging of citations is not necessarily
inhibited if the flags are used.
.
.
.P
.I @g@refer
appends any label resulting from a citation to the
.I roff
input line preceding the
.B .[
token.
.
If there is no such line,
.I @g@refer
issues a warning diagnostic.
.
.
.P
There is no special notation for citing multiple references in series.
.
Use a sequence of citations,
one for each reference,
with nothing between them.
.
.I @g@refer
attaches all of their labels to the line preceding the first.
.
These labels may be sorted or merged.
.
See the description of the
.B <>
label expression,
and of the
.B \%sort\-adjacent\-labels
and
.B \%abbreviate\-label\-ranges
commands.
.
A label is not merged if its citation has a non-empty
.I opening-text
or
.IR closing-text .
.
However,
the labels for two adjacent citations,
the former using the
.B ]
flag and without any
.I closing-text,
and the latter using the
.B [
flag and without any
.I opening-text,
may be sorted and merged
even if the former's
.I opening-text
or the latter's
.I closing-text
is non-empty.
.
(To prevent these operations,
use the dummy character escape sequence
.B \[rs]&
as the former's
.IR closing-text .)
.
.
.\" ====================================================================
.SS Commands
.\" ====================================================================
.
Commands are contained between lines starting with
.B .R1
and
.BR .R2 .
.
The
.B \-R
option prevents recognition of these lines.
.
When
.I @g@refer
encounters a
.B .R1
line,
it
flushes any accumulated references.
.
Neither
.B .R1
nor
.B .R2
lines,
nor anything between them,
is output.
.
.
.P
Commands are separated by newlines or semicolons.
.
A number sign
.RB ( # )
introduces a comment that extends to the end of the line,
but does not conceal the newline.
.
Each command is broken up into words.
.
Words are separated by spaces or tabs.
.
A word that begins with a (neutral) double quote
.RB ( \[dq] )
extends to the next double quote that is not followed by another double
quote.
.
If there is no such double quote,
the word extends to the end of the line.
.
Pairs of double quotes in a word beginning with a double quote collapse
to one double quote.
.
Neither a number sign nor a semicolon is recognized inside double
quotes.
.
A line can be continued by ending it with a backslash
.RB \[lq]\^ \[rs] \[rq];
this works everywhere except after a number sign.
.
.
.LP
.ds n \fR*\fP\"
Each command
.I name
that is marked with \*n has an associated negative command
.BI no\- name
that undoes the effect of
.IR name .
.
For example,
the
.B no\-sort
command specifies that references should not be sorted.
.
The negative commands take no arguments.
.
.
.LP
In the following description each argument must be a single word;
.I field
is used for a single upper or lower case letter naming a field;
.I fields
is used for a sequence of such letters;
.I m
and
.I n
are used for a non-negative numbers;
.I string
is used for an arbitrary string;
.I file
is used for the name of a file.
.
.
.TP
.BI abbreviate\*n\~ fields\~string1\~string2\~string3\~string4
Abbreviate the first names of
.IR fields .
.
An initial letter will be separated from another initial letter by
.IR string1 ,
from the surname by
.IR string2 ,
and from anything else
(such as \[lq]von\[rq] or \[lq]de\[rq])
by
.IR string3 .
.
These default to a period followed by a space.
.
In a hyphenated first name,
the initial of the first part of the name will be separated from the
hyphen by
.IR string4 ;
this defaults to a period.
.
No attempt is made to handle any ambiguities that might
result from abbreviation.
.
Names are abbreviated before sorting and before label construction.
.
.
.TP
.BI abbreviate\-label\-ranges\*n\~ string
.
Three or more adjacent labels that refer to consecutive references
will be abbreviated to a label consisting of the first label,
followed by
.IR string ,
followed by the last label.
.
This is mainly useful with numeric labels.
.
If
.I string
is omitted,
it defaults to
.RB \[lq] \- \[rq].
.
.
.TP
.B accumulate\*n
Accumulate references instead of writing out each reference
as it is encountered.
.
Accumulated references will be written out whenever a reference
of the form
.
.RS
.RS
.EX
.B .[
.B $LIST$
.B .]
.EE
.RE
.
is encountered,
after all input files have been processed,
and whenever a
.B .R1
line is recognized.
.RE
.
.
.TP
.BI annotate\*n\~ "field string"
.I field
is an annotation;
print it at the end of the reference as a paragraph preceded by the line
.
.RS
.IP
.BI . string
.
.
.LP
If
.I string
is omitted,
it will default to
.BR AP ;
if
.I field
is also omitted it will default to
.BR X .
.
Only one field can be an annotation.
.RE
.
.
.TP
.BI articles\~ string\~\c
\&.\|.\|.
Each
.I string
is a definite or indefinite article,
and should be ignored at the beginning of
.B T
fields when sorting.
.
Initially,
\[lq]a\[rq],
\[lq]an\[rq],
and
\[lq]the\[rq] are recognized as articles.
.
.
.TP
.BI bibliography\~ file\~\c
\&.\|.\|.
.
Write out all the references contained in each bibliographic database
.IR file .
.
This command should come last in an
.BR .R1 / .R2
block.
.
.
.TP
.BI bracket\-label\~ "string1 string2 string3"
In the text,
bracket each label with
.I string1
and
.IR string2 .
.
An occurrence of
.I string2
immediately followed by
.I string1
will be turned into
.IR string3 .
.
The default behavior is as follows.
.
.RS \" RS twice to get inboard of the tagged paragraph indentation.
.RS
.EX
bracket\-label \e*([. \e*(.] \[dq], \[dq]
.EE
.RE
.RE
.
.
.TP
.BI capitalize\~ fields
Convert
.I fields
to caps and small caps.
.
.
.TP
.B compatible\*n
Recognize
.B .R1
and
.B .R2
even when followed by a character other than space or newline.
.
.
.TP
.BI database\~ file\~\c
\&.\|.\|.
Search each bibliographic database
.IR file .
.
For each
.IR file ,
if an index
.RI file @INDEX_SUFFIX@
created by
.MR @g@indxbib @MAN1EXT@
exists,
then it will be searched instead;
each index can cover multiple databases.
.
.
.TP
.BI date\-as\-label\*n\~ string
.I string
is a label expression that specifies a string with which to replace the
.B D
field after constructing the label.
.
See subsection \[lq]Label expressions\[rq] below for a description of
label expressions.
.
This command is useful if you do not want explicit labels in the
reference list,
but instead want to handle any necessary disambiguation by qualifying
the date in some way.
.
The label used in the text would typically be some combination of the
author and date.
.
In most cases you should also use the
.B \%no\-label\-in\-reference
command.
.
For example,
.
.RS \" RS twice to get inboard of the tagged paragraph indentation.
.RS
.EX
date\-as\-label D.+yD.y%a*D.\-y
.EE
.RE
.
would attach a disambiguating letter to the year part of the
.B D
field in the reference.
.RE
.
.
.TP
.B default\-database\*n
The default database should be searched.
.
This is the default behavior,
so the negative version of this command is more useful.
.
.I @g@refer
determines whether the default database should be searched
on the first occasion that it needs to do a search.
.
Thus a
.B \%no\-default\-database
command must be given before then,
in order to be effective.
.
.
.TP
.BI discard\*n\~ fields
When the reference is read,
.I fields
should be discarded;
no string definitions for
.I fields
will be output.
.
Initially,
.I fields
are
.BR XYZ .
.
.
.TP
.BI et\-al\*n\~ "string m n"
Configure use of
.RB \[lq] "et al" \[rq]
in the evaluation of
.B @
expressions in label expressions.
.
If
.I u
is the number of authors needed to make the author sequence unambiguous
and the total number of authors is
.I t,
then the last
.IR t \|\-\| u
authors will be replaced by
.I string
provided that
.IR t \|\-\| u
is not less than
.I m
and
.I t
is not less than
.IR n .
.
The default behavior is as follows.
.
.RS \" RS twice to get inboard of the tagged paragraph indentation.
.RS
.EX
et\-al " et al" 2 3
.EE
.RE
.
Note the absence of a dot from the end of the abbreviation,
which is arguably not correct.
.
.RI ( "Et al" [.]
is short for
.IR "et alli" ,
as
.I etc.\&
is short for
.IR "et cetera".)
.RE
.
.
.TP
.BI include\~ file
Include
.I file
and interpret the contents as commands.
.
.
.TP
.BI join\-authors\~ "string1 string2 string3"
Join multiple authors together with
.IR string s.
.
When there are exactly two authors,
they will be joined with
.IR string1 .
.
When there are more than two authors,
all but the last two will be joined with
.IR string2 ,
and the last two authors will be joined with
.IR string3 .
.
If
.I string3
is omitted,
it will default to
.IR string1 ;
if
.I string2
is also omitted it will also default to
.IR string1 .
.
For example,
.
.RS
.RS
.EX
join\-authors \[dq] and \[dq] \[dq], \[dq] \[dq], and \[dq]
.EE
.RE
.
will restore the default method for joining authors.
.RE
.
.
.TP
.B label\-in\-reference\*n
When outputting the reference,
define the string
.B [F
to be the reference's label.
.
This is the default behavior,
so the negative version of this command is more useful.
.
.
.TP
.B label\-in\-text\*n
For each reference output a label in the text.
.
The label will be separated from the surrounding text as described in
the
.B \%bracket\-label
command.
.
This is the default behavior,
so the negative version of this command is more useful.
.
.
.TP
.BI label\~ string
.I string
is a label expression describing how to label each reference.
.
.
.TP
.BI separate\-label\-second\-parts\~ string
When merging two-part labels,
separate the second part of the second label from the first label with
.IR string .
.
See the description of the
.B <>
label expression.
.
.
.TP
.B move\-punctuation\*n
In the text,
move any punctuation at the end of line past the label.
.
We recommend employing this command unless you are using superscripted
numbers as labels.
.
.
.TP
.BI reverse\*n\~ string
Reverse the fields whose names
are in
.IR string .
.
An optional integer after a field name limits the number of such fields
to the given count;
no integer means no limit.
.
.
.TP
.BI search\-ignore\*n\~ fields
While searching for keys in databases for which no index exists,
ignore the contents of
.IR fields .
.
Initially,
fields
.B XYZ
are ignored.
.
.
.TP
.BI search\-truncate\*n\~ n
Only require the first
.I n
characters of keys to be given.
.
In effect when searching for a given key words in the database are
truncated to the maximum of
.I n
and the length of the key.
.
Initially,
.I n
is\~6.
.
.
.TP
.BI short\-label\*n\~ string
.I string
is a label expression that specifies an alternative
(usually shorter)
style of label.
.
This is used when the
.B #
flag is given in the citation.
.
When using author-date style labels,
the identity of the author or authors is sometimes clear from the
context,
and so it may be desirable to omit the author or authors from the label.
.
The
.B \%short\-label
command will typically be used to specify a label containing just
a date and possibly a disambiguating letter.
.
.
.TP
.BI sort\*n\~ string
Sort references according to
.IR string .
.
References will automatically be accumulated.
.
.I string
should be a list of field names,
each followed by a number,
indicating how many fields with the name should be used for sorting.
.
.RB \[lq] + \[rq]
can be used to indicate that all the fields with the name should be
used.
.
Also
.B .\&
can be used to indicate the references should be sorted using the
(tentative) label.
.
(Subsection \[lq]Label expressions\[rq] below describes the concept of a
tentative label.)
.
.
.TP
.B sort\-adjacent\-labels\*n
Sort labels that are adjacent in the text according to their position
in the reference list.
.
This command should usually be given if the
.B \%abbreviate\-label\-ranges
command has been given,
or if the label expression contains a
.B <>
expression.
.
This has no effect unless references are being accumulated.
.
.
.\" ====================================================================
.SS "Label expressions"
.\" ====================================================================
.
Label expressions can be evaluated both normally and tentatively.
.
The result of normal evaluation is used for output.
.
The result of tentative evaluation,
called the
.IR "tentative label" ,
is used to gather the information that normal evaluation needs to
disambiguate the label.
.
Label expressions specified by the
.B \%date\-as\-label
and
.B \%short\-label
commands are not evaluated tentatively.
.
Normal and tentative evaluation are the same for all types of expression
other than
.BR @ ,
.BR * ,
and
.B %
expressions.
.
The description below applies to normal evaluation,
except where otherwise specified.
.
.
.TP 8n \" "expr-n" + 2n
.IR field\~ [ n ]
is the
.IR n th
part of
.IR field .
.
If
.I n
is omitted,
it defaults to\~1.
.
.
.TP
.BI \[aq] string \[aq]
The characters in
.I string
literally.
.
.
.TP
.B @
All authors joined as specified by the
.B \%join\-authors
command.
.
The whole of each author's name is used.
.
However,
if the references are sorted by author
(that is,
the sort specification starts with
.RB \[lq] A+ \[rq]),
then authors' surnames will be used instead,
provided that this does not introduce ambiguity,
and also an initial subsequence of the authors may be used instead of
all the authors,
again provided that this does not introduce ambiguity.
.
Given any two referenced works with
.I n
authors,
the use of only the surname for the
.IR n th
author of a reference
is regarded as ambiguous if
the other reference
shares the first
.IR n \|\-\|1
authors,
the
.IR n th
authors of each reference are not identical,
but the
.IR n th
authors' surnames
.I are
the same.
.
A proper initial subsequence of the sequence of authors for some
reference is considered to be ambiguous if there is a reference with
some other sequence of authors which also has that subsequence as a
proper initial subsequence.
.
When an initial subsequence of authors is used,
the remaining authors are replaced by the string specified by the
.B \%et\-al
command;
this command may also specify additional requirements that must be
met before an initial subsequence can be used.
.
.B @
tentatively evaluates to a canonical representation of the authors,
such that authors that compare equally for sorting purposes have the
same representation.
.
.
.TP
.BI % n
.TQ
.B %a
.TQ
.B %A
.TQ
.B %i
.TQ
.B %I
The serial number of the reference formatted according to the
character following the
.BR % .
The serial number of a reference is\~1 plus the number of earlier
references with same tentative label as this reference.
.
These expressions tentatively evaluate to an empty string.
.
.TP
.IB expr *
If there is another reference with the same tentative label as this
reference,
then
.IR expr ,
otherwise an empty string.
.
It tentatively evaluates to an empty string.
.
.
.TP
.IB expr + n
.TQ
.IB expr \- n
The first
.RB ( + )
or last
.RB ( \- )
.I n
upper or lower case letters or digits of
.IR expr .
.
.I roff
special characters
(such as
.BR \e(\[aq]a )
count as a single letter.
.
Accent strings are retained but do not count toward the total.
.
.
.TP
.IB expr .l
.I expr
converted to lowercase.
.
.
.TP
.IB expr .u
.I expr
converted to uppercase.
.
.
.TP
.IB expr .c
.I expr
converted to caps and small caps.
.
.
.TP
.IB expr .r
.I expr
reversed so that the surname is first.
.
.
.TP
.IB expr .a
.I expr
with first names abbreviated.
.
Fields specified in the
.B \%abbreviate
command are abbreviated before any labels are evaluated.
.
Thus
.B .a
is useful only when you want a field to be abbreviated in a label
but not in a reference.
.
.
.TP
.IB expr .y
The year part of
.IR expr .
.
.
.TP
.IB expr .+y
The part of
.I expr
before the year,
or the whole of
.I expr
if it does not contain a year.
.
.
.TP
.IB expr .\-y
The part of
.I expr
after the year,
or an empty string if
.I expr
does not contain a year.
.
.
.TP
.IB expr .n
The surname part of
.IR expr .
.
.
.TP
.IB expr1 \[ti] expr2
.I expr1
except that if the last character of
.I expr1
is
.B \-
then it will be replaced by
.IR expr2 .
.
.
.TP
.I expr1 expr2
The catenation of
.I expr1
and
.IR expr2 .
.
.
.TP
.IB expr1 | expr2
If
.I expr1
is non-empty then
.I expr1
otherwise
.IR expr2 .
.
.
.TP
.IB expr1 & expr2
If
.I expr1
is non-empty
then
.I expr2
otherwise an empty string.
.
.
.TP
.IB expr1 ? expr2 : expr3
If
.I expr1
is non-empty
then
.I expr2
otherwise
.IR expr3 .
.
.
.TP
.BI < expr >
The label is in two parts,
which are separated by
.IR expr .
.
Two adjacent two-part labels which have the same first part will be
merged by appending the second part of the second label onto the first
label separated by the string specified in the
.B \%separate\-label\-second\-parts
command
(initially,
a comma followed by a space);
the resulting label will also be a two-part label with the same first
part as before merging,
and so additional labels can be merged into it.
.
It is permissible for the first part to be empty;
this may be desirable for expressions used in the
.B \%short\-label
command.
.
.
.TP
.BI ( expr )
The same as
.IR expr .
.
Used for grouping.
.
.
.LP
The above expressions are listed in order of precedence
(highest first);
.B &
and
.B |
have the same precedence.
.
.
.\" ====================================================================
.SS "Macro interface"
.\" ====================================================================
.
Each reference starts with a call to the macro
.BR ]\- .
.
The string
.B [F
will be defined to be the label for this reference,
unless the
.B \%no\-label\-in\-reference
command has been given.
.
There then follows a series of string definitions,
one for each field:
string
.BI [ X
corresponds to field
.IR X .
.
The register
.B [P
is set to\~1 if the
.B P
field contains a range of pages.
.
The
.BR [T ,
.B [A
and
.B [O
registers are set to\~1 according as the
.BR T ,
.B A
and
.B O
fields end with any of
.B .?!\&
(an end-of-sentence character).
.
The
.B [E
register will be set to\~1 if the
.B [E
string contains more than one name.
.
The reference is followed by a call to the
.B ][
macro.
.
The first argument to this macro gives a number representing
the type of the reference.
.
If a reference contains a
.B J
field,
it will be classified as type\~1,
otherwise if it contains a
.B B
field,
it will be type\~3,
otherwise if it contains a
.B G
or
.B R
field it will be type\~4,
otherwise if it contains an
.B I
field it will be type\~2,
otherwise it will be type\~0.
.
The second argument is a symbolic name for the type:
.BR other ,
.BR \%journal\-article ,
.BR book ,
.BR \%article\-in\-book ,
or
.BR \%tech\-report .
.
Groups of references that have been accumulated or are produced by the
.B \%bibliography
command are preceded by a call to the
.B ]<
macro and followed by a call to the
.B ]>
macro.
.
.
.br
.ne 5v
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-R
Don't recognize lines beginning with
.BR .R1 / .R2 .
.
.
.P
Other options are equivalent to
.I @g@refer
commands.
.
.
.TP 16n
.BI \-a\~ n
.B reverse
.BI A n
.
.
.TP
.B \-b
.B "\%no\-label\-in\-text; \%no\-label\-in\-reference"
.
.
.TP
.B \-B
See below.
.
.
.TP
.BI \-c\~ fields
.B capitalize
.I fields
.
.
.TP
.B \-C
.B compatible
.
.
.TP
.B \-e
.B accumulate
.
.
.TP
.BI \-f\~ n
.B \%label
.BI % n
.
.
.TP
.BI \-i\~ fields
.B search\-ignore
.I fields
.
.
.TP
.B \-k
.B \%label
.B L\[ti]%a
.
.
.TP
.BI \-k\~ field
.B \%label
.IB field \[ti]%a
.
.
.TP
.B \-l
.B \%label
.B A.nD.y%a
.
.
.TP
.BI \-l\~ m
.B \%label
.BI A.n+ m D.y%a
.
.
.TP
.BI \-l\~, n
.B \%label
.BI A.nD.y\- n %a
.
.
.TP
.BI \-l\~ m , n
.B \%label
.BI A.n+ m D.y\- n %a
.
.
.TP
.B \-n
.B \%no\-default\-database
.
.
.TP
.BI \-p\~ db-file
.B database
.I db-file
.
.
.TP
.B \-P
.B move\-punctuation
.
.
.TP
.BI \-s\~ spec
.B sort
.I spec
.
.
.TP
.B \-S
.B \%label \[dq](A.n|Q) \[aq], \[aq] (D.y|D)\[dq]; \
\%bracket-\%label \[dq]\~(\[dq]\~)\~\[dq];\~\[dq]
.
.
.TP
.BI \-t\~ n
.B search\-truncate
.I n
.
.
.P
The
.B B
option has command equivalents with the addition that the file names
specified on the command line are processed as if they were arguments to
the
.B \%bibliography
command instead of in the normal way.
.
.
.TP 16n
.B \-B
.B "annotate X AP; \%no\-label\-in\-reference"
.
.
.TP
.BI \-B\~ field . macro
.B annotate
.I field
.IB macro ;
.B \%no\-label\-in\-reference
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I @g@refer
exits with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP 9n \" "REFER" + 2n + hand-tuned for PDF
.I REFER
Assign this variable a file name to override the default database.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @DEFAULT_INDEX@
Default database.
.
.
.TP
.RI file @INDEX_SUFFIX@
Index files.
.
.
.TP
.I @MACRODIR@/\:refer\:.tmac
defines macros and strings facilitating integration with macro packages
that wish to support
.IR @g@refer .
.
.
.LP
.I @g@refer
uses temporary files.
.
See the
.MR groff @MAN1EXT@
man page for details of where such files are created.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
In label expressions,
.B <>
expressions are ignored inside
.BI . char
expressions.
.
.
.\" ====================================================================
.SH Examples
.\" ====================================================================
.
We can illustrate the operation of
.I @g@refer
with a sample bibliographic database containing one entry and a simple
.I roff
document to cite that entry.
.
.
.P
.RS
.EX
$ \c
.B cat > my\-db\-file
.B %A Daniel P.\[rs]& Friedman
.B %A Matthias Felleisen
.B %C Cambridge, Massachusetts
.B %D 1996
.B %I The MIT Press
.B %T The Little Schemer, Fourth Edition
$ \c
.B refer -p my\-db\-file
.B Read the book
.B .[
.B friedman
.B .]
.B on your summer vacation.
.I <Control+D>
\&.lf 1 \-
Read the book\[rs]*([.1\[rs]*(.]
\&.ds [F 1
\&.]\-
\&.ds [A Daniel P. Friedman and Matthias Felleisen
\&.ds [C Cambridge, Massachusetts
\&.ds [D 1996
\&.ds [I The MIT Press
\&.ds [T The Little Schemer, Fourth Edition
\&.nr [T 0
\&.nr [A 0
\&.][ 2 book
\&.lf 5 \-
on your summer vacation.
.EE
.RE
.
.
.P
The foregoing shows us that
.I @g@refer
(a) produces a label \[lq]1\[rq];
(b) brackets that label with interpolations of the
.RB \[lq] [. \[rq]
and
.RB \[lq] .] \[rq]
strings;
(c) calls a macro
.RB \[lq] ]\- \[rq];
(d) defines strings and registers containing the label and bibliographic
data for the reference;
(e) calls a macro
.RB \[lq] ][ \[rq];
and (f) uses the
.B lf
request to restore the line numbers of the input.
.
As noted in subsection \[lq]Macro interface\[rq] above,
it is the document's responsibility to employ and format the information
usefully.
.
Let us see how we might turn
.MR groff_ms @MAN7EXT@
to this task.
.
.
.P
.RS
.EX
$ \c
.B REFER=my\-db\-file groff \-R \-ms
.B .LP
.B Read the book
.B .[
.B friedman
.B .]
.B on your summer vacation.
.B Commentary is available.\[rs]*{*\[rs]*}
.B .FS \[rs]*{*\[rs]*}
.B Space reserved for penetrating insight.
.B .FE
.EE
.RE
.
.
.LP
.IR ms 's
automatic footnote numbering mechanism is not aware of
.IR @g@refer 's
label numbering,
so we have manually specified a (superscripted) symbolic footnote for
our non-bibliographic aside.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Refer \[em] A Bibliography System\[rq],
by Bill Tuthill,
1983, \" 4.2BSD, /usr/doc/refer/refer.bib
Computing Services,
University of California,
Berkeley.
.
.
.P
\[lq]Some Applications of Inverted Indexes on the Unix System\[rq],
by M.\& E.\& Lesk,
1978,
AT&T Bell Laboratories Computing Science Technical Report No.\& 69.
.
.
.P
.MR @g@indxbib @MAN1EXT@ ,
.MR @g@lookbib @MAN1EXT@ ,
.MR lkbib @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_refer_1_man_C]
.do rr *groff_refer_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
