/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.RowLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;
import org.basex.io.IOContent;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.util.Enums;
import org.basex.util.list.StringList;

final class DialogCsvParser
extends DialogParser {
    private static final String EXAMPLE = "Name,Born?,Comment\n\"John, Adam\\\",1984,";
    private final CsvParserOptions copts;
    private final TextPanel example;
    private final BaseXCombo encoding;
    private final BaseXCheckBox header;
    private final BaseXCombo format;
    private final BaseXCombo separator;
    private final BaseXCheckBox lax;
    private final BaseXCheckBox skipEmpty;
    private final BaseXCheckBox quotes;
    private final BaseXCheckBox backslashes;

    DialogCsvParser(BaseXDialog dialog, MainOptions opts) {
        this.copts = new CsvParserOptions(opts.get(MainOptions.CSVPARSER));
        this.encoding = DialogCsvParser.encoding(dialog, this.copts.get(CsvParserOptions.ENCODING));
        StringList csv = new StringList();
        for (CsvOptions.CsvSep cs : CsvOptions.CsvSep.values()) {
            csv.add(cs.toString());
        }
        this.separator = new BaseXCombo((BaseXWindow)dialog, (String[])csv.finish());
        CsvOptions.CsvSep cs = Enums.get(CsvOptions.CsvSep.class, this.copts.get(CsvOptions.SEPARATOR));
        if (cs != null) {
            this.separator.setSelectedItem(cs.toString());
        }
        String[] formats = (String[])Arrays.stream(new CsvOptions.CsvFormat[]{CsvOptions.CsvFormat.DIRECT, CsvOptions.CsvFormat.ATTRIBUTES, CsvOptions.CsvFormat.W3_XML}).map(CsvOptions.CsvFormat::toString).toArray(String[]::new);
        this.format = new BaseXCombo((BaseXWindow)dialog, formats);
        this.format.setSelectedItem((Object)this.copts.get(CsvOptions.FORMAT));
        this.header = new BaseXCheckBox(dialog, Text.FIRST_LINE_HEADER, this.copts.get(CsvOptions.HEADER) == Bln.TRUE);
        this.quotes = new BaseXCheckBox(dialog, Text.PARSE_QUOTES, CsvOptions.QUOTES, this.copts);
        this.backslashes = new BaseXCheckBox(dialog, Text.BACKSLASHES, CsvOptions.BACKSLASHES, this.copts);
        this.lax = new BaseXCheckBox(dialog, Text.LAX_NAME_CONVERSION, CsvOptions.LAX, this.copts);
        this.skipEmpty = new BaseXCheckBox(dialog, Text.SKIP_EMPTY, CsvParserOptions.SKIP_EMPTY, this.copts);
        this.example = new TextPanel(dialog, false);
        BaseXBack pp = new BaseXBack(new RowLayout(8));
        BaseXBack p = new BaseXBack(new TableLayout(3, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        p.add(this.encoding);
        p.add(new BaseXLabel(Text.SEPARATOR, true, true));
        p.add(this.separator);
        p.add(new BaseXLabel(Text.FORMAT + ":", true, true));
        p.add(this.format);
        pp.add(p);
        p = new BaseXBack(new RowLayout());
        p.add(this.header);
        p.add(this.quotes);
        p.add(this.backslashes);
        p.add(this.lax);
        p.add(this.skipEmpty);
        pp.add(p);
        this.add((Component)pp, "West");
        this.add((Component)this.example, "Center");
        this.action(true);
    }

    @Override
    boolean action(boolean active) {
        try {
            Value value = CsvConverter.get(this.copts).convert(new IOContent(EXAMPLE));
            this.example.setText(DialogCsvParser.example(MainOptions.MainParser.CSV.name(), EXAMPLE, value));
        }
        catch (IOException | QueryException ex) {
            this.example.setText(DialogCsvParser.error(ex));
        }
        return true;
    }

    @Override
    void update() {
        String enc = this.encoding.getSelectedItem();
        this.copts.set(CsvParserOptions.ENCODING, enc.equals("UTF-8") ? null : enc);
        this.copts.set(CsvOptions.HEADER, Bln.get(this.header.isSelected()));
        this.copts.set(CsvOptions.FORMAT, this.format.getSelectedItem());
        this.copts.set(CsvOptions.LAX, this.lax.isSelected());
        this.copts.set(CsvOptions.QUOTES, this.quotes.isSelected());
        this.copts.set(CsvOptions.BACKSLASHES, this.backslashes.isSelected());
        this.copts.set(CsvParserOptions.SKIP_EMPTY, this.skipEmpty.isSelected());
        CsvOptions.CsvSep cs = Enums.get(CsvOptions.CsvSep.class, this.separator.getText());
        if (cs != null) {
            this.copts.set(CsvOptions.SEPARATOR, String.valueOf(cs.sep));
        }
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.CSVPARSER, this.copts);
    }
}

