/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.io.IOException;
import java.util.Locale;
import javax.swing.Box;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogNew;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.BufferInput;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class DialogImport
extends BaseXBack {
    final BaseXLabel info;
    final BaseXCombo input;
    final BaseXButton browse;
    final BaseXCombo parsers;
    String dbName;
    private final GUI gui;
    private final BaseXDialog dialog;
    private final DialogParsing parsing;
    private final BaseXCheckBox addArchives;
    private final BaseXCheckBox archiveName;
    private final BaseXCheckBox skipCorrupt;
    private final BaseXCheckBox addBinary;
    private final BaseXTextField createFilter;

    DialogImport(BaseXDialog dialog, BaseXBack panel, DialogParsing parsing) {
        this.dialog = dialog;
        this.parsing = parsing;
        this.gui = dialog.gui();
        this.layout(new RowLayout());
        this.border(8);
        this.add(new BaseXLabel(Text.FILE_OR_DIR + ":", true, true).border(0, 0, 6, 0));
        String path = this.gui.gopts.get(GUIOptions.INPUTPATH);
        this.input = new BaseXCombo((BaseXWindow)dialog, true, new String[0]).history(GUIOptions.INPUTS, this.gui.gopts);
        BaseXLayout.setWidth(this.input, 450);
        this.input.setText(path);
        IO io = IO.get(path);
        if (io instanceof IOFile && !path.isEmpty()) {
            this.dbName = io.dbName();
        }
        this.browse = new BaseXButton(dialog, Text.BROWSE_D);
        this.browse.addActionListener(e -> this.choose());
        BaseXBack b = new BaseXBack(new ColumnLayout(8));
        b.add(this.input);
        b.add(this.browse);
        this.add(b);
        this.add(panel);
        this.add(Box.createVerticalStrut(12));
        MainOptions opts = this.gui.context.options;
        StringList ps = new StringList();
        for (MainOptions.MainParser mp : MainOptions.MainParser.values()) {
            ps.add(mp.name());
        }
        this.parsers = new BaseXCombo((BaseXWindow)dialog, (String[])ps.finish());
        this.parsers.setSelectedItem(opts.get(MainOptions.PARSER).name());
        this.createFilter = new BaseXTextField(dialog, opts.get(MainOptions.CREATEFILTER));
        this.createFilter.setColumns(30);
        this.addBinary = new BaseXCheckBox(dialog, Text.ADD_BINARY_FILES, MainOptions.ADDRAW, opts);
        this.skipCorrupt = new BaseXCheckBox(dialog, Text.SKIP_CORRUPT_FILES, MainOptions.SKIPCORRUPT, opts);
        this.addArchives = new BaseXCheckBox(dialog, Text.PARSE_ARCHIVES, MainOptions.ADDARCHIVES, opts);
        this.archiveName = new BaseXCheckBox(dialog, Text.ADD_ARCHIVE_NAME, MainOptions.ARCHIVENAME, opts);
        BaseXBack p = new BaseXBack(new TableLayout(2, 2, 20, 0));
        p.add(new BaseXLabel(Text.INPUT_FORMAT, false, true).border(0, 0, 6, 0));
        p.add(new BaseXLabel(Text.FILE_PATTERNS + ":", false, true).border(0, 0, 6, 0));
        p.add(this.parsers);
        p.add(this.createFilter);
        this.add(p);
        this.add(Box.createVerticalStrut(8));
        this.add(this.addBinary);
        this.add(this.skipCorrupt);
        this.add(this.addArchives);
        this.add(this.archiveName);
        this.info = new BaseXLabel(" ").border(20, 0, 6, 0);
        this.add(this.info);
        BaseXLayout.DropHandler dh = object -> {
            this.input.setText(object.toString());
            this.action(this.input, dialog instanceof DialogNew);
        };
        BaseXLayout.addDrop(this, dh);
        BaseXLayout.addDrop(this.input, dh);
    }

    String input() {
        return this.input.getText().trim();
    }

    boolean action(Object comp, boolean empty) {
        boolean ok = this.parsing.action();
        String in = this.input.getText().trim();
        IO io = IO.get(in);
        this.gui.gopts.set(GUIOptions.INPUTPATH, in);
        boolean multi = io.isDir() || io.isArchive();
        this.addArchives.setEnabled(multi);
        this.createFilter.setEnabled(multi);
        this.archiveName.setEnabled(this.addArchives.isSelected());
        MainOptions.MainParser parser = MainOptions.MainParser.valueOf(this.parsers.getSelectedItem());
        boolean binary = parser == MainOptions.MainParser.RAW;
        this.addBinary.setEnabled(multi && !binary && this.gui.context.options.get(MainOptions.MAINMEM) == false);
        this.skipCorrupt.setEnabled(!binary);
        if (comp == this.parsers) {
            this.parsing.setType(parser);
            if (multi) {
                this.createFilter.setText((String)(binary ? "*" : "*." + String.valueOf((Object)parser)));
            }
        }
        boolean bl = empty ? in.isEmpty() || io.exists() : !in.isEmpty() && io.exists();
        if ((ok &= bl) && comp == this.input) {
            this.setType(in);
        }
        this.info.setText(null, null);
        return ok;
    }

    void setOptions() {
        this.gui.set(MainOptions.PARSER, MainOptions.MainParser.valueOf(this.parsers.getSelectedItem()));
        this.gui.set(MainOptions.CREATEFILTER, this.createFilter.getText());
        this.gui.set(MainOptions.ADDARCHIVES, this.addArchives.isSelected());
        this.gui.set(MainOptions.ARCHIVENAME, this.archiveName.isSelected());
        this.gui.set(MainOptions.SKIPCORRUPT, this.skipCorrupt.isSelected());
        this.gui.set(MainOptions.ADDRAW, this.addBinary.isSelected());
        this.input.updateHistory();
        this.parsing.setOptions();
    }

    private void choose() {
        String path = this.input.getText();
        BaseXFileChooser fc = new BaseXFileChooser(this.dialog, Text.FILE_OR_DIR, path);
        fc.textFilters().filter("ZIP Archives", false, IO.ARCHIVESUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
        if (file == null) {
            return;
        }
        this.gui.gopts.setFile(GUIOptions.INPUTPATH, file);
        path = file.path();
        this.input.setText(path);
        this.setType(path);
    }

    void setType(String in) {
        IO io = IO.get(in);
        if (!in.isEmpty() && io instanceof IOFile) {
            this.dbName = io.dbName();
        }
        boolean dir = io.isDir();
        boolean archive = io.isArchive();
        if (dir || archive) {
            return;
        }
        MainOptions.MainParser type = null;
        String path = io.path();
        int i = path.lastIndexOf(46);
        if (i != -1) {
            String suf = path.substring(i).toLowerCase(Locale.ENGLISH);
            if (Strings.eq(suf, this.gui.gopts.xmlSuffixes()) || Strings.eq(suf, IO.XSLSUFFIXES)) {
                type = MainOptions.MainParser.XML;
            } else if (Strings.eq(suf, IO.HTMLSUFFIXES)) {
                type = MainOptions.MainParser.HTML;
            } else if (Strings.eq(suf, ".csv")) {
                type = MainOptions.MainParser.CSV;
            } else if (Strings.eq(suf, ".json")) {
                type = MainOptions.MainParser.JSON;
            }
        }
        if (type == null) {
            type = DialogImport.guess(io);
        }
        this.parsers.setSelectedItem(type.name());
    }

    private static MainOptions.MainParser guess(IO in) {
        if (in.exists() && !(in instanceof IOUrl)) {
            MainOptions.MainParser mainParser;
            block9: {
                BufferInput bi = BufferInput.get(in);
                try {
                    MainOptions.MainParser mainParser2 = mainParser = bi.read() == 60 ? MainOptions.MainParser.XML : MainOptions.MainParser.RAW;
                    if (bi == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bi != null) {
                            try {
                                bi.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        Util.debug(ex);
                    }
                }
                bi.close();
            }
            return mainParser;
        }
        return MainOptions.MainParser.XML;
    }
}

