/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.AbstractButton;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.parse.CommandParser;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXHeader;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXToolBar;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.SyntaxXML;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;

public final class TextView
extends View {
    private final SearchEditor editor;
    private final AbstractButton home;
    private final BaseXLabel label;
    private final TextPanel text;
    private Command cachedCmd;
    private DBNodes cachedNodes;

    public TextView(ViewNotifier notifier) {
        super("text", notifier);
        this.border(5).layout(new BorderLayout(0, 5));
        this.text = new TextPanel(this.gui, false);
        this.text.setSyntax(new SyntaxXML());
        this.editor = new SearchEditor(this.gui, this.text);
        this.label = new BaseXLabel(" ").resize(1.25f);
        AbstractButton save = BaseXButton.get("c_save", Text.SAVE, false, this.gui);
        save.addActionListener(e -> this.save());
        this.home = BaseXButton.command(GUIMenuCmd.C_SHOW_HOME, this.gui);
        this.home.setEnabled(false);
        BaseXToolBar buttons = new BaseXToolBar();
        buttons.add(save);
        buttons.add(this.home);
        buttons.add(this.editor.button());
        BaseXBack north = new BaseXBack(false).layout(new BorderLayout(10, 10));
        north.add((Component)buttons, "West");
        north.add((Component)this.label, "Center");
        north.add((Component)new BaseXHeader(Text.RESULT), "East");
        this.add((Component)north, "North");
        this.add((Component)this.editor, "Center");
        this.refreshLayout();
    }

    public void focusText() {
        this.text.requestFocusInWindow();
    }

    @Override
    public void refreshInit() {
        this.refreshContext(true, true);
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        Context context = this.gui.context;
        DBNodes nodes = context.marked;
        this.setText(nodes != null && nodes.isEmpty() ? context.current() : nodes);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.setText(this.gui.context.current());
    }

    @Override
    public void refreshLayout() {
        this.text.setFont(GUIConstants.mfont);
        this.editor.bar().refreshLayout();
    }

    @Override
    public void refreshUpdate() {
        this.refreshContext(true, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWTEXT);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWTEXT, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    private void setText(DBNodes nodes) {
        Context context = this.gui.context;
        if (this.visible()) {
            try {
                ArrayOutput ao = new ArrayOutput();
                long size = 0L;
                if (nodes != null) {
                    ao.setLimit(this.gui.gopts.get(GUIOptions.MAXTEXT));
                    nodes.serialize(Serializer.get(ao, context.options.get(MainOptions.SERIALIZER)));
                    size = nodes.size();
                }
                this.setText(ao, size, null);
                this.cachedNodes = ao.finished() ? nodes : null;
                this.cachedCmd = null;
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        } else {
            this.home.setEnabled(context.data() != null);
        }
    }

    public void cache(ArrayOutput out, Command command, Value result) throws QueryException {
        this.cachedCmd = null;
        this.cachedNodes = null;
        int max = this.gui.gopts.get(GUIOptions.MAXRESULTS);
        boolean cacheCmd = false;
        if (result != null && result.size() >= (long)max) {
            cacheCmd = true;
        } else if (out.finished()) {
            if (result instanceof DBNodes) {
                DBNodes nodes;
                this.cachedNodes = nodes = (DBNodes)result;
            } else {
                cacheCmd = true;
            }
        }
        if (cacheCmd) {
            this.cachedCmd = CommandParser.get(command.toString(), this.gui.context).parseSingle();
            this.cachedCmd.baseURI(command.baseURI());
        }
    }

    public void setText(ArrayOutput out, long results, Throwable throwable) {
        Object info;
        byte[] buffer = out.buffer();
        int size = (int)out.size();
        byte[] chop = Token.token("...");
        int cl = chop.length;
        if (out.finished() && size >= cl) {
            Array.copyFromStart(chop, cl, buffer, size - cl);
        }
        this.text.setText(buffer, size);
        if (throwable != null) {
            info = throwable.getLocalizedMessage();
        } else {
            info = BaseXLayout.results(results, size, this.gui);
            if (out.finished()) {
                info = (String)info + " (" + Text.CHOPPED + ")";
            }
        }
        this.label.setText((String)info);
        this.home.setEnabled(this.gui.context.data() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.SAVE_AS, this.gui.gopts.get(GUIOptions.WORKPATH)).suffix(".xml");
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return;
        }
        this.gui.gopts.setFile(GUIOptions.WORKPATH, file.parent());
        this.gui.cursor(GUIConstants.CURSORWAIT, true);
        try (PrintOutput out = new PrintOutput(file);){
            Context context = this.gui.context;
            if (this.cachedCmd != null) {
                this.cachedCmd.execute(context, out);
            } else if (this.cachedNodes != null) {
                this.cachedNodes.serialize(Serializer.get(out, context.options.get(MainOptions.SERIALIZER)));
            } else {
                out.write(this.text.getText());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_SAVED_X, file));
        }
        finally {
            this.gui.cursor(GUIConstants.CURSORARROW, true);
        }
    }
}

