/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.util.list.ByteList;

public class BufferInput
extends InputStream {
    final byte[] array;
    int bpos;
    int bsize;
    long length;
    private IO input;
    private final InputStream is;
    private int bmark;
    private long read;

    public static BufferInput get(InputStream is) {
        BufferInput bi;
        return is instanceof BufferInput ? (bi = (BufferInput)is) : new BufferInput(is);
    }

    public static BufferInput get(IO input) throws IOException {
        BufferInput bi;
        InputStream is = input.inputStream();
        return is instanceof BufferInput ? (bi = (BufferInput)is) : new BufferInput(is, input.length());
    }

    public BufferInput(IO input) throws IOException {
        this(input.inputStream());
        this.input = input;
        this.length = input.length();
    }

    protected BufferInput(InputStream is) {
        long l;
        if (is instanceof BufferInput) {
            BufferInput bi = (BufferInput)is;
            l = bi.length;
        } else {
            l = -1L;
        }
        this(is, l);
    }

    private BufferInput(InputStream is, long length) {
        this.is = is;
        this.length = length;
        this.array = new byte[4096];
    }

    protected BufferInput(byte[] array) {
        this.array = array;
        this.bsize = array.length;
        this.length = this.bsize;
        this.is = null;
    }

    public final IO io() {
        return this.input;
    }

    @Override
    public int read() throws IOException {
        return this.readByte();
    }

    protected int readByte() throws IOException {
        int blen = this.array.length;
        byte[] buf = this.array;
        if (this.bpos >= this.bsize) {
            int r;
            this.read += (long)this.bsize;
            if (this.bsize == blen) {
                this.bmark = -1;
                this.bsize = 0;
                this.bpos = 0;
            }
            while ((r = this.is.read(buf, this.bsize, blen - this.bsize)) == 0) {
            }
            if (r < 0) {
                return -1;
            }
            this.bsize += r;
        }
        return buf[this.bpos++] & 0xFF;
    }

    public final String readString() throws IOException {
        int l;
        ByteList bl = new ByteList();
        while ((l = this.read()) > 0) {
            bl.add(l);
        }
        return bl.toString();
    }

    public final byte[] readBytes() throws IOException {
        int l;
        ByteList bl = new ByteList();
        while ((l = this.readByte()) > 0) {
            bl.add(l);
        }
        return bl.finish();
    }

    @Override
    public final void close() throws IOException {
        if (this.is != null && !(this.is instanceof FilterInputStream)) {
            this.is.close();
        }
    }

    public final long size() {
        return this.read + (long)this.bpos;
    }

    public final long length() {
        return this.length;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final void mark(int m) {
        this.bmark = this.bpos;
    }

    @Override
    public final void reset() throws IOException {
        if (this.bmark == -1) {
            throw new IOException("Mark cannot be reset.");
        }
        this.bpos = this.bmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] content() throws IOException {
        try {
            int ch;
            if (this.length > -1L) {
                int sl = (int)Math.min(Integer.MAX_VALUE, this.length);
                byte[] bytes = new byte[sl];
                for (int c = 0; c < sl; ++c) {
                    bytes[c] = (byte)this.readByte();
                }
                byte[] byArray = bytes;
                return byArray;
            }
            ByteList bl = new ByteList();
            while ((ch = this.readByte()) != -1) {
                bl.add(ch);
            }
            byte[] byArray = bl.finish();
            return byArray;
        }
        finally {
            this.close();
        }
    }
}

