/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.Stack;
import org.basex.data.Data;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.scope.StaticDecl;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public final class QueryPlan {
    private static final QNm Q_QUERY_PLAN = new QNm("QueryPlan");
    private static final QNm Q_COMPILED = new QNm("compiled");
    private static final QNm Q_UPDATING = new QNm("updating");
    private final FBuilder root;
    private final Stack<FBuilder> nodes = new Stack();
    private final boolean full;

    public QueryPlan(boolean compiled, boolean updating, boolean full) {
        this.root = FElem.build(Q_QUERY_PLAN).add(Q_COMPILED, compiled).add(Q_UPDATING, updating);
        this.nodes.add(this.root);
        this.full = full;
    }

    public FNode root() {
        return this.root.finish();
    }

    public void add(FBuilder elem, Object ... children) {
        FBuilder plan = this.nodes.peek();
        this.nodes.add(elem);
        for (Object child : children) {
            if (child instanceof ExprInfo) {
                ((ExprInfo)child).toXml(this);
                continue;
            }
            if (child instanceof ExprInfo[]) {
                for (ExprInfo ex : (ExprInfo[])child) {
                    if (ex == null) continue;
                    ex.toXml(this);
                }
                continue;
            }
            if (child instanceof byte[]) {
                elem.add((byte[])child);
                continue;
            }
            elem.add(child);
        }
        plan.add(elem);
        this.nodes.pop();
    }

    public void add(FBuilder elem, ExprInfo ... children) {
        this.add(elem, (Object[])children);
    }

    public FBuilder create(ExprInfo expr, Object ... atts) {
        FBuilder elem = FElem.build(new QNm(Util.className(expr)));
        int al = atts.length;
        for (int a = 0; a < al - 1; a += 2) {
            this.addAttribute(elem, atts[a], atts[a + 1]);
        }
        if (expr instanceof Expr) {
            Expr ex = (Expr)expr;
            this.attachType(elem, ex.seqType(), ex.size(), ex.data());
        } else if (expr instanceof StaticDecl) {
            this.attachType(elem, ((StaticDecl)expr).seqType(), -1L, null);
        }
        InputInfo info = expr.info();
        if (info != null) {
            this.attach(elem, info);
        }
        return elem;
    }

    public FBuilder create(String name, Var var) {
        FBuilder elem = FElem.build(new QNm(Strings.capitalize(name)));
        if (var != null) {
            this.attach(this.attachVariable(elem, var, true), var.info);
        }
        return elem;
    }

    public void addAttribute(FBuilder elem, Object name, Object value) {
        if (value != null) {
            elem.add(new QNm(Util.inf(name, new Object[0])), Util.inf(value, new Object[0]));
        }
    }

    public FBuilder attachVariable(FBuilder elem, Var var, boolean type) {
        if (var != null) {
            this.addAttribute(elem, "name", var.toErrorString());
            this.addAttribute(elem, Token.ID, var.id);
            if (var.declType != null) {
                this.addAttribute(elem, "as", var.declType);
            }
            if (type) {
                this.attachType(elem, var.seqType(), var.size(), var.data());
            }
        }
        return elem;
    }

    private void attachType(FBuilder elem, SeqType seqType, long size, Data data) {
        this.addAttribute(elem, "type", seqType);
        if (size != -1L) {
            this.addAttribute(elem, "size", size);
        }
        if (data != null) {
            this.addAttribute(elem, "database", data.meta.name);
        }
    }

    private void attach(FBuilder elem, InputInfo info) {
        if (this.full) {
            this.addAttribute(elem, "line", info.line());
            this.addAttribute(elem, "column", info.column());
            this.addAttribute(elem, "path", info.path());
        }
    }
}

