/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.client;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.func.client.ClientFn;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FType;
import org.basex.query.value.type.Type;

public final class ClientQuery
extends ClientFn {
    private static final Pattern QUERYPAT = Pattern.compile("\\[(.*?)] (.*)", 8);

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Object value3;
        block15: {
            ClientSession cs = this.session(qc, false);
            String query = this.toString(this.arg(1), qc);
            ValueBuilder vb = new ValueBuilder(qc);
            org.basex.api.client.ClientQuery cq = cs.query(query);
            try {
                for (Map.Entry<String, Value> binding : this.toBindings(this.arg(2), qc).entrySet()) {
                    String key = binding.getKey();
                    Value value2 = binding.getValue();
                    if (key.isEmpty()) {
                        cq.context(value2);
                        continue;
                    }
                    cq.bind(key, value2);
                }
                cq.cache(true);
                while (cq.more()) {
                    value3 = cq.next();
                    Type type = cq.type();
                    if (type instanceof FType) {
                        throw QueryError.CLIENT_FITEM_X.get(this.info, value3);
                    }
                    vb.add(type.cast(value3, qc, this.info));
                }
                value3 = vb.value();
                if (cq == null) break block15;
            }
            catch (Throwable value3) {
                try {
                    if (cq != null) {
                        try {
                            cq.close();
                        }
                        catch (Throwable type) {
                            value3.addSuppressed(type);
                        }
                    }
                    throw value3;
                }
                catch (QueryIOException ex) {
                    throw ex.getCause(this.info);
                }
                catch (BaseXException ex) {
                    Matcher m = QUERYPAT.matcher(ex.getMessage());
                    if (m.find()) {
                        String msg;
                        String name = m.group(1);
                        QueryException exc = QueryError.get(name, msg = m.group(2), this.info);
                        throw exc == null ? new QueryException(this.info, new QNm(name), msg, new Object[0]) : exc;
                    }
                    throw QueryError.CLIENT_QUERY_X.get(this.info, ex);
                }
                catch (IOException ex) {
                    throw QueryError.CLIENT_ERROR_X.get(this.info, ex);
                }
            }
            cq.close();
        }
        return value3;
    }
}

