/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;

public final class FnCount
extends StandardFunc {
    @Override
    public Itr item(QueryContext qc, InputInfo ii) throws QueryException {
        Iter input = this.arg(0).iter(qc);
        long size = input.size();
        if (size == -1L) {
            do {
                ++size;
            } while (qc.next(input) != null);
        }
        return Itr.get(size);
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.COUNT, cc));
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        long size = input.size();
        if (size >= 0L && !input.has(Flag.NDT)) {
            return Itr.get(size);
        }
        if (Function._MAP_KEYS.is(input)) {
            return cc.function(Function._MAP_SIZE, this.info, input.args());
        }
        if (Function._ARRAY_MEMBERS.is(input)) {
            return cc.function(Function._ARRAY_SIZE, this.info, input.args());
        }
        if (Function.STRING_TO_CODEPOINTS.is(input) || Function.CHARACTERS.is(input)) {
            return cc.function(Function.STRING_LENGTH, this.info, input.args());
        }
        return this.embed(cc, true);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        Expr expr = this;
        if (mode == CompileContext.Simplify.EBV) {
            expr = input.seqType().type instanceof NodeType ? input : cc.function(Function.EXISTS, this.info, this.exprs);
        }
        return cc.simplify(this, expr, mode);
    }
}

