/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.query.QueryException;
import org.basex.query.func.validate.ErrorInfo;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

abstract class Validation
extends DefaultHandler {
    private final ArrayList<ErrorInfo> errors = new ArrayList();
    private IOFile schema;

    Validation() {
    }

    abstract void validate() throws IOException, ParserConfigurationException, SAXException, QueryException;

    final IO prepare(IO in) throws IOException {
        if (in instanceof IOContent || in instanceof IOStream) {
            this.schema = new IOFile(File.createTempFile("BaseX-", ".tmp"));
            this.schema.write(in.read());
            return this.schema;
        }
        return in;
    }

    final void finish() {
        if (this.schema != null) {
            this.schema.delete();
        }
    }

    @Override
    public void fatalError(SAXParseException ex) {
        this.add(ex, ErrorInfo.Level.FATAL);
    }

    @Override
    public void error(SAXParseException ex) {
        this.add(ex, ErrorInfo.Level.ERROR);
    }

    @Override
    public void warning(SAXParseException ex) {
        this.add(ex, ErrorInfo.Level.WARNING);
    }

    void add(SAXException ex, ErrorInfo.Level level) {
        this.errors.add(new ErrorInfo(ex, level, this.schema));
    }

    ArrayList<ErrorInfo> getErrors() {
        return this.errors;
    }
}

