/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.scope.AModule;
import org.basex.query.scope.LockVisitor;
import org.basex.query.scope.Scope;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.var.StaticVar;
import org.basex.query.var.VarScope;

public class MainModule
extends AModule {
    public MainModule(Expr expr, VarScope vs, StaticContext sc) {
        super(sc);
        this.expr = expr;
        this.vs = vs;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
        }
        finally {
            cc.removeScope(this);
        }
        return null;
    }

    public Iter iter(final QueryContext qc) throws QueryException {
        final int fp = this.vs.enter(qc);
        final Iter iter = this.expr.iter(qc);
        if (iter.valueIter()) {
            this.vs.exit(fp, qc);
            return iter;
        }
        return new Iter(){
            boolean more = true;

            @Override
            public Item next() throws QueryException {
                if (this.more) {
                    Item item = iter.next();
                    if (item != null) {
                        return item;
                    }
                    this.more = false;
                    MainModule.this.vs.exit(fp, qc);
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(i);
            }

            @Override
            public long size() throws QueryException {
                return iter.size();
            }

            @Override
            public Value value(QueryContext q, Expr ex) throws QueryException {
                return iter.value(qc, ex);
            }
        };
    }

    public final boolean databases(LockVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public final boolean visit(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public final void toXml(QueryPlan plan) {
        this.expr.toXml(plan);
    }

    @Override
    public final void toString(QueryString qs) {
        for (StaticDecl decl : this.references()) {
            qs.token(decl).newline();
        }
        qs.token(this.expr);
    }

    public final List<StaticDecl> references() {
        final ArrayList<StaticDecl> decls = new ArrayList<StaticDecl>();
        final HashSet visited = new HashSet();
        this.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                if (visited.add(var)) {
                    var.visit(this);
                    decls.add(var);
                }
                return true;
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                StaticFunc func = call.func();
                if (func != null && visited.add(func)) {
                    func.visit(this);
                    decls.add(func);
                }
                return true;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                if (visited.add(scope)) {
                    scope.visit(this);
                }
                return true;
            }

            @Override
            public boolean funcItem(FuncItem func) {
                if (visited.add(func)) {
                    func.visit(this);
                }
                return true;
            }
        });
        return decls;
    }
}

