/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.atomic;

import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.query.up.atomic.BasicUpdate;
import org.basex.query.up.atomic.Delete;
import org.basex.query.up.atomic.Replace;
import org.basex.query.up.atomic.StructuralUpdate;

final class Insert
extends StructuralUpdate {
    final DataClip clip;

    private Insert(int location, int shifts, int acc, int first, int parent, DataClip clip) {
        super(location, shifts, acc, first, parent);
        this.clip = clip;
    }

    static Insert getInstance(int pre, int par, DataClip clip) {
        int size = clip.size();
        return new Insert(pre, size, size, pre, par, clip);
    }

    @Override
    void apply(Data data) {
        data.insert(this.location, this.parent, this.clip);
    }

    @Override
    DataClip getInsertionData() {
        return this.clip;
    }

    @Override
    boolean destructive() {
        return false;
    }

    @Override
    public BasicUpdate merge(Data data, BasicUpdate update) {
        if (update instanceof Delete) {
            Delete del = (Delete)update;
            if (this.parent == update.parent && this.location == update.location && data.kind(update.location) != 3) {
                return new Replace(this.location, this.shifts + del.shifts, del.accumulatedShifts, del.preOfAffectedNode, this.clip, this.parent);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "\nInsert: " + super.toString();
    }
}

