/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.util.InputInfo;
import org.basex.util.ft.Language;
import org.basex.util.options.Option;

public final class DBOptimize
extends DBUpdate {
    private final MainOptions options;
    private final QueryContext qc;
    private boolean all;

    public DBOptimize(Data data, boolean all, HashMap<String, String> qopts, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBOPTIMIZE, data, info);
        this.all = all;
        this.qc = qc;
        Option[] supported = (Option[])Arrays.stream(MainOptions.INDEXING).filter(c -> all || c != MainOptions.UPDINDEX).toArray(Option[]::new);
        DBOptions dbopts = new DBOptions(qopts, supported, info);
        MetaData meta = data.meta;
        dbopts.assignIfAbsent(MainOptions.TEXTINDEX, meta.createtext);
        dbopts.assignIfAbsent(MainOptions.ATTRINDEX, meta.createattr);
        dbopts.assignIfAbsent(MainOptions.TOKENINDEX, meta.createtoken);
        dbopts.assignIfAbsent(MainOptions.FTINDEX, meta.createft);
        dbopts.assignIfAbsent(MainOptions.TEXTINCLUDE, meta.textinclude);
        dbopts.assignIfAbsent(MainOptions.ATTRINCLUDE, meta.attrinclude);
        dbopts.assignIfAbsent(MainOptions.TOKENINCLUDE, meta.tokeninclude);
        dbopts.assignIfAbsent(MainOptions.FTINCLUDE, meta.ftinclude);
        dbopts.assignIfAbsent(MainOptions.UPDINDEX, meta.updindex);
        dbopts.assignIfAbsent(MainOptions.AUTOOPTIMIZE, meta.autooptimize);
        dbopts.assignIfAbsent(MainOptions.SPLITSIZE, meta.splitsize);
        dbopts.assignIfAbsent(MainOptions.MAXCATS, meta.maxcats);
        dbopts.assignIfAbsent(MainOptions.MAXLEN, meta.maxlen);
        this.options = dbopts.assignTo(new MainOptions(qc.context.options, false));
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() throws QueryException {
        int maxlen = this.options.get(MainOptions.MAXLEN);
        String textinclude = this.options.get(MainOptions.TEXTINCLUDE);
        String attrinclude = this.options.get(MainOptions.ATTRINCLUDE);
        String tokeninclude = this.options.get(MainOptions.TOKENINCLUDE);
        String ftinclude = this.options.get(MainOptions.FTINCLUDE);
        boolean stemming = this.options.get(MainOptions.STEMMING);
        boolean casesens = this.options.get(MainOptions.CASESENS);
        boolean diacritics = this.options.get(MainOptions.DIACRITICS);
        Language language = Language.get(this.options);
        String stopwords = this.options.get(MainOptions.STOPWORDS);
        MetaData meta = this.data.meta;
        boolean rebuild = maxlen != meta.maxlen;
        boolean rebuildText = !meta.textinclude.equals(textinclude) || rebuild;
        boolean rebuildAttr = !meta.attrinclude.equals(attrinclude) || rebuild;
        boolean rebuildToken = !meta.tokeninclude.equals(tokeninclude);
        boolean rebuildFt = !meta.ftinclude.equals(ftinclude) || rebuild || stemming != meta.stemming || casesens != meta.casesens || diacritics != meta.diacritics || !language.equals(meta.language) || !stopwords.equals(meta.stopwords);
        meta.createtext = this.options.get(MainOptions.TEXTINDEX);
        meta.createattr = this.options.get(MainOptions.ATTRINDEX);
        meta.createtoken = this.options.get(MainOptions.TOKENINDEX);
        meta.createft = this.options.get(MainOptions.FTINDEX);
        meta.maxcats = this.options.get(MainOptions.MAXCATS);
        meta.updindex = this.options.get(MainOptions.UPDINDEX);
        meta.autooptimize = this.options.get(MainOptions.AUTOOPTIMIZE);
        meta.splitsize = this.options.get(MainOptions.SPLITSIZE);
        meta.textinclude = textinclude;
        meta.attrinclude = attrinclude;
        meta.tokeninclude = tokeninclude;
        meta.maxlen = maxlen;
        meta.ftinclude = ftinclude;
        meta.stemming = stemming;
        meta.casesens = casesens;
        meta.diacritics = diacritics;
        meta.language = language;
        meta.stopwords = stopwords;
        try {
            if (this.all) {
                OptimizeAll.optimizeAll(this.data, this.qc.context, this.options, null);
            } else {
                Optimize.optimize(this.data, rebuildText, rebuildAttr, rebuildToken, rebuildFt, null);
            }
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(this.info, ex);
        }
        if (this.all) {
            this.qc.resources.remove(meta.name);
        }
    }

    @Override
    public void merge(Update update) {
        this.all |= ((DBOptimize)update).all;
    }

    @Override
    public int size() {
        return 1;
    }
}

