/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import org.basex.query.util.fingertree.DeepTree;
import org.basex.query.util.fingertree.EmptyTree;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.util.fingertree.SingletonTree;

public final class TreeSlice<N, E> {
    private FingerTree<N, E> tree;
    private NodeLike<N, E> partial;

    TreeSlice(FingerTree<N, E> tree) {
        this.setTree(tree);
    }

    TreeSlice(NodeLike<N, E> partial) {
        this.setNodeLike(partial);
    }

    public boolean isTree() {
        return this.tree != null;
    }

    public FingerTree<N, E> getTree() {
        return this.tree;
    }

    public NodeLike<N, E> getPartial() {
        return this.partial;
    }

    <M> TreeSlice<M, E> setTree(FingerTree<M, E> newTree) {
        TreeSlice out = this;
        out.partial = null;
        out.tree = newTree;
        return out;
    }

    <M> TreeSlice<M, E> setNodeLike(NodeLike<M, E> newNode) {
        TreeSlice out = this;
        if (newNode instanceof Node) {
            out.partial = null;
            out.tree = new SingletonTree((Node)newNode);
        } else {
            out.partial = newNode;
            out.tree = null;
        }
        return out;
    }

    <M> TreeSlice<M, E> setNodes(NodeLike<M, E>[] arr, int n, long size) {
        if (n == 0) {
            return this.setTree(EmptyTree.getInstance());
        }
        if (n == 1) {
            return this.setNodeLike(arr[0]);
        }
        int mid = n / 2;
        Node<M, E>[] left = DeepTree.slice(arr, 0, mid);
        Node<M, E>[] right = DeepTree.slice(arr, mid, n);
        return this.setTree(DeepTree.get(left, right, size));
    }
}

