/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.list;

import java.util.Iterator;
import org.basex.data.Data;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.ItemSeq;
import org.basex.query.value.type.NodeType;
import org.basex.util.list.ObjectList;

public final class ANodeBuilder
extends ObjectList<ANode, ANodeBuilder> {
    private boolean ddo = true;
    private Data data;

    public ANodeBuilder() {
        super(new ANode[1]);
    }

    @Override
    public ANodeBuilder add(ANode node) {
        if (this.isEmpty()) {
            this.data = node.data();
        } else {
            Data dt = this.data;
            if (dt != null && dt != node.data()) {
                this.data = null;
            }
            if (this.ddo) {
                int d = node.compare((ANode)this.peek());
                if (d == 0) {
                    return this;
                }
                if (d < 0) {
                    this.ddo = false;
                }
            }
        }
        return (ANodeBuilder)((Object)super.add(node));
    }

    public Value value(Expr expr) {
        ANode parent;
        this.ddo();
        int sz = this.size;
        if (sz == 0) {
            return Empty.VALUE;
        }
        if (sz == 1) {
            return ((ANode[])this.list)[0];
        }
        if (this.data != null && ((parent = ((ANode[])this.list)[0].parent()) == null || parent.data() == this.data)) {
            int[] pres = new int[sz];
            for (int l = 0; l < sz; ++l) {
                pres[l] = ((DBNode)((ANode[])this.list)[l]).pre();
            }
            return DBNodeSeq.get(pres, this.data, expr);
        }
        return ItemSeq.get(this.finish(), sz, NodeType.NODE.refine(expr));
    }

    public void ddo() {
        if (this.ddo) {
            return;
        }
        int sz = this.size;
        if (sz > 1) {
            this.sort(0, sz);
            int i = 1;
            ANode[] nodes = (ANode[])this.list;
            for (int j = 1; j < sz; ++j) {
                while (j < sz && nodes[i - 1].is(nodes[j])) {
                    ++j;
                }
                if (j >= sz) continue;
                nodes[i++] = nodes[j];
            }
            this.size(i);
        }
        this.ddo = true;
    }

    public Data data() {
        return this.data;
    }

    @Override
    public boolean removeAll(ANode node) {
        if (this.data != null && this.ddo && node instanceof DBNode) {
            DBNode dbnode = (DBNode)node;
            int p = this.binarySearch(dbnode, 0, this.size);
            if (p < 0) {
                return false;
            }
            this.remove(p);
            return true;
        }
        return (boolean)super.removeAll(node);
    }

    @Override
    public boolean contains(ANode node) {
        if (this.data != null && this.ddo) {
            DBNode dbnode;
            return node instanceof DBNode && this.binarySearch(dbnode = (DBNode)node, 0, this.size) > -1;
        }
        return super.contains(node);
    }

    public ANode[] finish() {
        this.ddo();
        return (ANode[])super.finish();
    }

    public int binarySearch(DBNode node, int start, int length) {
        if (node.data() != this.data) {
            return -start - 1;
        }
        int l = start;
        int r = start + length - 1;
        ANode[] nodes = (ANode[])this.list;
        while (l <= r) {
            int npre;
            int m = l + r >>> 1;
            int mpre = ((DBNode)nodes[m]).pre();
            if (mpre == (npre = node.pre())) {
                return m;
            }
            if (mpre < npre) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        return -(l + 1);
    }

    @Override
    public Iterator<ANode> iterator() {
        this.ddo();
        return super.iterator();
    }

    protected ANode[] newArray(int s) {
        return new ANode[s];
    }

    @Override
    public boolean equals(ANode node1, ANode node2) {
        return node1.is(node2);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof ANodeBuilder && super.equals(obj);
    }

    private void sort(int s, int e) {
        int c;
        int a;
        ANode[] nodes = (ANode[])this.list;
        if (e < 7) {
            for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s && nodes[j - 1].compare(nodes[j]) > 0; --j) {
                    this.s(j, j - 1);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        ANode v = nodes[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            int h;
            if (b <= c && (h = nodes[b].compare(v)) <= 0) {
                if (h == 0) {
                    this.s(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (h = nodes[c].compare(v)) >= 0) {
                if (h == 0) {
                    this.s(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(s, k);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k);
        }
    }

    private void s(int a, int b, int n) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i);
        }
    }

    private int m(int a, int b, int c) {
        ANode[] nodes = (ANode[])this.list;
        ANode nodeA = nodes[a];
        ANode nodeB = nodes[b];
        ANode nodeC = nodes[c];
        return nodeA.compare(nodeB) < 0 ? (nodeB.compare(nodeC) < 0 ? b : (nodeA.compare(nodeC) < 0 ? c : a)) : (nodeB.compare(nodeC) > 0 ? b : (nodeA.compare(nodeC) > 0 ? c : a));
    }

    private void s(int a, int b) {
        ANode[] nodes = (ANode[])this.list;
        ANode tmp = nodes[a];
        nodes[a] = nodes[b];
        nodes[b] = tmp;
    }
}

