/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.util.HashMap;
import java.util.HashSet;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.util.pkg.Pkg;
import org.basex.query.util.pkg.PkgComponent;
import org.basex.query.util.pkg.PkgParser;
import org.basex.util.Util;

public final class EXPathRepo {
    private final HashMap<String, HashSet<String>> nsDict = new HashMap();
    private final HashMap<String, Pkg> pkgDict = new HashMap();
    private final StaticOptions sopts;
    private IOFile repo;

    public EXPathRepo(StaticOptions sopts) {
        this.sopts = sopts;
    }

    public EXPathRepo reset() {
        this.repo = null;
        this.nsDict.clear();
        this.pkgDict.clear();
        return this;
    }

    public IOFile path() {
        return this.init().repo;
    }

    public HashMap<String, HashSet<String>> nsDict() {
        return this.init().nsDict;
    }

    public HashMap<String, Pkg> pkgDict() {
        return this.init().pkgDict;
    }

    public IOFile path(String path) {
        return new IOFile(this.path(), path);
    }

    void add(Pkg pkg) {
        this.init();
        this.addPkg(pkg);
    }

    void delete(Pkg pkg) {
        this.init();
        String id = pkg.id();
        for (PkgComponent comp : pkg.comps) {
            String uri = comp.uri;
            HashSet<String> pkgs = this.nsDict.get(uri);
            if (pkgs == null) continue;
            if (pkgs.size() > 1) {
                pkgs.remove(id);
                continue;
            }
            this.nsDict.remove(uri);
        }
        this.pkgDict.remove(id);
    }

    private synchronized EXPathRepo init() {
        if (this.repo == null) {
            this.repo = new IOFile(this.sopts.get(StaticOptions.REPOPATH));
            for (IOFile path : this.repo.children(IOFile.NO_HIDDEN)) {
                if (!path.isDir()) continue;
                this.readPkg(path);
            }
        }
        return this;
    }

    private void readPkg(IOFile dir) {
        IOFile desc = new IOFile(dir, "expath-pkg.xml");
        if (!desc.exists()) {
            return;
        }
        try {
            this.addPkg(new PkgParser(null).parse(desc).path(dir.name()));
        }
        catch (QueryException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    private void addPkg(Pkg pkg) {
        String id = pkg.id();
        for (PkgComponent comp : pkg.comps) {
            if (comp.uri == null) continue;
            this.nsDict.computeIfAbsent(comp.uri, k -> new HashSet()).add(id);
        }
        this.pkgDict.put(id, pkg);
    }
}

