/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.hash.TokenSet;

public final class TokenIntMap
extends TokenSet {
    private int[] values;

    public TokenIntMap() {
        this(2L);
    }

    public TokenIntMap(long capacity) {
        super(capacity);
        this.values = new int[this.capacity()];
        this.values[0] = Integer.MIN_VALUE;
    }

    public TokenIntMap(DataInput in) throws IOException {
        this.read(in);
    }

    @Override
    public void read(DataInput in) throws IOException {
        super.read(in);
        this.values = in.readNums();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeNums(this.values);
    }

    public int put(byte[] key, int value) {
        int i = this.put(key);
        int v = this.values[i];
        this.values[i] = value;
        return v;
    }

    public int get(byte[] key) {
        return this.values[this.index(key)];
    }

    public int value(int index) {
        return this.values[index];
    }

    @Override
    public int remove(byte[] key) {
        int i = super.remove(key);
        this.values[i] = Integer.MIN_VALUE;
        return i;
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public String toString() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        for (int value : this.values) {
            v.add(value);
        }
        return this.toString((Object[])this.keys, v.toArray());
    }
}

