/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.log;

import java.io.FileOutputStream;
import java.io.IOException;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.util.list.StringList;

public final class LogFile {
    private final IOFile file;
    private FileOutputStream fos;

    static LogFile create(String name, IOFile dir) throws IOException {
        LogFile lf = new LogFile(name, dir);
        dir.md();
        lf.fos = new FileOutputStream(lf.file.file(), true);
        return lf;
    }

    LogFile(String name, IOFile dir) {
        this.file = new IOFile(dir, name + ".log");
    }

    public boolean current() {
        return this.fos != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringList read() throws IOException {
        IOFile iOFile = this.file;
        synchronized (iOFile) {
            StringList list = new StringList();
            try (NewlineInput nli = new NewlineInput(this.file);){
                String line;
                while ((line = nli.readLine()) != null) {
                    list.add(line);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        IOFile iOFile = this.file;
        synchronized (iOFile) {
            return this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists() {
        IOFile iOFile = this.file;
        synchronized (iOFile) {
            return this.file.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] line) throws IOException {
        IOFile iOFile = this.file;
        synchronized (iOFile) {
            this.fos.write(line);
            this.fos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        IOFile iOFile = this.file;
        synchronized (iOFile) {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
        }
    }

    boolean valid(String name) {
        return this.file.name().equals(name + ".log");
    }
}

