/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.grammar.Member;

public class RangeMember
extends Member {
    private final Range range;

    public RangeMember(Range range) {
        this.range = range;
    }

    public RangeMember(String firstValue, String lastValue) {
        this(new Range(RangeMember.codepoint(firstValue), RangeMember.codepoint(lastValue)));
    }

    public Range getRange() {
        return this.range;
    }

    private static int codepoint(String value) {
        return RangeMember.isHex(value) ? Codepoint.of(value.substring(1)) : value.codePointAt(0);
    }

    private static boolean isHex(String value) {
        return value.startsWith("#") && value.length() > 1;
    }

    public String toString() {
        return this.range.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeMember)) {
            return false;
        }
        RangeMember other = (RangeMember)obj;
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }
}

