/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.parser;

import java.io.Serializable;

public class Action {
    private final Type type;
    private final int argument;

    public Action(Type type, int argument) {
        this.type = type;
        this.argument = argument;
    }

    public Type getType() {
        return this.type;
    }

    public int getArgument() {
        return this.argument;
    }

    public int code() {
        return Action.code(this.type, this.argument);
    }

    public static int code(Type type, int argument) {
        return (argument << 3) + type.ordinal();
    }

    public static Action of(int code) {
        return new Action(Type.values()[code & 7], code >> 3);
    }

    public String toString() {
        return this.type.toString() + " " + (Serializable)(this.type == Type.ACCEPT ? "" : Integer.valueOf(this.argument));
    }

    public static enum Type {
        ERROR,
        SHIFT,
        SHIFT_REDUCE,
        REDUCE,
        FORK,
        ACCEPT;

        public static final int BITS = 3;

        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }
}

