/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.http.HTTPConnection;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.util.hash.ItemObjectMap;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Strings;
import org.basex.util.XMLToken;
import org.basex.util.http.MediaType;
import org.basex.util.http.Payload;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class RequestContext {
    public final HttpServletRequest request;
    private XQMap values;
    private XQMap form;
    private XQMap headers;
    private IOContent body;
    private final String query;

    public RequestContext(HttpServletRequest request) {
        this.request = request;
        this.query = request.getQueryString();
    }

    public XQMap headers() throws QueryException {
        if (this.headers == null) {
            MapBuilder map = new MapBuilder();
            for (String name : Collections.list(this.request.getHeaderNames())) {
                TokenList list = new TokenList(1L);
                for (String value : Collections.list(this.request.getHeaders(name))) {
                    list.add(value);
                }
                map.put(name, StrSeq.get((TokenList)list));
            }
            this.headers = map.map();
        }
        return this.headers;
    }

    public Map<String, String[]> queryStrings() throws QueryException {
        HashMap<String, String[]> strings = new HashMap<String, String[]>();
        this.queryValues().forEach((key, value) -> {
            StringList list = new StringList(value.size());
            for (Item item : value) {
                list.add((Object)((Atm)item).toJava());
            }
            strings.put(((Str)key).toJava(), (String[])list.finish());
        });
        return strings;
    }

    public XQMap queryValues() throws QueryException {
        if (this.values == null) {
            String string;
            MapBuilder mb = new MapBuilder();
            RequestContext forward = (RequestContext)this.request.getAttribute("forward");
            if (forward != null && forward.query != null) {
                RequestContext.addParams(forward.query, mb);
            }
            if ((string = this.request.getQueryString()) != null) {
                RequestContext.addParams(string, mb);
            }
            this.values = mb.map();
        }
        return this.values;
    }

    public XQMap formValues(MainOptions options) throws QueryException, IOException {
        if (this.form == null) {
            MediaType mt = HTTPConnection.mediaType(this.request);
            if (mt.is(MediaType.MULTIPART_FORM_DATA)) {
                try (ArrayInput is = this.body().inputStream();){
                    this.form = new Payload((InputStream)is, true, null, options).multiForm(mt);
                }
            } else if (mt.is(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
                MapBuilder mb = new MapBuilder();
                RequestContext.addParams(this.body().toString(), mb);
                this.form = mb.map();
            } else {
                this.form = XQMap.empty();
            }
        }
        return this.form;
    }

    public IOContent body() throws IOException {
        if (this.body == null) {
            RequestContext forward = (RequestContext)this.request.getAttribute("forward");
            this.body = forward != null && forward.body != null ? forward.body : new IOContent(BufferInput.get((InputStream)this.request.getInputStream()).content());
        }
        return this.body;
    }

    private static void addParams(String params, MapBuilder mb) throws QueryException {
        ItemObjectMap map = new ItemObjectMap();
        for (String param : Strings.split((String)params, (char)'&')) {
            String[] parts = Strings.split((String)param, (char)'=', (int)2);
            if (parts.length != 2) continue;
            ItemList list = (ItemList)map.computeIfAbsent((Item)Str.get((String)parts[0]), ItemList::new);
            list.add((Object)Atm.get((String)XMLToken.decodeUri((String)parts[1])));
        }
        for (Item key : map) {
            mb.put(key, ((ItemList)map.get(key)).value());
        }
    }
}

