/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;

public class AIEngineResponse {
    @NotNull
    private final AIMessageType type;
    @Nullable
    private final List<String> variants;
    @Nullable
    private final AIFunctionCall functionCall;
    private int inputTokensConsumed;
    private int outputTokensConsumed;
    private int processingTime;

    public AIEngineResponse(@NotNull AIMessageType type, @NotNull List<String> variants) {
        this.type = type;
        this.variants = variants;
        this.functionCall = null;
    }

    public AIEngineResponse(@NotNull AIFunctionCall functionCall) {
        this.type = AIMessageType.FUNCTION;
        this.variants = null;
        this.functionCall = functionCall;
    }

    @NotNull
    public AIMessageType getType() {
        return this.type;
    }

    @Nullable
    public List<String> getVariants() {
        return this.variants;
    }

    @Nullable
    public AIFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public int getInputTokensConsumed() {
        return this.inputTokensConsumed;
    }

    public void setInputTokensConsumed(int inputTokensConsumed) {
        this.inputTokensConsumed = inputTokensConsumed;
    }

    public int getOutputTokensConsumed() {
        return this.outputTokensConsumed;
    }

    public void setOutputTokensConsumed(int outputTokensConsumed) {
        this.outputTokensConsumed = outputTokensConsumed;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    public String toString() {
        return "AI response (" + String.valueOf((Object)this.type) + ") " + String.valueOf(this.variants != null ? this.variants : this.functionCall);
    }
}

