/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleReference;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreTablePolicy
implements DBSObject,
DBPNamedObject2,
DBPSaveableObject {
    private static final Log log = Log.getLog(PostgreTablePolicy.class);
    private final PostgreTable table;
    private String name;
    private PostgreRole role;
    private PolicyType type;
    private PolicyEvent event;
    private String using;
    private String check;
    private boolean persisted;

    public PostgreTablePolicy(@NotNull DBRProgressMonitor monitor, @NotNull PostgreTable table, @NotNull ResultSet results) throws DBException {
        PostgreDatabase database = table.getDatabase();
        this.table = table;
        this.name = JDBCUtils.safeGetString((ResultSet)results, (String)"policyname");
        this.role = database.getRoleByReference(monitor, new PostgreRoleReference(database, Objects.requireNonNull((String[])JDBCUtils.safeGetArray((ResultSet)results, (String)"roles"))[0], null));
        this.type = (PolicyType)CommonUtils.valueOf(PolicyType.class, (String)JDBCUtils.safeGetString((ResultSet)results, (String)"permissive"));
        this.event = (PolicyEvent)CommonUtils.valueOf(PolicyEvent.class, (String)JDBCUtils.safeGetString((ResultSet)results, (String)"cmd"));
        this.using = JDBCUtils.safeGetString((ResultSet)results, (String)"qual");
        this.check = JDBCUtils.safeGetString((ResultSet)results, (String)"with_check");
        this.persisted = true;
    }

    public PostgreTablePolicy(@NotNull PostgreTable table, @NotNull String name) {
        this.table = table;
        this.name = name;
        this.role = null;
        this.type = PolicyType.PERMISSIVE;
        this.event = PolicyEvent.ALL;
        this.using = "";
        this.check = "";
        this.persisted = false;
    }

    @Property(order=1, viewable=true, editable=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(order=2, viewable=true, editable=true, updatable=true, listProvider=RoleListProvider.class)
    @Nullable
    public PostgreRole getRole() {
        return this.role;
    }

    public void setRole(@Nullable PostgreRole role) {
        this.role = role;
    }

    @Property(order=3, viewable=true, editable=true)
    @NotNull
    public PolicyType getType() {
        return this.type;
    }

    public void setType(@NotNull PolicyType type) {
        this.type = type;
    }

    @Property(order=4, viewable=true, editable=true)
    @NotNull
    public PolicyEvent getEvent() {
        return this.event;
    }

    public void setEvent(@NotNull PolicyEvent event) {
        this.event = event;
    }

    @Property(order=5, viewable=true, editable=true, updatable=true)
    @NotNull
    public String getUsing() {
        return this.using;
    }

    public void setUsing(@NotNull String using) {
        this.using = using;
    }

    @Property(order=6, viewable=true, editable=true, updatable=true)
    @NotNull
    public String getCheck() {
        return this.check;
    }

    public void setCheck(@NotNull String check) {
        this.check = check;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @NotNull
    public PostgreTable getParentObject() {
        return this.table;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    public static enum PolicyEvent implements DBPNamedObject
    {
        ALL("All"),
        SELECT("SELECT"),
        INSERT("INSERT"),
        UPDATE("UPDATE"),
        DELETE("DELETE");

        private final String name;

        private PolicyEvent(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }

    public static enum PolicyType implements DBPNamedObject
    {
        PERMISSIVE("Permissive"),
        RESTRICTIVE("Restrictive");

        private final String name;

        private PolicyType(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }

    public static class RoleListProvider
    implements IPropertyValueListProvider<PostgreTablePolicy> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(PostgreTablePolicy object) {
            try {
                ArrayList<? extends PostgreRole> roles = new ArrayList<PostgreRole>();
                roles.add(null);
                roles.addAll(object.table.getDatabase().getUsers((DBRProgressMonitor)new VoidProgressMonitor()));
                return roles.toArray();
            }
            catch (DBException e) {
                log.error((Object)"Error reading roles", (Throwable)e);
                return new Object[0];
            }
        }
    }
}

