/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.oauth.client;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jkiss.utils.CommonUtils;

public class OAuthRequestPostBuilder {
    private URI tokenUri;
    private String clientId;
    private String grantType;
    private String clientSecret;

    public OAuthRequestPostBuilder(String authUrl) {
        if (CommonUtils.isNotEmpty(authUrl)) {
            this.tokenUri = URI.create(authUrl);
        }
    }

    public OAuthRequestPostBuilder withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OAuthRequestPostBuilder withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OAuthRequestPostBuilder withGrantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    public HttpRequest build() {
        HttpRequest.Builder builder = this.tokenUri == null ? HttpRequest.newBuilder() : HttpRequest.newBuilder(this.tokenUri);
        return builder.POST(HttpRequest.BodyPublishers.ofString("&grant_type=" + URLEncoder.encode(this.grantType, StandardCharsets.UTF_8))).header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8))).header("Content-Type", "application/x-www-form-urlencoded").build();
    }
}

