/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.formatter;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterSample;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;

public class DataFormatterDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataFormatterDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataFormatter";
    private final String id;
    private final String name;
    private final String description;
    private final DBPPropertyDescriptor[] properties;
    private DBDDataFormatterSample sample;
    private final AbstractDescriptor.ObjectType formatterType;

    public DataFormatterDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.formatterType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.properties = PropertyDescriptor.extractPropertyGroups(config);
        try {
            Class<?> objectClass = this.getImplClass(config.getAttribute("sampleClass"));
            this.sample = (DBDDataFormatterSample)objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            log.error("Can't instantiate data formatter '" + this.getId() + "' sample");
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBDDataFormatterSample getSample() {
        return this.sample;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        return this.properties;
    }

    @NotNull
    public DBDDataFormatter createFormatter() throws ReflectiveOperationException {
        Class<DBDDataFormatter> clazz = this.formatterType.getObjectClass(DBDDataFormatter.class);
        if (clazz == null) {
            return null;
        }
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

