/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class OpenBrowserHandler
extends AbstractHandler {
    private static final String PARAM_ID_URL = "url";
    private static final String PARAM_ID_BROWSER_ID = "browserId";
    private static final String PARAM_ID_NAME = "name";
    private static final String PARAM_ID_TOOLTIP = "tooltip";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        URL url;
        String urlText = event.getParameter(PARAM_ID_URL);
        if (urlText == null) {
            url = null;
        } else {
            try {
                url = new URL(urlText);
            }
            catch (MalformedURLException ex) {
                throw new ExecutionException("malformed URL:" + urlText, (Throwable)ex);
            }
        }
        String browserId = event.getParameter(PARAM_ID_BROWSER_ID);
        String name = event.getParameter(PARAM_ID_NAME);
        String tooltip = event.getParameter(PARAM_ID_TOOLTIP);
        HandlerUtil.getActiveShellChecked((ExecutionEvent)event).getDisplay().asyncExec(() -> {
            try {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser browser = browserSupport.createBrowser(6, browserId, name, tooltip);
                browser.openURL(url);
            }
            catch (PartInitException ex) {
                WebBrowserUtil.openError(NLS.bind((String)Messages.errorCouldNotLaunchWebBrowser, (Object)url));
            }
        });
        return null;
    }
}

