/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.AppendableChunk;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.nio.AbstractReadbackStrategy;
import com.terracottatech.frs.io.nio.ChannelOpener;
import com.terracottatech.frs.io.nio.MarkerDictionary;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import com.terracottatech.frs.util.LongLongOrderedDeltaArray;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class MappedReadbackStrategy
extends AbstractReadbackStrategy
implements Closeable {
    private final FileChannel source;
    private final AppendableChunk data;
    private final MarkerDictionary boundaries;
    private final ReadWriteLock lock;
    private final ChannelOpener opener;
    private long offset = 0L;
    private long maxMarker = Long.MIN_VALUE;

    public MappedReadbackStrategy(FileChannel src, Direction dir, ChannelOpener opener) throws IOException {
        this.source = src;
        this.opener = opener;
        MappedByteBuffer mapped = src.map(FileChannel.MapMode.READ_ONLY, 0L, (int)src.size());
        this.data = new AppendableChunk(new ByteBuffer[]{mapped});
        this.data.skip(this.source.position());
        this.boundaries = new MarkerDictionary();
        this.createIndex(dir == Direction.RANDOM);
        this.lock = !this.isCloseDetected() ? new ReentrantReadWriteLock() : null;
        this.offset = this.boundaries.isEmpty() ? Long.MIN_VALUE : (dir == Direction.REVERSE ? this.boundaries.lastEntry().getKey() : (dir == Direction.FORWARD ? this.boundaries.firstEntry().getKey() : Long.MIN_VALUE));
    }

    public MappedReadbackStrategy(FileChannel src, Direction dir) throws IOException {
        this(src, dir, null);
    }

    @Override
    public boolean isConsistent() {
        return super.isCloseDetected();
    }

    @Override
    public long getMaximumMarker() {
        return this.maxMarker;
    }

    private void createIndex(boolean full) throws IOException {
        long[] jumps = this.readJumpList(this.data.getBuffers()[0]);
        if (jumps == null) {
            long start = this.data.position();
            ByteBuffer[] chunk = this.readChunk(this.data);
            while (chunk != null) {
                long marker = this.data.getLong(this.data.position() - 12L);
                this.updateMaxMarker(marker);
                this.boundaries.append(marker, start);
                start = this.data.position();
                chunk = this.readChunk(this.data);
            }
            if (this.isCloseDetected()) {
                this.source.close();
            } else {
                this.data.truncate(start);
            }
        } else {
            long last = this.data.position();
            long marker = 0L;
            for (long next : jumps) {
                try {
                    marker = full ? this.data.getLong(next - 12L) : ++marker;
                    this.updateMaxMarker(marker);
                    this.boundaries.append(marker, last);
                }
                catch (Throwable t) {
                    throw new AssertionError((Object)t);
                }
                last = next;
            }
            if (!this.boundaries.isEmpty()) {
                this.updateMaxMarker(this.data.getLong(last - 12L));
            }
            this.source.close();
        }
    }

    private void updateMaxMarker(long marker) {
        if (marker > this.maxMarker) {
            this.maxMarker = marker;
        }
    }

    private void updateIndex() throws IOException {
        long start = this.data.position();
        ByteBuffer[] chunk = this.readChunk(this.data);
        while (chunk != null) {
            long marker = this.data.getLong(this.data.position() - 12L);
            this.updateMaxMarker(marker);
            this.boundaries.append(marker, start);
            start = this.data.position();
            chunk = this.readChunk(this.data);
        }
        if (this.isCloseDetected()) {
            this.data.destroy();
            this.data.append(this.source.map(FileChannel.MapMode.READ_ONLY, 0L, this.source.size()));
            if (this.data.remaining() < this.boundaries.lastEntry().getValue()) {
                throw new AssertionError((Object)("bad boundaries " + this.data.remaining() + " " + this.boundaries.lastEntry().getValue()));
            }
            this.source.close();
        } else if (this.data.hasRemaining()) {
            this.data.truncate(start);
            if (this.data.position() != start) {
                throw new AssertionError((Object)"bad truncation");
            }
            if (this.data.length() != start) {
                throw new AssertionError((Object)"bad truncation");
            }
        }
    }

    private boolean addData() throws IOException {
        if (!this.isCloseDetected() && this.data.position() != this.source.size()) {
            long len = this.data.position();
            if (this.data.hasRemaining()) {
                throw new AssertionError((Object)"bad tail");
            }
            MappedByteBuffer buffer = this.source.map(FileChannel.MapMode.READ_ONLY, len, this.source.size() - len);
            this.data.append(buffer);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk iterate(Direction dir) throws IOException {
        Chunk chunk;
        Long key = null;
        try {
            LongLongOrderedDeltaArray.LongLongEntry e = dir == Direction.FORWARD ? this.boundaries.ceilingEntry(this.offset) : this.boundaries.floorEntry(this.offset);
            key = e.getKey();
            long start = e.getValue();
            chunk = this.getArbitraryChunkFromStart(start);
            this.offset = dir == Direction.FORWARD ? key + 1L : key - 1L;
        }
        catch (Throwable throwable) {
            this.offset = dir == Direction.FORWARD ? key + 1L : key - 1L;
            throw throwable;
        }
        return chunk;
    }

    @Override
    public boolean hasMore(Direction dir) throws IOException {
        try {
            if (this.boundaries.isEmpty()) {
                return false;
            }
            if (dir == Direction.FORWARD) {
                return this.boundaries.lastEntry().getKey() >= this.offset;
            }
            return this.boundaries.firstEntry().getKey() <= this.offset;
        }
        catch (NoSuchElementException no) {
            return false;
        }
    }

    public Chunk getBuffer() {
        return this.data.copy();
    }

    @Override
    public void close() throws IOException {
        if (this.opener == null) {
            if (this.source.isOpen()) {
                this.source.close();
            }
        } else {
            this.opener.close();
        }
        this.boundaries.clear();
        this.data.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk scan(long marker) throws IOException {
        Lock l = null;
        while (!this.isCloseDetected() && this.boundaries.lastEntry().getKey() < marker) {
            l = this.lock.writeLock();
            try {
                l.lock();
                if (!this.addData()) continue;
                this.updateIndex();
            }
            finally {
                l.unlock();
            }
        }
        if (this.lock != null) {
            l = this.lock.readLock();
        }
        try {
            LongLongOrderedDeltaArray.LongLongEntry m;
            if (l != null) {
                l.lock();
            }
            if ((m = this.boundaries.ceilingEntry(marker)) == null) {
                Chunk chunk = null;
                return chunk;
            }
            Chunk chunk = this.getArbitraryChunkFromStart(m.getValue());
            return chunk;
        }
        finally {
            if (l != null) {
                l.unlock();
            }
        }
    }

    @Override
    public long size() throws IOException {
        try {
            return this.source.size();
        }
        catch (IOException ioe) {
            return this.data.length();
        }
    }

    Chunk getArbitraryChunkFromStart(long start) {
        AppendableChunk value = this.data.copy();
        value.skip(start);
        int cs = value.getInt();
        if (!SegmentHeaders.CHUNK_START.validate(cs)) {
            throw new AssertionError((Object)"not valid");
        }
        long len = value.getLong();
        Chunk rv = value.getChunk(len);
        if (value.getLong() != len) {
            throw new AssertionError((Object)"not valid");
        }
        return rv;
    }

    private class Marker {
        private final long start;
        private final long mark;

        public Marker(long start, long mark) {
            this.start = start;
            this.mark = mark;
        }

        public long getStart() {
            return this.start;
        }

        public long getMark() {
            return this.mark;
        }

        public Chunk getChunk() {
            AppendableChunk value = MappedReadbackStrategy.this.data.copy();
            value.skip(this.start);
            int cs = value.getInt();
            if (!SegmentHeaders.CHUNK_START.validate(cs)) {
                throw new AssertionError((Object)"not valid");
            }
            long len = value.getLong();
            Chunk rv = value.getChunk(len);
            if (value.getLong() != len) {
                throw new AssertionError((Object)"not valid");
            }
            return rv;
        }
    }
}

