/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.timeplus;

import java.util.Map;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class TimeplusConfigurationExtension
implements ConfigurationExtension {
    private static final String CLUSTER_NAME = "flyway.timeplus.clusterName";
    private static final String ZOOKEEPER_PATH = "flyway.timeplus.zookeeperPath";
    private static final String ZOOKEEPER_PATH_DEFAULT_VALUE = "/timeplus/tables/{shard}/{database}/{table}";
    private String clusterName;
    private String zookeeperPath = "/timeplus/tables/{shard}/{database}/{table}";

    public String getNamespace() {
        return "timeplus";
    }

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        String zookeeperPath;
        String clusterName = configuration.remove(CLUSTER_NAME);
        if (clusterName != null) {
            this.clusterName = clusterName;
        }
        if ((zookeeperPath = configuration.remove(ZOOKEEPER_PATH)) != null) {
            this.zookeeperPath = zookeeperPath;
        }
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        if ("FLYWAY_TIMEPLUS_CLUSTER_NAME".equals(environmentVariable)) {
            return CLUSTER_NAME;
        }
        if ("FLYWAY_TIMEPLUS_ZOOKEEPER_PATH".equals(environmentVariable)) {
            return ZOOKEEPER_PATH;
        }
        return null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getZookeeperPath() {
        return this.zookeeperPath;
    }
}

