/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.metadatautil;

import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.AETypeNormalizer;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.databricks.client.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.conv.CharConverter;
import com.databricks.client.support.conv.ConversionResult;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AELiteralMetadataFactory {
    private static final Pattern NUM_PATTERN = Pattern.compile("[+-]?0*((?:[1-9]\\d*)?)(?:[.](\\d*?)0*)?(?:[eE]([+-]?\\d+))?$");
    private static final SqlTypes[] INTEGER_TYPE_CAP_ORDER = new SqlTypes[]{SqlTypes.SQL_TINYINT, SqlTypes.SQL_SMALLINT, SqlTypes.SQL_INTEGER, SqlTypes.SQL_BIGINT};
    private AETypeNormalizer m_normalizer;
    private AECoercionProperties m_properties;

    public AELiteralMetadataFactory(AETypeNormalizer aETypeNormalizer, AECoercionProperties aECoercionProperties) {
        this.m_normalizer = aETypeNormalizer;
        this.m_properties = aECoercionProperties;
    }

    public ColumnMetadata determineLiteralType(String string, ICoercionHandler.LiteralType literalType) throws ErrorException {
        switch (literalType) {
            case UNSIGNED_INT: {
                return this.createIntMetadata(string, false);
            }
            case SIGNED_INT: {
                return this.createIntMetadata(string, true);
            }
            case APROX_NUM: 
            case EXACT_NUM: {
                return this.createNumMetadata(string);
            }
            case DATE: {
                return this.createDateMetadata(string);
            }
            case TIME: {
                return this.createTimeMetaData(string);
            }
            case TIMESTAMP: {
                return this.createTimestampMetadata(string);
            }
            case UNKNOWN: 
            case CHAR: 
            case DATATYPE: {
                return this.createCharMetadata(string);
            }
            case BINARY: {
                return this.createBinaryMetadata(string);
            }
        }
        throw new AssertionError((Object)("Case not implemented: " + string + ", " + (Object)((Object)literalType)));
    }

    private ColumnMetadata createBinaryMetadata(String string) throws ErrorException {
        assert (string.length() % 2 == 0);
        SqlTypes sqlTypes = this.m_normalizer.fitBinaryOrCharType(SqlTypes.SQL_BINARY, string.length() / 2);
        ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(sqlTypes.getSqlType()));
        try {
            columnMetadata.setColumnLength(string.length() / 2);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.numericOverflowException("Column length of " + string.length() / 2 + " is too long. ");
        }
        return columnMetadata;
    }

    private ColumnMetadata createCharMetadata(String string) throws ErrorException {
        long l = string.length();
        SqlTypes sqlTypes = this.m_normalizer.fitBinaryOrCharType(SqlTypes.SQL_CHAR, l);
        ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(sqlTypes.getSqlType()));
        try {
            columnMetadata.setColumnLength(l);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.numericOverflowException("Column length is too long. ");
        }
        return columnMetadata;
    }

    private ColumnMetadata createNumMetadata(String string) throws ErrorException {
        PrecisionScale precisionScale = AELiteralMetadataFactory.determinePrecisionScale(string);
        SqlTypes sqlTypes = null;
        sqlTypes = SqlTypes.SQL_DECIMAL;
        SqlTypes sqlTypes2 = this.m_normalizer.normalizeType(sqlTypes);
        if (null == sqlTypes2) {
            sqlTypes2 = sqlTypes == SqlTypes.SQL_DECIMAL ? this.m_normalizer.normalizeType(SqlTypes.SQL_DOUBLE) : this.m_normalizer.normalizeType(SqlTypes.SQL_DECIMAL);
        }
        if (null == sqlTypes2) {
            throw new IllegalStateException("Lack of fractional number support.");
        }
        if (sqlTypes2.isExactNum()) {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(sqlTypes2.getSqlType());
            typeMetadata.setPrecision((short)precisionScale.precision);
            typeMetadata.setScale((short)precisionScale.scale);
            return new ColumnMetadata(typeMetadata);
        }
        if (!sqlTypes2.isNumber()) {
            throw new IllegalStateException("Number type is normalized to none number type. " + sqlTypes2.name());
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(sqlTypes2.getSqlType());
        return new ColumnMetadata(typeMetadata);
    }

    private ColumnMetadata createTimestampMetadata(String string) throws ErrorException {
        if (!AELiteralMetadataFactory.isLegalTimestamp(string)) {
            throw SQLEngineExceptionFactory.invalidFormatException("TIMESTAMP", string);
        }
        SqlTypes sqlTypes = this.m_normalizer.normalizeType(SqlTypes.SQL_TIMESTAMP);
        if (sqlTypes != SqlTypes.SQL_TIMESTAMP) {
            throw new IllegalStateException("Normalized to different type for TIMESTAMP type: result type: " + (Object)((Object)sqlTypes));
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(93);
        int n = string.indexOf(46);
        if (n != -1) {
            short s = (short)(string.length() - n - 1);
            typeMetadata.setPrecision(s);
            typeMetadata.setScale(s);
        }
        return new ColumnMetadata(typeMetadata);
    }

    private ColumnMetadata createTimeMetaData(String string) throws ErrorException {
        if (!AELiteralMetadataFactory.isLegalTime(string)) {
            throw SQLEngineExceptionFactory.invalidFormatException("TIME", string);
        }
        SqlTypes sqlTypes = this.m_normalizer.normalizeType(SqlTypes.SQL_TIME);
        if (sqlTypes != SqlTypes.SQL_TIME) {
            throw new IllegalStateException("Normalized to different type for TIME type: result type: " + (Object)((Object)sqlTypes));
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(92);
        int n = string.indexOf(46);
        if (n != -1) {
            short s = (short)(string.length() - n - 1);
            typeMetadata.setPrecision(s);
            typeMetadata.setScale(s);
        }
        return new ColumnMetadata(typeMetadata);
    }

    private ColumnMetadata createDateMetadata(String string) throws ErrorException {
        if (!AELiteralMetadataFactory.isLegalDate(string)) {
            throw SQLEngineExceptionFactory.invalidFormatException("DATE", string);
        }
        SqlTypes sqlTypes = this.m_normalizer.normalizeType(SqlTypes.SQL_DATE);
        if (sqlTypes != SqlTypes.SQL_DATE) {
            throw new IllegalStateException("Normalized to different type for DATE type: result type: " + (Object)((Object)sqlTypes));
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(91);
        return new ColumnMetadata(typeMetadata);
    }

    private ColumnMetadata createIntMetadata(String string, boolean bl) throws ErrorException {
        if ((string = string.trim()).charAt(0) == '+') {
            string = string.substring(1).trim();
        } else if (string.charAt(0) == '-' && !bl) {
            throw SQLEngineExceptionFactory.invalidFormatException("Unsigned integer", string);
        }
        if (!AELiteralMetadataFactory.isLegalInteger(string)) {
            throw SQLEngineExceptionFactory.invalidFormatException("Integer", string);
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.createColumnForHugeInt(string, bl);
        }
        SqlTypes sqlTypes = null;
        sqlTypes = l >= -128L && l <= 127L ? SqlTypes.SQL_TINYINT : (l >= -32768L && l <= 32767L ? SqlTypes.SQL_SMALLINT : (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? SqlTypes.SQL_INTEGER : SqlTypes.SQL_BIGINT));
        SqlTypes sqlTypes2 = this.m_normalizer.normalizeType(sqlTypes);
        if (sqlTypes2 != null && !sqlTypes2.isInteger()) {
            throw SQLEngineExceptionFactory.invalidOperationException("Normalized to none integer type: " + (Object)((Object)sqlTypes2));
        }
        if (sqlTypes2 == null || AELiteralMetadataFactory.compareIntTypeCapacity(sqlTypes2, sqlTypes) < 0) {
            return this.createColumnForHugeInt(string, bl);
        }
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(sqlTypes2.getSqlType(), true));
    }

    private ColumnMetadata createColumnForHugeInt(String string, boolean bl) throws ErrorException {
        SqlTypes sqlTypes = null;
        if (string.length() <= this.m_properties.getMaxExactNumPrecision()) {
            sqlTypes = this.m_normalizer.normalizeType(SqlTypes.SQL_DECIMAL);
        }
        if (sqlTypes == null) {
            sqlTypes = this.m_normalizer.normalizeType(SqlTypes.SQL_DOUBLE);
        }
        if (sqlTypes == null) {
            throw SQLEngineExceptionFactory.invalidFormatException("Integer", string);
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(sqlTypes.getSqlType(), bl);
        if (sqlTypes.isExactNum()) {
            typeMetadata.setPrecision((short)string.length());
            typeMetadata.setScale((short)0);
        }
        return new ColumnMetadata(typeMetadata);
    }

    private static PrecisionScale determinePrecisionScale(String string) throws ErrorException {
        int n;
        Matcher matcher = NUM_PATTERN.matcher(string.trim());
        if (!matcher.matches()) {
            throw SQLEngineExceptionFactory.invalidFormatException("NUMBER", string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        int n2 = 0;
        if (string3 == null) {
            string3 = "";
        }
        if (string4 != null) {
            int n3 = n2 = string4.charAt(0) == '+' ? Integer.parseInt(string4.substring(1)) : Integer.parseInt(string4);
        }
        if (string2.length() == 0 && string3.length() == 0) {
            return new PrecisionScale(1, 0);
        }
        int n4 = string2.length() + n2;
        int n5 = string2.length() + string3.length();
        if (string2.length() == 0 && n4 > 0) {
            n = AELiteralMetadataFactory.numOfLeadingZeroes(string3, n4);
            n4 -= n;
            n5 -= n;
        }
        if (string3.length() == 0 && n4 < string2.length()) {
            n = AELiteralMetadataFactory.numOfTrailing0(string2, n4 - 1);
            n5 -= n;
        }
        n = 0;
        int n6 = 0;
        if (n4 < 0) {
            n6 = n = -1 * n4 + n5;
        } else if (n4 > n5) {
            n = n4;
            n6 = 0;
        } else {
            n = n5;
            n6 = n5 - n4;
        }
        return new PrecisionScale(n, n6);
    }

    private static int numOfLeadingZeroes(String string, int n) {
        assert (n >= 0);
        assert (string != null);
        assert (!string.equals(""));
        for (int i = 0; i < n && i < string.length(); ++i) {
            if (string.charAt(i) == '0') continue;
            return i;
        }
        return Math.min(string.length(), n);
    }

    private static int numOfTrailing0(String string, int n) {
        assert (string != null);
        assert (!string.equals(""));
        for (int i = string.length() - 1; i > n && i >= 0; --i) {
            if (string.charAt(i) == '0') continue;
            return string.length() - i - 1;
        }
        return string.length() - Math.max(0, n + 1);
    }

    private static boolean isLegalTime(String string) {
        return AELiteralMetadataFactory.isLegalTimestamp("1997-05-06 " + string);
    }

    private static boolean isLegalDate(String string) {
        ConversionResult conversionResult = new ConversionResult();
        CharConverter.toDate(string, conversionResult, null);
        return ConversionResult.TypeConversionState.SUCCESS == conversionResult.getState() || ConversionResult.TypeConversionState.DATETIME_OVERFLOW == conversionResult.getState();
    }

    private static boolean isLegalTimestamp(String string) {
        ConversionResult conversionResult = new ConversionResult();
        CharConverter.tsStrToTimestamp(string, conversionResult, (short)9, null);
        return ConversionResult.TypeConversionState.SUCCESS == conversionResult.getState() || ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN == conversionResult.getState();
    }

    private static boolean isLegalInteger(String string) {
        if (string.charAt(0) == '-') {
            string = string.substring(1);
        }
        if (string.length() < 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '9' && string.charAt(i) >= '0') continue;
            return false;
        }
        return true;
    }

    private static int compareIntTypeCapacity(SqlTypes sqlTypes, SqlTypes sqlTypes2) {
        assert (sqlTypes.isInteger() && sqlTypes2.isInteger());
        assert (Arrays.asList(INTEGER_TYPE_CAP_ORDER).containsAll(Arrays.asList(sqlTypes, sqlTypes2)));
        if (sqlTypes == sqlTypes2) {
            return 0;
        }
        for (SqlTypes sqlTypes3 : INTEGER_TYPE_CAP_ORDER) {
            if (sqlTypes3 == sqlTypes) {
                return -1;
            }
            if (sqlTypes3 != sqlTypes2) continue;
            return 1;
        }
        throw new IllegalStateException("Logic error.");
    }

    private static final class PrecisionScale {
        public final int precision;
        public final int scale;

        public PrecisionScale(int n, int n2) {
            this.precision = n;
            this.scale = n2;
        }
    }
}

