/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.Pair;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ErrorException;

public class CharAddFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        boolean bl;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        Pair<Long, Long> pair = this.getRetrievalIndices(eTDataRequest);
        long l = pair.key();
        long l2 = pair.value();
        String string = iSqlDataWrapper.getChar();
        String string2 = iSqlDataWrapper2.getChar();
        String string3 = this.subString(string, string2, l, l2);
        long l3 = eTDataRequest.getColumn().getColumnLength();
        eTDataRequest.getData().setChar(string3);
        boolean bl2 = bl = l2 < (long)string.length() + (long)string2.length();
        if (null != iWarningListener && l2 == l3 && bl) {
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
            return false;
        }
        return bl;
    }

    private String subString(String string, String string2, long l, long l2) {
        assert (l >= 0L);
        assert (l2 > l || l2 == 0L && l == 0L);
        if (l > (long)string.length() + (long)string2.length()) {
            throw new IllegalArgumentException("Invalid offset for data retrieval");
        }
        if (l >= (long)string.length()) {
            l -= (long)string.length();
            if ((l2 -= (long)string.length()) > (long)string2.length()) {
                l2 = string2.length();
            }
            return string2.substring((int)l, (int)l2);
        }
        if (l2 <= (long)string.length()) {
            return string.substring((int)l, (int)l2);
        }
        String string3 = string.substring((int)l);
        l2 -= (long)string.length();
        l2 = Math.min((long)(Integer.MAX_VALUE - string3.length()), Math.min((long)string2.length(), l2));
        return string3 + string2.substring(0, (int)l2);
    }

    private Pair<Long, Long> getRetrievalIndices(ETDataRequest eTDataRequest) {
        long l = eTDataRequest.getMaxSize();
        long l2 = eTDataRequest.getOffset();
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException("Invalid max retrieval size: " + l);
        }
        if (l2 % 2L == 1L || l2 < 0L) {
            throw new IllegalStateException("Invalid offset value: " + l2);
        }
        l2 /= 2L;
        long l3 = eTDataRequest.getColumn().getColumnLength();
        if (l == -1L) {
            return new Pair<Long, Long>(l2, l3);
        }
        return new Pair<Long, Long>(l2, Math.min(l3, l2 + l / 2L));
    }
}

