/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { BaseToolInvocation, } from '../tools/tools.js';
/**
 * A tool invocation that proxies to a remote A2A agent.
 *
 * This implementation bypasses the local `LocalAgentExecutor` loop and directly
 * invokes the configured A2A tool.
 */
export class RemoteAgentInvocation extends BaseToolInvocation {
    definition;
    constructor(definition, params, messageBus) {
        super(params, messageBus, definition.name, definition.displayName);
        this.definition = definition;
    }
    getDescription() {
        return `Calling remote agent ${this.definition.displayName ?? this.definition.name}`;
    }
    async getConfirmationDetails(_abortSignal) {
        // TODO: Implement confirmation logic for remote agents.
        return false;
    }
    async execute(_signal) {
        // TODO: Implement remote agent invocation logic.
        throw new Error(`Remote agent invocation not implemented.`);
    }
}
//# sourceMappingURL=remote-invocation.js.map