/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/* eslint-disable @typescript-eslint/no-explicit-any */
import { LoadedSettings, createTestMergedSettings, } from '../config/settings.js';
/**
 * Creates a mock LoadedSettings object for testing.
 *
 * @param overrides - Partial settings or LoadedSettings properties to override.
 *                   If 'merged' is provided, it overrides the computed merged settings.
 *                   Any functions in overrides are assigned directly to the LoadedSettings instance.
 */
export const createMockSettings = (overrides = {}) => {
    const { system, systemDefaults, user, workspace, isTrusted, errors, merged: mergedOverride, ...settingsOverrides } = overrides;
    const loaded = new LoadedSettings(system || { path: '', settings: {}, originalSettings: {} }, systemDefaults || { path: '', settings: {}, originalSettings: {} }, user || {
        path: '',
        settings: settingsOverrides,
        originalSettings: settingsOverrides,
    }, workspace || { path: '', settings: {}, originalSettings: {} }, isTrusted ?? true, errors || []);
    if (mergedOverride) {
        // @ts-expect-error - overriding private field for testing
        loaded._merged = createTestMergedSettings(mergedOverride);
    }
    // Assign any function overrides (e.g., vi.fn() for methods)
    for (const key in overrides) {
        if (typeof overrides[key] === 'function') {
            loaded[key] = overrides[key];
        }
    }
    return loaded;
};
//# sourceMappingURL=settings.js.map