/*
 * Decompiled with CFR 0.152.
 */
package resources;

import generic.theme.GIcon;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import resources.ResourceManager;

public class MultiIcon
implements Icon {
    private List<Icon> iconList;
    private boolean disabled;
    private boolean loaded;
    private int height;
    private int width;
    private String description;

    public MultiIcon(Icon baseIcon) {
        this(baseIcon, false);
    }

    public MultiIcon(Icon baseIcon, boolean disabled) {
        Objects.requireNonNull(baseIcon, "baseIcon may not be null");
        this.disabled = disabled;
        this.iconList = new ArrayList<Icon>(4);
        this.addIcon(baseIcon);
    }

    public MultiIcon(Icon baseIcon, Icon ... icons) {
        this(baseIcon, false);
        for (Icon icon : icons) {
            this.iconList.add(icon);
        }
    }

    public MultiIcon(Icon baseIcon, boolean disabled, int width, int height) {
        this.iconList = new ArrayList<Icon>(4);
        this.iconList.add(baseIcon);
        this.width = width;
        this.height = height;
        this.loaded = true;
        this.disabled = disabled;
    }

    public void addIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        this.iconList.add(icon);
    }

    private void init() {
        if (!this.loaded) {
            this.loaded = true;
            this.height = 0;
            this.width = 0;
            for (Icon icon : this.iconList) {
                this.height = Math.max(this.height, icon.getIconHeight());
                this.width = Math.max(this.width, icon.getIconWidth());
            }
        }
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.iconList.get(0).toString();
        }
        return this.description;
    }

    @Override
    public int getIconHeight() {
        this.init();
        return this.height;
    }

    @Override
    public int getIconWidth() {
        this.init();
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.init();
        for (Icon icon : this.iconList) {
            icon.paintIcon(c, g, x, y);
        }
        if (this.disabled) {
            Color bgColor = c != null ? c.getBackground() : Color.gray;
            g.setColor(ColorUtils.withAlpha(bgColor, 128));
            g.fillRect(x, y, this.width, this.height);
        }
    }

    public Icon[] getIcons() {
        return this.iconList.toArray(new Icon[this.iconList.size()]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getIconNames() + "]";
    }

    private String getIconNames() {
        StringBuffer buffy = new StringBuffer();
        for (Icon icon : this.iconList) {
            String name;
            if (buffy.length() > 0) {
                buffy.append(", ");
            }
            if ((name = this.getIconId(icon)) == null) {
                name = ResourceManager.getIconName(icon);
            }
            buffy.append(name);
        }
        return buffy.toString();
    }

    private String getIconId(Icon icon) {
        if (icon instanceof GIcon) {
            GIcon gIcon = (GIcon)icon;
            return gIcon.getId();
        }
        return null;
    }
}

