/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import generic.theme.Gui;
import ghidra.app.plugin.core.archive.ArchivePlugin;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArchiveDialog
extends ReusableDialogComponentProvider {
    private static final int NUM_TEXT_COLUMNS = 40;
    private boolean actionComplete;
    private JLabel archiveLabel;
    private JTextField archiveField;
    private JButton archiveBrowse;
    private ProjectLocator projectLocator;
    private String archivePathName;

    ArchiveDialog(ArchivePlugin plugin) {
        super("Archive Current Project");
        this.initialize();
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Archive_Project"));
    }

    protected void initialize() {
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    protected JPanel buildMainPanel() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel outerPanel = new JPanel(gbl);
        outerPanel.getAccessibleContext().setAccessibleName("Archive");
        this.archiveLabel = new GDLabel(" Archive File ");
        this.archiveField = new JTextField();
        this.archiveField.setName("archiveField");
        this.archiveField.getAccessibleContext().setAccessibleName("Archive Field");
        this.archiveField.setColumns(40);
        this.archiveBrowse = new JButton(". . .");
        this.archiveBrowse.addActionListener(e -> {
            this.archivePathName = this.archiveField.getText().trim();
            Object archName = this.chooseArchiveFile("Choose archive file", "Selects the archive file");
            if (archName != null) {
                if (!((String)archName).endsWith(".gar")) {
                    archName = (String)archName + ".gar";
                }
                this.archivePathName = archName;
                this.archiveField.setText(this.archivePathName);
            }
        });
        Gui.registerFont((JComponent)this.archiveBrowse, (int)1);
        this.archiveBrowse.setName("archiveBrowse");
        this.archiveBrowse.getAccessibleContext().setAccessibleName("Browse Archive");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(this.archiveLabel, gbc);
        outerPanel.add(this.archiveLabel);
        gbc.anchor = 10;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbl.setConstraints(this.archiveField, gbc);
        outerPanel.add(this.archiveField);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbl.setConstraints(this.archiveBrowse, gbc);
        outerPanel.add(this.archiveBrowse);
        return outerPanel;
    }

    protected void okCallback() {
        if (this.checkInput()) {
            File file;
            Object archive = this.archiveField.getText().trim();
            if (!((String)archive).endsWith(".gar")) {
                archive = (String)archive + ".gar";
            }
            if ((file = new File((String)archive)).exists() && OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Archive File Exists", (String)("File " + (String)archive + " exists.\n Do you want to overwrite existing file?"), (String)"Yes") != 1) {
                return;
            }
            this.actionComplete = true;
            this.close();
        } else {
            this.rootPanel.getToolkit().beep();
        }
    }

    protected void cancelCallback() {
        this.close();
    }

    public boolean showDialog(ProjectLocator pProjectLocator, String pArchivePathName, PluginTool tool) {
        this.projectLocator = pProjectLocator;
        if (pArchivePathName != null) {
            pArchivePathName = pArchivePathName.replace("/", File.separator);
        }
        this.archivePathName = pArchivePathName;
        this.archiveField.setText(pArchivePathName);
        this.actionComplete = false;
        tool.showDialog((DialogComponentProvider)this);
        return this.actionComplete;
    }

    public String getArchivePathName() {
        String archive = this.archiveField.getText().trim();
        if (archive.length() == 0) {
            return null;
        }
        File file = new File(archive);
        Object pathName = file.getAbsolutePath();
        if (pathName == null || ((String)pathName).length() == 0) {
            return null;
        }
        if (!((String)pathName).endsWith(".gar")) {
            pathName = (String)pathName + ".gar";
        }
        return pathName;
    }

    private boolean checkInput() {
        String pathname = this.getArchivePathName();
        if (pathname == null || pathname.equals("")) {
            this.setStatusText("Specify an archive file.");
            return false;
        }
        File file = new File(pathname);
        String name = file.getName();
        if (!NamingUtilities.isValidProjectName((String)name)) {
            this.setStatusText("Archive name contains invalid characters.");
            return false;
        }
        return true;
    }

    private GhidraFileChooser createFileChooser(String extension, final String description, String filePathName) {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.getComponent());
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        fileChooser.setFileFilter(new GhidraFileFilter(){

            public boolean accept(File file, GhidraFileChooserModel model) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().toLowerCase().endsWith(".gar");
            }

            public String getDescription() {
                return description;
            }
        });
        File startDirectory = null;
        if (filePathName != null && filePathName.length() > 0) {
            startDirectory = new File(filePathName);
            if (startDirectory.isDirectory()) {
                fileChooser.setCurrentDirectory(startDirectory);
            } else {
                if (!filePathName.endsWith(extension)) {
                    startDirectory = new File(filePathName + extension);
                }
                fileChooser.setSelectedFile(startDirectory);
            }
        }
        if (startDirectory == null) {
            startDirectory = new File(GenericRunInfo.getProjectsDirPath());
            fileChooser.setCurrentDirectory(startDirectory);
        }
        return fileChooser;
    }

    private String chooseArchiveFile(String approveButtonText, String approveToolTip) {
        GhidraFileChooser jarFileChooser = this.createFileChooser(".gar", "Ghidra Archives", this.archivePathName);
        jarFileChooser.setTitle("Archive a Ghidra Project");
        File jarFile = null;
        if (this.archivePathName != null && this.archivePathName.length() != 0) {
            jarFile = new File(this.archivePathName);
        } else if (this.projectLocator != null) {
            jarFile = new File(this.projectLocator.toString() + ".gar");
        }
        jarFileChooser.setSelectedFile(jarFile);
        jarFileChooser.setApproveButtonText(approveButtonText);
        jarFileChooser.setApproveButtonToolTipText(approveToolTip);
        String pathname = null;
        while (pathname == null) {
            File selectedFile = jarFileChooser.getSelectedFile();
            if (selectedFile == null) {
                return null;
            }
            File file = selectedFile;
            String chosenPathname = file.getAbsolutePath();
            String name = file.getName();
            if (!NamingUtilities.isValidProjectName((String)name)) {
                Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Invalid Archive Name", (Object)(name + " is not a valid archive name"));
                continue;
            }
            File f = this.projectLocator.getProjectDir();
            String filename = f.getAbsolutePath();
            if (chosenPathname.indexOf(filename) >= 0) {
                Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Invalid Archive Name", (Object)"Output file cannot be inside of Project");
                continue;
            }
            pathname = chosenPathname;
        }
        jarFileChooser.dispose();
        return pathname;
    }
}

