/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;

public class ConvertToOctalAction
extends AbstractConvertAction {
    public static final String ACTION_NAME = "Convert To Unsigned Octal";

    public ConvertToOctalAction(EquatePlugin plugin) {
        super(plugin, ACTION_NAME, false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        return this.getStandardLengthString("Unsigned Octal:") + this.convertToString(program, scalar, isData);
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        return Long.toOctalString(scalar.getUnsignedValue()) + "o";
    }

    @Override
    protected int getFormatChoice() {
        return 3;
    }
}

