/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.data.DataTypeParser;
import javax.swing.KeyStroke;

public class ChooseDataTypeAction
extends DockingAction {
    private static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(84, 0);
    private static final String ACTION_NAME = "Choose Data Type";
    private FunctionPlugin plugin;

    public ChooseDataTypeAction(FunctionPlugin plugin) {
        super(ACTION_NAME, plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", "Choose Data Type..."}, null, "Array"));
        this.setHelpLocation(new HelpLocation("DataTypeEditors", "DataTypeSelectionDialog"));
        this.initKeyStroke(KEY_BINDING);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public void actionPerformed(ActionContext actionContext) {
        ListingActionContext context = (ListingActionContext)actionContext.getContextObject();
        this.createDataType(context);
    }

    public boolean isEnabledForContext(ActionContext actionContext) {
        if (!(actionContext.getContextObject() instanceof ListingActionContext)) {
            return false;
        }
        ListingActionContext context = (ListingActionContext)actionContext.getContextObject();
        if (context.hasSelection()) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            return true;
        }
        return location instanceof VariableLocation;
    }

    private void createDataType(ListingActionContext context) {
        int maxSize = this.getSelectedVariableStorageSize(context);
        DataType dataType = this.getUserSelectedDataType(context, maxSize);
        if (dataType != null) {
            this.plugin.createData(dataType, context, false, true);
        }
    }

    private int getSelectedVariableStorageSize(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        if (loc instanceof VariableTypeFieldLocation) {
            Variable var = ((VariableTypeFieldLocation)loc).getVariable();
            Function func = var.getFunction();
            if (var instanceof Parameter && !func.hasCustomVariableStorage()) {
                return -1;
            }
            VariableStorage storage = var.getVariableStorage();
            if (storage.isValid() && !storage.isStackStorage()) {
                return storage.size();
            }
        }
        return -1;
    }

    private DataType getUserSelectedDataType(ListingActionContext context, int maxStorageSize) {
        PluginTool tool = this.plugin.getTool();
        ProgramBasedDataTypeManager dataTypeManager = context.getProgram().getDataTypeManager();
        DataTypeSelectionDialog selectionDialog = this.showSelectionDialog(context, maxStorageSize, tool, (DataTypeManager)dataTypeManager);
        return selectionDialog.getUserChosenDataType();
    }

    private DataTypeSelectionDialog showSelectionDialog(ListingActionContext context, int maxStorageSize, PluginTool tool, DataTypeManager dataTypeManager) {
        DataTypeSelectionDialog selectionDialog = new DataTypeSelectionDialog((ServiceProvider)tool, dataTypeManager, maxStorageSize, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
        DataType currentDataType = this.plugin.getCurrentDataType(context);
        selectionDialog.setInitialDataType(currentDataType);
        tool.showDialog((DialogComponentProvider)selectionDialog);
        return selectionDialog;
    }
}

