/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.ProgramManager;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.main.SaveDataDialog;
import ghidra.framework.model.DefaultDomainFileFilter;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ProgramSaveManager {
    private ProgramManager programMgr;
    private PluginTool tool;
    private boolean treeDialogCancelled;
    private DomainFileFilter programFileFilter;

    ProgramSaveManager(PluginTool tool, ProgramManager programMgr) {
        this.tool = tool;
        this.programMgr = programMgr;
        this.programFileFilter = new DefaultDomainFileFilter(Program.class, true);
    }

    boolean canClose(Program program) {
        if (!this.isOnlyToolConsumer(program)) {
            return true;
        }
        if (this.acquireSaveLock(program, "Close")) {
            try {
                boolean bl = this.handleChangedProgram(program);
                return bl;
            }
            finally {
                program.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveAll() {
        Program[] programs = this.programMgr.getAllOpenPrograms();
        ArrayList<Program> saveList = new ArrayList<Program>();
        ArrayList<Program> lockList = new ArrayList<Program>();
        try {
            for (Program program : programs) {
                if (this.isOnlyToolConsumer(program)) {
                    if (!this.acquireSaveLock(program, "Close")) {
                        boolean bl = false;
                        return bl;
                    }
                    lockList.add(program);
                    saveList.add(program);
                    continue;
                }
                if (!this.isAnalysisTool(program)) continue;
                if (!this.acquireSaveLock(program, "Close")) {
                    boolean bl = false;
                    return bl;
                }
                lockList.add(program);
            }
            boolean bl = this.saveChangedPrograms(saveList);
            return bl;
        }
        finally {
            for (Program p : lockList) {
                p.unlock();
            }
        }
    }

    private boolean isOnlyToolConsumer(Program program) {
        List consumers = program.getDomainFile().getConsumers();
        for (Object consumer : consumers) {
            if (!(consumer instanceof PluginTool) || consumer == this.tool) continue;
            return false;
        }
        return true;
    }

    private boolean isAnalysisTool(Program program) {
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager(program);
        return this.tool == analysisManager.getAnalysisTool();
    }

    public void saveChangedPrograms() {
        Program[] programs;
        int saveCnt = 0;
        int unsavedCnt = 0;
        for (Program program : programs = this.programMgr.getAllOpenPrograms()) {
            if (!program.isChanged()) continue;
            if (program.canSave()) {
                this.save(program);
                ++saveCnt;
                continue;
            }
            ++unsavedCnt;
        }
        if (saveCnt != 0) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Save All...", (Object)("Saved " + saveCnt + " modified programs."));
        }
        if (unsavedCnt != 0) {
            Msg.showWarn(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Save All...", (Object)("Unable to save " + unsavedCnt + " read-only programs!"));
        }
    }

    private boolean saveChangedPrograms(List<Program> openProgramList) {
        SaveDataDialog saveDataDialog = new SaveDataDialog(this.tool);
        ArrayList<Program> saveProgramsList = new ArrayList<Program>(openProgramList);
        ArrayList<DomainFile> domainFilesToSaveList = new ArrayList<DomainFile>();
        Iterator iter = saveProgramsList.iterator();
        while (iter.hasNext()) {
            Program program = (Program)iter.next();
            DomainFile domainFile = program.getDomainFile();
            if (!domainFile.isChanged()) {
                iter.remove();
                continue;
            }
            domainFilesToSaveList.add(domainFile);
        }
        if (saveProgramsList.size() == 0) {
            return true;
        }
        if (saveProgramsList.size() == 1) {
            return this.canClose((Program)saveProgramsList.get(0));
        }
        return saveDataDialog.showDialog(domainFilesToSaveList);
    }

    void saveProgram(Program program) {
        if (program == null) {
            return;
        }
        if (program.canSave()) {
            this.save(program);
        } else {
            this.saveAs(program);
        }
    }

    private void save(Program program) {
        this.tool.prepareToSave((DomainObject)program);
        if (this.acquireSaveLock(program, "Save")) {
            try {
                SaveFileTask task = new SaveFileTask(program.getDomainFile());
                new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
            }
            finally {
                program.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAs(Program program) {
        if (!this.getSaveAsLock(program)) {
            return;
        }
        try {
            DataTreeDialog dialog = this.getSaveDialog();
            String filename = program.getDomainFile().getName();
            dialog.setTitle("Save As (" + filename + ")");
            dialog.setNameText(filename + ".1");
            dialog.setSelectedFolder(program.getDomainFile().getParent());
            this.treeDialogCancelled = true;
            this.tool.showDialog((DialogComponentProvider)dialog);
            if (!this.treeDialogCancelled) {
                this.saveAs(program, dialog.getDomainFolder(), dialog.getNameText());
            }
        }
        finally {
            program.unlock();
        }
    }

    private void saveAs(Program currentProgram, DomainFolder folder, String name) {
        DomainFile existingFile = folder.getFile(name);
        if (existingFile == currentProgram.getDomainFile()) {
            this.save(currentProgram);
            return;
        }
        if (existingFile != null) {
            String msg = existingFile.getContentType() + " file " + name + " already exists.\nDo you want to overwrite it?";
            if (OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Duplicate Name", (String)msg, (String)"Overwrite", (int)3) == 0) {
                return;
            }
        }
        this.tool.prepareToSave((DomainObject)currentProgram);
        SaveAsTask task = new SaveAsTask(this, (DomainObject)currentProgram, folder, name, existingFile != null);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }

    private boolean handleChangedProgram(Program currentProgram) {
        if (!currentProgram.isChanged()) {
            return true;
        }
        DomainFile df = currentProgram.getDomainFile();
        String filename = df.getName();
        if (!df.isInWritableProject()) {
            return OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Program Changed", (String)HTMLUtilities.lineWrapWithHTMLLineBreaks((String)("<html>Viewed file '" + HTMLUtilities.escapeHTML((String)filename) + "' has been changed.  \nIf you continue, your changes will be lost!")), (String)"Continue", (int)3) != 0;
        }
        if (df.isReadOnly()) {
            return OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Program Changed", (String)HTMLUtilities.lineWrapWithHTMLLineBreaks((String)("<html>Read-only file '" + HTMLUtilities.escapeHTML((String)filename) + "' has been changed.  \nIf you continue, your changes will be lost!")), (String)"Continue", (int)3) != 0;
        }
        int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Save Program?", (String)HTMLUtilities.lineWrapWithHTMLLineBreaks((String)("<html>" + HTMLUtilities.escapeHTML((String)filename) + " has changed.\nDo you want to save it?")), (String)"&Save", (String)"Do&n't Save", (int)3);
        if (result == 0) {
            return false;
        }
        if (result == 1) {
            SaveFileTask task = new SaveFileTask(currentProgram.getDomainFile());
            new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
        }
        return true;
    }

    private boolean acquireSaveLock(Program program, String actionName) {
        if (!program.lock(null)) {
            String title = actionName + " Program (Busy)";
            StringBuilder buf = new StringBuilder();
            buf.append("The Program is currently being modified by the following actions/tasks:\n ");
            TransactionInfo t = program.getCurrentTransactionInfo();
            ArrayList list = t.getOpenSubTransactions();
            for (String element : list) {
                buf.append("\n     ");
                buf.append(element);
            }
            buf.append("\n \n");
            buf.append("WARNING! The above task(s) should be cancelled before attempting a " + actionName + ".\n");
            buf.append("Only proceed if unable to cancel them.\n \n");
            buf.append("If you continue, all changes made by these tasks, as well as any other overlapping task,\n");
            buf.append("will be LOST and subsequent transaction errors may occur while these tasks remain active.\n \n");
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)title, (String)buf.toString(), (String)(actionName + "!"), (int)2);
            if (result == 1) {
                program.forceLock(true, "Save Program");
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean getSaveAsLock(Program program) {
        if (!program.lock(null)) {
            String title = "Save Program As (Busy)";
            StringBuffer buf = new StringBuffer();
            buf.append("The Program is currently being modified by the following actions/tasks:\n ");
            TransactionInfo t = program.getCurrentTransactionInfo();
            ArrayList list = t.getOpenSubTransactions();
            for (String element : list) {
                buf.append("\n     ");
                buf.append(element);
            }
            buf.append("\n \n");
            buf.append("WARNING! The above task(s) should be cancelled before attempting a Save As...\n");
            buf.append("Only proceed if unable to cancel them.\n \n");
            buf.append("If you click 'Save As (Rollback)' {recommended}, all changes made\n");
            buf.append("by these tasks, as well as any other overlapping task, will be LOST!\n");
            buf.append("If you click 'Save As (As Is)', the program will be saved in its current\n");
            buf.append("state which may contain some incomplete data.\n");
            buf.append("Any forced save may also result in subsequent transaction errors while\n");
            buf.append("the above tasks remain active.\n ");
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)title, (String)buf.toString(), (String)"Save As (Rollback)!", (String)"Save As (As Is)!", (int)2);
            if (result == 1) {
                program.forceLock(true, "Save Program As");
                return true;
            }
            if (result == 2) {
                program.forceLock(false, "Save Program As");
                return true;
            }
            return false;
        }
        return true;
    }

    private DataTreeDialog getSaveDialog() {
        DataTreeDialog dialog = new DataTreeDialog(null, "Save As", DataTreeDialogType.SAVE, this.programFileFilter);
        ActionListener listener = event -> {
            DomainFolder folder = dialog.getDomainFolder();
            String newName = dialog.getNameText();
            if (newName.length() == 0) {
                dialog.setStatusText("Please enter a name");
                return;
            }
            if (folder == null) {
                dialog.setStatusText("Please select a folder");
                return;
            }
            DomainFile file = folder.getFile(newName);
            if (file != null && file.isReadOnly()) {
                dialog.setStatusText("Read Only.  Choose new name/folder");
            } else {
                dialog.close();
                this.treeDialogCancelled = false;
            }
        };
        dialog.addOkActionListener(listener);
        dialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Save_As_File"));
        return dialog;
    }

    class SaveFileTask
    extends Task {
        private DomainFile domainFile;

        SaveFileTask(DomainFile df) {
            super("Save Program", true, true, true);
            this.domainFile = df;
        }

        public void run(TaskMonitor monitor) {
            monitor.setMessage("Saving Program...");
            try {
                this.domainFile.save(monitor);
            }
            catch (CancelledException cancelledException) {
            }
            catch (NotConnectedException e) {
                ClientUtil.promptForReconnect((RepositoryAdapter)ProgramSaveManager.this.tool.getProject().getRepository(), (Component)ProgramSaveManager.this.tool.getToolFrame());
            }
            catch (ConnectException e) {
                ClientUtil.promptForReconnect((RepositoryAdapter)ProgramSaveManager.this.tool.getProject().getRepository(), (Component)ProgramSaveManager.this.tool.getToolFrame());
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)ProgramSaveManager.this.tool.getProject().getRepository(), (Exception)e, (String)"Save File", (Component)ProgramSaveManager.this.tool.getToolFrame());
            }
        }
    }

    class SaveAsTask
    extends Task {
        private DomainFolder parentFolder;
        private String newName;
        private DomainObject domainObj;
        private boolean doOverwrite;

        SaveAsTask(ProgramSaveManager this$0, DomainObject obj, DomainFolder folder, String newName, boolean doOverwrite) {
            super("Save Program As", true, true, true);
            this.parentFolder = folder;
            this.newName = newName;
            this.domainObj = obj;
            this.doOverwrite = doOverwrite;
        }

        public void run(TaskMonitor monitor) {
            monitor.setMessage("Saving Program...");
            try {
                DomainFile df;
                if (this.doOverwrite && (df = this.parentFolder.getFile(this.newName)) != null) {
                    df.delete();
                }
                this.parentFolder.createFile(this.newName, this.domainObj, monitor);
            }
            catch (CancelledException df) {
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Program SaveAs Error", (Object)e.getMessage());
            }
            catch (InvalidNameException e) {
                Msg.showError((Object)((Object)this), null, (String)"Program SaveAs Error", (Object)e.getMessage());
            }
            catch (Throwable e) {
                Msg.showError((Object)((Object)this), null, (String)"Program SaveAs Error", (Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

