/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.widgets.DataToStringConverter;
import docking.widgets.DefaultDropDownSelectionDataModel;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.script.ScriptEditorListener;
import ghidra.app.script.ScriptInfo;
import ghidra.util.HTMLUtilities;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class ScriptSelectionEditor {
    private JPanel editorPanel;
    private DropDownSelectionTextField<ScriptInfo> selectionField;
    private TreeMap<String, ScriptInfo> scriptMap = new TreeMap();
    private List<ScriptEditorListener> listeners = new ArrayList<ScriptEditorListener>();

    ScriptSelectionEditor(List<ScriptInfo> scriptInfos) {
        scriptInfos.forEach(i -> this.scriptMap.put(i.getName(), (ScriptInfo)i));
        this.init();
    }

    private void init() {
        ArrayList<ScriptInfo> sortedInfos = new ArrayList<ScriptInfo>(this.scriptMap.values());
        DataToStringConverter stringConverter = info -> info.getName();
        ScriptInfoDescriptionConverter descriptionConverter = new ScriptInfoDescriptionConverter(this);
        ScriptTextFieldModel model = new ScriptTextFieldModel(this, sortedInfos, (DataToStringConverter<ScriptInfo>)stringConverter, descriptionConverter);
        this.selectionField = new ScriptSelectionTextField((DropDownTextFieldDataModel<ScriptInfo>)model);
        this.selectionField.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                ScriptSelectionEditor.this.fireEditingStopped();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                ScriptSelectionEditor.this.fireEditingCancelled();
            }
        });
        this.selectionField.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 0));
        this.editorPanel.add((Component)this.selectionField);
    }

    public void addEditorListener(ScriptEditorListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removeEditorListener(ScriptEditorListener l) {
        this.listeners.remove(l);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.selectionField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.selectionField.getDocument().removeDocumentListener(listener);
    }

    public void setConsumeEnterKeyPress(boolean consume) {
        this.selectionField.setConsumeEnterKeyPress(consume);
    }

    public JComponent getEditorComponent() {
        return this.editorPanel;
    }

    public void requestFocus() {
        this.selectionField.requestFocus();
    }

    public String getEditorText() {
        return this.selectionField.getText();
    }

    public ScriptInfo getEditorValue() {
        return (ScriptInfo)this.selectionField.getSelectedValue();
    }

    public boolean validateUserSelection() {
        if (!this.containsValidScript()) {
            return this.parseTextEntry();
        }
        return true;
    }

    private boolean containsValidScript() {
        ScriptInfo selectedInfo = (ScriptInfo)this.selectionField.getSelectedValue();
        return selectedInfo != null && this.selectionField.getText().equals(selectedInfo.getName());
    }

    private boolean parseTextEntry() {
        if (StringUtils.isBlank((CharSequence)this.selectionField.getText())) {
            return false;
        }
        String text = this.selectionField.getText();
        ScriptInfo info = this.scriptMap.get(text);
        if (info != null) {
            this.selectionField.setSelectedValue((Object)info);
            return true;
        }
        return false;
    }

    private void fireEditingStopped() {
        this.listeners.forEach(l -> l.editingStopped());
    }

    private void fireEditingCancelled() {
        this.listeners.forEach(l -> l.editingCancelled());
    }

    private class ScriptInfoDescriptionConverter
    implements DataToStringConverter<ScriptInfo> {
        private ScriptInfoDescriptionConverter(ScriptSelectionEditor scriptSelectionEditor) {
        }

        public String getString(ScriptInfo info) {
            StringBuilder buffy = new StringBuilder("<html><P>");
            KeyStroke keyBinding = info.getKeyBinding();
            if (keyBinding != null) {
                buffy.append("<P>");
                buffy.append("<FONT COLOR=\"" + GThemeDefaults.Colors.Palette.GRAY.toHexString() + "\"><I>&nbsp;");
                buffy.append(keyBinding.toString());
                buffy.append("</I></FONT>");
                buffy.append("<P><P>");
            }
            String description = info.getDescription();
            String formatted = this.formatDescription(description);
            buffy.append(formatted);
            return buffy.toString();
        }

        private String formatDescription(String description) {
            String[] lines = description.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String[] line = lines[i];
                lines[i] = line.trim();
            }
            StringBuilder bufffy = new StringBuilder();
            for (String line : lines) {
                bufffy.append(line).append("\n");
            }
            String trimmed = bufffy.toString();
            String stripped = trimmed.replaceAll("(?<!\n)\n", "");
            stripped = stripped.replaceAll("\n", "\n\n");
            return HTMLUtilities.lineWrapWithHTMLLineBreaks((String)stripped, (int)50);
        }
    }

    private class ScriptTextFieldModel
    extends DefaultDropDownSelectionDataModel<ScriptInfo> {
        public ScriptTextFieldModel(ScriptSelectionEditor scriptSelectionEditor, List<ScriptInfo> data, DataToStringConverter<ScriptInfo> searchConverter, DataToStringConverter<ScriptInfo> descriptionConverter) {
            super(data, searchConverter, descriptionConverter);
        }

        public List<DropDownTextFieldDataModel.SearchMode> getSupportedSearchModes() {
            return List.of(DropDownTextFieldDataModel.SearchMode.WILDCARD, DropDownTextFieldDataModel.SearchMode.CONTAINS, DropDownTextFieldDataModel.SearchMode.STARTS_WITH);
        }
    }

    private class ScriptSelectionTextField
    extends DropDownSelectionTextField<ScriptInfo> {
        public ScriptSelectionTextField(DropDownTextFieldDataModel<ScriptInfo> dataModel) {
            super(dataModel);
        }

        protected boolean shouldReplaceTextFieldTextWithSelectedItem(String textFieldText, ScriptInfo selectedItem) {
            return true;
        }
    }
}

