/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate;

import docking.action.MenuData;
import ghidra.app.plugin.core.string.translate.AbstractTranslateAction;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramTask;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ClearTranslationAction
extends AbstractTranslateAction {
    private static final MenuData CODE_VIEWER_MENU_DATA = new MenuData(new String[]{"Data", "Translate", "Clear Translation Value"}, META_GROUP);
    private static final MenuData DATA_LIST_MENU_DATA = new MenuData(new String[]{"Translate", "Clear Translation Value"}, META_GROUP);

    public ClearTranslationAction(String owner) {
        super("Clear Translation Value", owner, CODE_VIEWER_MENU_DATA, DATA_LIST_MENU_DATA);
        this.setPopupMenuData(CODE_VIEWER_MENU_DATA);
        this.setHelpLocation(new HelpLocation(owner, "Clear_Translation_Value_Menuitem"));
    }

    @Override
    public void actionPerformed(Program program, List<ProgramLocation> dataLocations) {
        ClearTranslationTask task = new ClearTranslationTask(program, dataLocations);
        TaskLauncher.launch((Task)task);
    }

    private static class ClearTranslationTask
    extends ProgramTask {
        private List<ProgramLocation> dataLocations;

        protected ClearTranslationTask(Program program, List<ProgramLocation> dataLocations) {
            super(program, "Clear Translations", true, true, true);
            this.dataLocations = dataLocations;
        }

        protected void doRun(TaskMonitor monitor) {
            monitor.initialize((long)this.dataLocations.size());
            for (ProgramLocation progLoc : this.dataLocations) {
                Data data = DataUtilities.getDataAtLocation((ProgramLocation)progLoc);
                TranslationSettingsDefinition.TRANSLATION.setTranslatedValue(data, null);
                TranslationSettingsDefinition.TRANSLATION.clear((Settings)data);
            }
        }
    }
}

