/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.table.DefaultRowFilterTransformer;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.symtable.AbstractSymbolTableModel;
import ghidra.app.plugin.core.symtable.FilterDialog;
import ghidra.app.plugin.core.symtable.SymbolEditor;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolProvider;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.plugin.core.symtable.SymbolTableDragProvider;
import ghidra.app.plugin.core.symtable.SymbolTableModel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdom.Element;

class SymbolPanel
extends JPanel {
    private static final boolean FILTER_NAME_ONLY_DEFAULT = true;
    private static final String FILTER_SETTINGS_ELEMENT_NAME = "FILTER_SETTINGS";
    private SymbolProvider symbolProvider;
    private SymbolTableModel symbolModel;
    private GhidraTable gTable;
    private TableModelListener listener;
    private FilterDialog filterDialog;
    private GhidraThreadedTablePanel<SymbolRowObject> threadedTablePanel;
    private GhidraTableFilterPanel<SymbolRowObject> tableFilterPanel;

    SymbolPanel(SymbolProvider provider, SymbolTableModel model, SymbolRenderer renderer, PluginTool tool) {
        super(new BorderLayout());
        this.symbolProvider = provider;
        this.symbolModel = model;
        this.threadedTablePanel = new GhidraThreadedTablePanel<SymbolRowObject>(model);
        this.listener = e -> this.symbolProvider.updateTitle();
        this.gTable = this.threadedTablePanel.getTable();
        this.gTable.setAutoLookupColumn(0);
        this.gTable.setRowSelectionAllowed(true);
        this.gTable.setSelectionMode(2);
        this.gTable.getModel().addTableModelListener(this.listener);
        this.gTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.handleTableSelection();
                tool.contextChanged((ComponentProvider)this.symbolProvider);
            }
        });
        this.gTable.setAccessibleNamePrefix("Symbol");
        this.gTable.installNavigation((ServiceProvider)tool);
        for (int i = 0; i < this.gTable.getColumnCount(); ++i) {
            TableColumn column = this.gTable.getColumnModel().getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)renderer));
            if (column.getModelIndex() != 0) continue;
            column.setCellEditor(new SymbolEditor());
        }
        this.add((Component)((Object)this.threadedTablePanel), "Center");
        this.add((Component)this.createFilterFieldPanel(), "South");
        this.filterDialog = new FilterDialog(tool);
        new SymbolTableDragProvider(this.gTable, (RowObjectTableModel<SymbolRowObject>)model);
    }

    private JPanel createFilterFieldPanel() {
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.gTable), this.symbolModel);
        this.tableFilterPanel.setToolTipText("Filters the contents of the table on symbol names that start with the given pattern");
        this.tableFilterPanel.add(Box.createHorizontalStrut(5));
        GCheckBox nameColumnOnlyCheckbox = new GCheckBox("Name Only");
        nameColumnOnlyCheckbox.setName("NameOnly");
        nameColumnOnlyCheckbox.setToolTipText("<html><b>Selected</b> causes filter to only consider the symbol's name.");
        nameColumnOnlyCheckbox.setFocusable(false);
        nameColumnOnlyCheckbox.setSelected(true);
        this.tableFilterPanel.setFilterRowTransformer(this.updateRowDataTransformer(true));
        nameColumnOnlyCheckbox.addItemListener(arg_0 -> this.lambda$createFilterFieldPanel$2((JCheckBox)nameColumnOnlyCheckbox, arg_0));
        this.tableFilterPanel.add((Component)nameColumnOnlyCheckbox);
        this.tableFilterPanel.setAccessibleNamePrefix("Symbol");
        return this.tableFilterPanel;
    }

    void locationChanged(ProgramLocation location) {
        Address address;
        Program program = location.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol primarySymbol = symbolTable.getPrimarySymbol(address = location.getAddress());
        if (primarySymbol == null) {
            return;
        }
        SymbolRowObject rowObject = new SymbolRowObject(primarySymbol);
        int index = this.symbolModel.getRowIndex(rowObject);
        if (index >= 0) {
            this.gTable.selectRow(index);
            this.gTable.scrollToSelectedRow();
        }
    }

    protected RowFilterTransformer<SymbolRowObject> updateRowDataTransformer(boolean nameOnly) {
        TableColumnModel columnModel = this.gTable.getColumnModel();
        if (nameOnly) {
            return new NameOnlyRowTransformer(this.symbolModel, columnModel);
        }
        return new DefaultRowFilterTransformer((RowObjectTableModel)this.symbolModel, columnModel);
    }

    void dispose() {
        this.gTable.getModel().removeTableModelListener(this.listener);
        this.gTable.dispose();
        this.threadedTablePanel.dispose();
        this.tableFilterPanel.dispose();
        this.filterDialog.dispose();
    }

    void setFilter() {
        if (this.filterDialog == null) {
            return;
        }
        if (this.gTable.isEditing()) {
            this.gTable.editingCanceled(null);
        }
        this.symbolProvider.setCurrentSymbol(null);
        this.gTable.clearSelection();
        this.filterDialog.adjustFilter((ComponentProvider)this.symbolProvider, this.symbolModel);
    }

    SymbolFilter getFilter() {
        return this.symbolModel.getFilter();
    }

    void readConfigState(SaveState saveState) {
        Element filterElement = saveState.getXmlElement(FILTER_SETTINGS_ELEMENT_NAME);
        if (filterElement != null) {
            this.filterDialog.restoreFilter(filterElement);
            this.symbolModel.setFilter(this.filterDialog.getFilter());
        }
    }

    void writeConfigState(SaveState saveState) {
        Element filterElement = this.filterDialog.saveFilter();
        saveState.putXmlElement(FILTER_SETTINGS_ELEMENT_NAME, filterElement);
    }

    private void handleTableSelection() {
        int selectedRowCount = this.gTable.getSelectedRowCount();
        if (selectedRowCount == 1) {
            int selectedRow = this.gTable.getSelectedRow();
            Symbol symbol = this.symbolProvider.getSymbolForRow(selectedRow);
            this.symbolProvider.setCurrentSymbol(symbol);
        } else {
            this.symbolProvider.setCurrentSymbol(null);
        }
    }

    int getActualSymbolCount() {
        return this.gTable.getRowCount();
    }

    List<Symbol> getSelectedSymbols() {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        int[] rows = this.gTable.getSelectedRows();
        for (SymbolRowObject rowObject : this.symbolModel.getRowObjects(rows)) {
            Symbol s = rowObject.getSymbol();
            if (s == null) continue;
            list.add(s);
        }
        return list;
    }

    GhidraTable getTable() {
        return this.gTable;
    }

    private /* synthetic */ void lambda$createFilterFieldPanel$2(JCheckBox nameColumnOnlyCheckbox, ItemEvent e) {
        boolean nameOnly = nameColumnOnlyCheckbox.isSelected();
        this.tableFilterPanel.setFilterRowTransformer(this.updateRowDataTransformer(nameOnly));
    }

    private static class NameOnlyRowTransformer
    extends DefaultRowFilterTransformer<SymbolRowObject> {
        private List<String> list = new ArrayList<String>();
        private SymbolTableModel symbolTableModel;

        NameOnlyRowTransformer(SymbolTableModel symbolTableModel, TableColumnModel columnModel) {
            super((RowObjectTableModel)symbolTableModel, columnModel);
            this.symbolTableModel = symbolTableModel;
        }

        public List<String> transform(SymbolRowObject rowObject) {
            this.list.clear();
            if (rowObject != null) {
                this.list.add(rowObject.toString());
                this.addOriginalName(rowObject);
            }
            return this.list;
        }

        private void addOriginalName(SymbolRowObject rowObject) {
            int index = this.symbolTableModel.getColumnIndex(AbstractSymbolTableModel.OriginalNameColumn.class);
            String originalName = this.getStringValue(rowObject, index);
            if (originalName != null) {
                this.list.add(originalName);
            }
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }
    }
}

