/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.PasswordDialog;
import docking.widgets.dialogs.MultiLineMessageDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.values.AbstractValue;
import docking.widgets.values.GValuesMap;
import docking.widgets.values.ValuesMapDialog;
import generic.jar.ResourceFile;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.script.AskDialog;
import ghidra.app.script.DecoratingPrintWriter;
import ghidra.app.script.GhidraScriptProperties;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ImproperUseException;
import ghidra.app.script.MultipleOptionsDialog;
import ghidra.app.script.ScriptControls;
import ghidra.app.script.ScriptMessage;
import ghidra.app.script.SelectLanguageDialog;
import ghidra.app.script.StringTransformer;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.tablechooser.TableChooserDialog;
import ghidra.app.tablechooser.TableChooserExecutor;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.app.util.dialog.AskAddrDialog;
import ghidra.app.util.importer.ProgramLoader;
import ghidra.app.util.opinion.BinaryLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.features.base.values.GhidraValuesMap;
import ghidra.framework.Application;
import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.HeadlessClientAuthenticator;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.PasswordClientAuthenticator;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.generic.auth.Password;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DefaultDomainFileFilter;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.ProgramDB;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.StatusListener;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.table.AddressArrayTableModel;
import ghidra.util.table.AddressSetTableModel;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class GhidraScript
extends FlatProgramAPI {
    private static Map<String, Map<Class<?>, Object>> askMap = new HashMap();
    protected ResourceFile sourceFile;
    protected GhidraState state;
    protected PrintWriter writer;
    protected PrintWriter errorWriter;
    protected boolean decorateOutput;
    protected Address currentAddress;
    protected ProgramLocation currentLocation;
    protected ProgramSelection currentSelection;
    protected ProgramSelection currentHighlight;
    protected GhidraScriptProperties propertiesFileParams;
    protected List<ResourceFile> potentialPropertiesFileLocs = new ArrayList<ResourceFile>();
    private boolean reusePreviousChoices = true;
    private CodeUnitFormat cuFormat;
    private String[] scriptArgs = new String[0];
    private int askScriptArgIndex = 0;
    private Program originalProgram;

    protected abstract void run() throws Exception;

    @Deprecated(since="12.0")
    public final void set(GhidraState state, TaskMonitor monitor, PrintWriter writer) {
        this.set(state, new ScriptControls(writer, writer, monitor));
    }

    public final void set(GhidraState state) {
        this.state = state;
        this.loadVariablesFromState();
    }

    public final void set(GhidraState state, ScriptControls controls) {
        this.state = state;
        this.loadVariablesFromState();
        this.writer = controls.getWriter();
        this.errorWriter = controls.getErrorWriter();
        this.decorateOutput = controls.shouldDecorateOutput();
        this.monitor = controls.getMonitor();
    }

    public void setReusePreviousChoices(boolean reuse) {
        this.reusePreviousChoices = reuse;
    }

    public boolean getReusePreviousChoices() {
        return this.reusePreviousChoices;
    }

    @Deprecated(since="12.0")
    public final void execute(GhidraState runState, TaskMonitor runMonitor, PrintWriter runWriter) throws Exception {
        this.execute(runState, new ScriptControls(runWriter, runWriter, runMonitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(GhidraState runState, ScriptControls runControls) throws Exception {
        boolean success = false;
        try {
            this.doExecute(runState, runControls);
            success = true;
        }
        finally {
            this.doCleanup(success);
        }
    }

    private void doExecute(GhidraState runState, ScriptControls runControls) throws Exception {
        this.state = runState;
        this.writer = runControls.getWriter();
        this.errorWriter = runControls.getErrorWriter();
        this.decorateOutput = runControls.shouldDecorateOutput();
        this.monitor = runControls.getMonitor();
        this.loadVariablesFromState();
        this.loadPropertiesFile();
        this.originalProgram = this.currentProgram;
        this.askScriptArgIndex = 0;
        AnalysisMode scriptAnalysisMode = this.getScriptAnalysisMode();
        if (this.originalProgram == null || scriptAnalysisMode == AnalysisMode.ENABLED) {
            this.executeNormal();
        } else {
            this.executeAsAnalysisWorker(scriptAnalysisMode == AnalysisMode.SUSPENDED, runControls.getMonitor());
        }
        this.updateStateFromVariables();
    }

    protected void loadPropertiesFile() throws IOException {
        if (this.propertiesFileParams == null || this.propertiesFileParams.isEmpty()) {
            this.propertiesFileParams = new GhidraScriptProperties();
            String basename = this.getScriptName();
            basename = basename.substring(0, basename.lastIndexOf(46));
            if (this.potentialPropertiesFileLocs.size() > 0) {
                this.propertiesFileParams.loadGhidraScriptProperties(this.potentialPropertiesFileLocs, basename);
            }
            if (this.propertiesFileParams.isEmpty() && this.sourceFile != null) {
                ResourceFile scriptLocation = this.sourceFile.getParentFile();
                if (scriptLocation != null) {
                    this.propertiesFileParams.loadGhidraScriptProperties(scriptLocation, basename);
                } else {
                    Msg.warn((Object)this, (Object)"Unable to find a parent folder for this script (while searching for .properties file).");
                }
            }
        }
    }

    private void doCleanup(boolean success) {
        this.cleanup(success);
    }

    public void cleanup(boolean success) {
    }

    public void setPotentialPropertiesFileLocations(List<ResourceFile> locations) {
        this.potentialPropertiesFileLocs = locations;
    }

    public void setPropertiesFileLocation(String dirLocation, String basename) throws IOException {
        File testIfDir = new File(dirLocation);
        this.propertiesFileParams = new GhidraScriptProperties();
        if (testIfDir.isDirectory()) {
            this.propertiesFileParams.loadGhidraScriptProperties(new ResourceFile(dirLocation), basename);
        }
    }

    public void setPropertiesFile(File propertiesFile) throws IOException {
        this.setPropertiesFile(new ResourceFile(propertiesFile));
    }

    private void setPropertiesFile(ResourceFile propertiesFile) throws IOException {
        this.propertiesFileParams = new GhidraScriptProperties();
        if (propertiesFile.isFile()) {
            this.propertiesFileParams.loadGhidraScriptProperties(propertiesFile);
        }
    }

    private void executeAsAnalysisWorker(boolean analyzeChanges, TaskMonitor runMonitor) throws Exception {
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager(this.currentProgram);
        AnalysisWorker worker = new AnalysisWorker(){

            @Override
            public String getWorkerName() {
                return GhidraScript.this.getScriptName();
            }

            @Override
            public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor workerMonitor) throws Exception, CancelledException {
                GhidraScript.this.monitor = workerMonitor;
                GhidraScript.this.monitor.setProgress(0L);
                GhidraScript.this.monitor.setMessage("Executing " + GhidraScript.this.getScriptName());
                GhidraScript.this.executeNormal();
                return true;
            }
        };
        if (!analyzeChanges && !this.isRunningHeadless() && analysisManager.isAnalyzing()) {
            Msg.showWarn((Object)this, null, (String)worker.getWorkerName(), (Object)"This script may not be run while auto-analysis is already in-progress.\nPlease try again later.");
            return;
        }
        analysisManager.scheduleWorker(worker, null, analyzeChanges, runMonitor);
    }

    private void executeNormal() throws Exception {
        this.start();
        try {
            this.run();
            this.monitor.checkCancelled();
        }
        finally {
            this.end(true);
        }
    }

    @Override
    public DomainFolder getProjectRootFolder() {
        if (this.isRunningHeadless()) {
            Project project = this.state.getProject();
            ProjectData projectData = project.getProjectData();
            return projectData.getRootFolder();
        }
        return super.getProjectRootFolder();
    }

    protected boolean promptToKeepChangesOnException() {
        String message = "<html>Encountered exception running script \"" + HTMLUtilities.escapeHTML((String)this.sourceFile.getName()) + "\".<br><br>Keep the changes to the program?";
        int choice = OptionDialog.showOptionNoCancelDialog(null, (String)"Keep Changes?", (String)message, (String)("<html>No (<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">discard</font> changes)"), (String)("<html>Yes (<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.GREEN) + "\">keep</font> changes)"), (int)3);
        return choice == 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void analyzeAll(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("Program may not be null");
        }
        if (this.getScriptAnalysisMode() == AnalysisMode.ENABLED || program != this.originalProgram) {
            super.analyzeAll(program);
            return;
        }
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        mgr.setIgnoreChanges(false);
        try {
            super.analyzeAll(program);
        }
        catch (Throwable throwable) {
            this.monitor.setProgress(0L);
            this.monitor.setMessage("Executing " + this.getScriptName());
            mgr.setIgnoreChanges(this.getScriptAnalysisMode() == AnalysisMode.DISABLED);
            throw throwable;
        }
        this.monitor.setProgress(0L);
        this.monitor.setMessage("Executing " + this.getScriptName());
        mgr.setIgnoreChanges(this.getScriptAnalysisMode() == AnalysisMode.DISABLED);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void analyzeChanges(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("Program may not be null");
        }
        if (this.getScriptAnalysisMode() == AnalysisMode.ENABLED || program != this.originalProgram) {
            super.analyzeChanges(program);
            return;
        }
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        mgr.setIgnoreChanges(false);
        try {
            super.analyzeChanges(program);
        }
        catch (Throwable throwable) {
            this.monitor.setProgress(0L);
            this.monitor.setMessage("Executing " + this.getScriptName());
            mgr.setIgnoreChanges(this.getScriptAnalysisMode() == AnalysisMode.DISABLED);
            throw throwable;
        }
        this.monitor.setProgress(0L);
        this.monitor.setMessage("Executing " + this.getScriptName());
        mgr.setIgnoreChanges(this.getScriptAnalysisMode() == AnalysisMode.DISABLED);
    }

    protected final void updateStateFromVariables() {
        this.state.setCurrentProgram(this.currentProgram);
        this.state.setCurrentLocation(this.currentLocation);
        this.state.setCurrentAddress(this.currentAddress);
        this.state.setCurrentAddress(this.currentAddress);
        this.state.setCurrentHighlight(this.currentHighlight);
        this.state.setCurrentSelection(this.currentSelection);
    }

    protected final void loadVariablesFromState() {
        this.currentProgram = this.state.getCurrentProgram();
        this.currentAddress = this.state.getCurrentAddress();
        this.currentLocation = this.state.getCurrentLocation();
        this.currentSelection = this.state.getCurrentSelection();
        this.currentHighlight = this.state.getCurrentHighlight();
    }

    public final GhidraState getState() {
        this.updateStateFromVariables();
        return this.state;
    }

    public final ScriptControls getControls() {
        return new ScriptControls(this.writer, this.errorWriter, this.decorateOutput, this.monitor);
    }

    public final void setCurrentLocation(Address address) {
        this.state.setCurrentAddress(address);
        this.currentAddress = address;
        this.currentLocation = this.state.getCurrentLocation();
    }

    public final void setSourceFile(ResourceFile sourceFile) {
        this.sourceFile = sourceFile;
    }

    public AnalysisMode getScriptAnalysisMode() {
        return AnalysisMode.ENABLED;
    }

    public final boolean setServerCredentials(String username, String password) {
        if (this.isRunningHeadless()) {
            ClientUtil.setClientAuthenticator((ClientAuthenticator)new PasswordClientAuthenticator(username, password));
        }
        return this.verifyRepositoryConnection();
    }

    public final boolean setAnonymousServerCredentials() {
        if (this.isRunningHeadless()) {
            try {
                HeadlessClientAuthenticator.installHeadlessClientAuthenticator((String)ClientUtil.getUserName(), null, (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected Exception", e);
            }
        }
        return this.verifyRepositoryConnection();
    }

    private boolean verifyRepositoryConnection() {
        Project project = this.state.getProject();
        if (project != null) {
            RepositoryAdapter repository = project.getRepository();
            if (repository != null) {
                try {
                    repository.connect();
                }
                catch (IOException e) {
                    if (e instanceof ConnectException || e instanceof NotConnectedException) {
                        return false;
                    }
                    if (this.isRunningHeadless()) {
                        Msg.error((Object)this, (Object)("Server Connect Error: Server repository connection failed: " + String.valueOf(repository) + ", Exception: " + e.toString()));
                    }
                    PluginTool tool = this.state.getTool();
                    Msg.showError((Object)this, (Component)(tool != null ? tool.getActiveWindow() : null), (String)"Server Connect Error", (Object)("Server repository connection failed: " + String.valueOf(repository)), (Throwable)e);
                }
                return repository.isConnected();
            }
            return true;
        }
        return false;
    }

    public String getCategory() {
        return null;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public final String toString() {
        return this.getScriptName();
    }

    public final String getScriptName() {
        if (this.sourceFile == null) {
            return this.getClass().getSimpleName() + ".class";
        }
        return this.sourceFile.getName();
    }

    public final ResourceFile getSourceFile() {
        return this.sourceFile;
    }

    public String[] getScriptArgs() {
        return this.scriptArgs;
    }

    public void setScriptArgs(String[] scriptArgs) {
        this.scriptArgs = scriptArgs != null ? scriptArgs : new String[]{};
        this.askScriptArgIndex = 0;
    }

    private String nextScriptArg() throws IndexOutOfBoundsException {
        if (this.askScriptArgIndex >= this.scriptArgs.length) {
            throw new IndexOutOfBoundsException("Script is looking for script argument #" + (this.askScriptArgIndex + 1) + ", but only " + this.scriptArgs.length + " were passed in.");
        }
        return this.scriptArgs[this.askScriptArgIndex++];
    }

    public String getGhidraVersion() {
        return Application.getApplicationVersion();
    }

    public final boolean isRunningHeadless() {
        return SystemUtilities.isInHeadlessMode();
    }

    public final void runScript(String scriptName) throws Exception {
        this.runScript(scriptName, this.state);
    }

    public final void runScript(String scriptName, String[] scriptArguments) throws Exception {
        this.runScript(scriptName, scriptArguments, this.state);
    }

    public final GhidraState runScriptPreserveMyState(String scriptName) throws Exception {
        this.updateStateFromVariables();
        GhidraState clonedState = new GhidraState(this.state);
        this.runScript(scriptName, clonedState);
        return clonedState;
    }

    public void runScript(String scriptName, GhidraState scriptState) throws Exception {
        this.runScript(scriptName, null, scriptState);
    }

    public void runScript(String scriptName, String[] scriptArguments, GhidraState scriptState) throws Exception {
        ResourceFile scriptSource = GhidraScriptUtil.findScriptByName(scriptName);
        if (scriptSource != null) {
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider(scriptSource);
            if (provider == null) {
                throw new IOException("Attempting to run subscript '" + scriptName + "': unable to run this script type.");
            }
            GhidraScript script = provider.getScriptInstance(scriptSource, this.errorWriter);
            script.setScriptArgs(scriptArguments);
            if (this.potentialPropertiesFileLocs.size() > 0) {
                script.setPotentialPropertiesFileLocations(this.potentialPropertiesFileLocs);
            }
            if (scriptState == this.state) {
                this.updateStateFromVariables();
            }
            script.execute(scriptState, this.getControls());
            if (scriptState == this.state) {
                this.loadVariablesFromState();
            }
            return;
        }
        boolean shouldContinue = false;
        if (!this.isRunningHeadless()) {
            shouldContinue = this.askYesNo("Script does not exist", this.getScriptName() + " is attempting to run another script [" + scriptName + "] that does not exist or can not be found.\n \nYou can silently ignore this error, which could lead to bad results (choose Yes)\nor allow the calling script to receive the error (choose No).\n \nDo you wish to suppress this error?");
        }
        if (!shouldContinue) {
            throw new IllegalArgumentException("Script does not exist: " + scriptName);
        }
    }

    public final boolean runCommand(Command<Program> cmd) {
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    public final boolean runCommand(BackgroundCommand<Program> cmd) {
        return cmd.applyTo((DomainObject)this.currentProgram, this.monitor);
    }

    public final Language getDefaultLanguage(Processor processor) throws LanguageNotFoundException {
        LanguageService service = DefaultLanguageService.getLanguageService();
        if (service != null) {
            return service.getDefaultLanguage(processor);
        }
        throw new IllegalStateException("LanguageService does not exist in tool!");
    }

    public final Language getLanguage(LanguageID languageID) throws LanguageNotFoundException {
        Language language;
        LanguageService service = DefaultLanguageService.getLanguageService();
        if (service != null && (language = service.getLanguage(languageID)) != null) {
            return language;
        }
        throw new IllegalStateException("LanguageService does not exist in tool!");
    }

    @Deprecated(since="12.0")
    public String getDemangled(String mangled) {
        List<DemangledObject> demangledObjs = DemanglerUtil.demangle(this.currentProgram, mangled, null);
        if (!demangledObjs.isEmpty()) {
            return demangledObjs.getFirst().getSignature(false);
        }
        return null;
    }

    public void println() {
        this.println("");
    }

    public void println(String message) {
        String decoratedMessage = this.decorate(message);
        Msg.info(GhidraScript.class, (Object)new ScriptMessage(decoratedMessage));
        if (this.writer != null) {
            this.writer.println(this.decorateOutput ? decoratedMessage : message);
        }
    }

    public void println(String message, Color color) {
        String decoratedMessage = this.decorate(message);
        Msg.info(GhidraScript.class, (Object)new ScriptMessage(decoratedMessage));
        PrintWriter printWriter = this.writer;
        if (printWriter instanceof DecoratingPrintWriter) {
            DecoratingPrintWriter scriptWriter = (DecoratingPrintWriter)printWriter;
            scriptWriter.println(this.decorateOutput ? decoratedMessage : message, color);
            return;
        }
        if (this.writer != null) {
            this.writer.println(this.decorateOutput ? decoratedMessage : message);
        }
    }

    public void print(String message, Color color) {
        String decoratedMessage = this.decorate(message);
        Msg.info(GhidraScript.class, (Object)new ScriptMessage(decoratedMessage));
        PrintWriter printWriter = this.writer;
        if (printWriter instanceof DecoratingPrintWriter) {
            DecoratingPrintWriter scriptWriter = (DecoratingPrintWriter)printWriter;
            scriptWriter.print(this.decorateOutput ? decoratedMessage : message, color);
            return;
        }
        if (this.writer != null) {
            this.writer.print(this.decorateOutput ? decoratedMessage : message);
        }
    }

    public void printf(String message, Object ... args) {
        String formattedString = String.format(message, args);
        this.print(formattedString);
    }

    public void print(String message) {
        String strippedMessage = message;
        if (message.endsWith("\r\n")) {
            strippedMessage = message.substring(0, message.length() - 2);
        } else if (message.endsWith("\n")) {
            strippedMessage = message.substring(0, message.length() - 1);
        }
        Msg.info(GhidraScript.class, (Object)new ScriptMessage(strippedMessage));
        if (this.writer != null) {
            this.writer.print(message);
        }
    }

    public void printerr(String message) {
        String decoratedMessage = this.decorate(message);
        Msg.error(GhidraScript.class, (Object)new ScriptMessage(decoratedMessage));
        if (this.errorWriter != null) {
            this.errorWriter.println(this.decorateOutput ? decoratedMessage : message);
        }
    }

    protected String decorate(String message) {
        return this.getScriptName() + "> " + message;
    }

    public String getAnalysisOptionDescription(Program program, String analysisOption) {
        Options options = program.getOptions("Analyzers");
        String description = options.getDescription(analysisOption);
        if (description == null) {
            return "";
        }
        return description;
    }

    public Map<String, String> getAnalysisOptionDescriptions(Program program, List<String> analysisOptions) {
        Options options = program.getOptions("Analyzers");
        HashMap<String, String> optionsToDescriptions = new HashMap<String, String>();
        for (String singleOption : analysisOptions) {
            String description = options.getDescription(singleOption);
            if (description == null) {
                description = "";
            }
            optionsToDescriptions.put(singleOption, description);
        }
        return optionsToDescriptions;
    }

    public void resetAllAnalysisOptions(Program program) {
        Options options = program.getOptions("Analyzers");
        for (String propertyName : options.getOptionNames()) {
            options.restoreDefaultValue(propertyName);
        }
    }

    public void resetAnalysisOption(Program program, String analysisOption) {
        Options options = program.getOptions("Analyzers");
        options.restoreDefaultValue(analysisOption);
    }

    public void resetAnalysisOptions(Program program, List<String> analysisOptions) {
        Options options = program.getOptions("Analyzers");
        for (String analysisOption : analysisOptions) {
            options.restoreDefaultValue(analysisOption);
        }
    }

    public boolean isAnalysisOptionDefaultValue(Program program, String analysisOption, String analysisValue) {
        Options options = program.getOptions("Analyzers");
        Object defaultValue = options.getDefaultValue(analysisOption);
        String defaultValueAsString = defaultValue == null ? null : defaultValue.toString();
        return analysisValue.equals(defaultValueAsString);
    }

    public String getAnalysisOptionDefaultValue(Program program, String analysisOption) {
        String returnVal;
        Options options = program.getOptions("Analyzers");
        Object defaultValue = options.getDefaultValue(analysisOption);
        String string = returnVal = defaultValue == null ? null : defaultValue.toString();
        if (returnVal == null) {
            return "";
        }
        return returnVal;
    }

    public Map<String, String> getAnalysisOptionDefaultValues(Program program, List<String> analysisOptions) {
        Options options = program.getOptions("Analyzers");
        HashMap<String, String> optionsToDefaultValues = new HashMap<String, String>();
        for (String singleOption : analysisOptions) {
            String defaultValueString;
            Object defaultValue = options.getDefaultValue(singleOption);
            String string = defaultValueString = defaultValue == null ? null : defaultValue.toString();
            if (defaultValueString == null) {
                defaultValueString = "";
            }
            optionsToDefaultValues.put(singleOption, defaultValueString);
        }
        return optionsToDefaultValues;
    }

    public Map<String, String> getCurrentAnalysisOptionsAndValues(Program program) {
        HashMap<String, String> availableOptions = new HashMap<String, String>();
        Options options = program.getOptions("Analyzers");
        for (String propertyName : options.getOptionNames()) {
            OptionType propertyType = options.getType(propertyName);
            Object propertyValue = null;
            switch (propertyType) {
                case INT_TYPE: {
                    propertyValue = options.getInt(propertyName, -1);
                    break;
                }
                case LONG_TYPE: {
                    propertyValue = options.getLong(propertyName, -1L);
                    break;
                }
                case STRING_TYPE: {
                    propertyValue = options.getString(propertyName, "");
                    break;
                }
                case DOUBLE_TYPE: {
                    propertyValue = options.getDouble(propertyName, -1.0);
                    break;
                }
                case BOOLEAN_TYPE: {
                    propertyValue = options.getBoolean(propertyName, false);
                    break;
                }
                case FLOAT_TYPE: {
                    propertyValue = Float.valueOf(options.getFloat(propertyName, 0.0f));
                    break;
                }
                case DATE_TYPE: 
                case BYTE_ARRAY_TYPE: 
                case COLOR_TYPE: 
                case CUSTOM_TYPE: 
                case FILE_TYPE: 
                case FONT_TYPE: 
                case KEYSTROKE_TYPE: 
                case ACTION_TRIGGER: {
                    break;
                }
                case NO_TYPE: {
                    break;
                }
                case ENUM_TYPE: {
                    propertyValue = options.getObject(propertyName, null);
                    break;
                }
            }
            if (propertyValue == null) continue;
            availableOptions.put(propertyName, propertyValue.toString());
        }
        return availableOptions;
    }

    public void setAnalysisOptions(Program program, Map<String, String> analysisSettings) {
        Options options = program.getOptions("Analyzers");
        StringBuffer errorBuffer = new StringBuffer();
        for (String analysisOptionName : analysisSettings.keySet()) {
            String returnString = this.setAnalysisOption(options, analysisOptionName, analysisSettings.get(analysisOptionName));
            if (returnString.length() <= 0) continue;
            errorBuffer.append(returnString);
            errorBuffer.append("\n");
        }
        if (errorBuffer.length() > 0) {
            if (this.isRunningHeadless()) {
                Msg.error((Object)this, (Object)errorBuffer.toString());
            } else {
                MultiLineMessageDialog.showMessageDialog(null, (String)"Analysis Options", (String)"Ghidra encountered error(s) when attempting to set analysis options.", (String)errorBuffer.toString(), (int)2);
            }
        }
    }

    public void setAnalysisOption(Program program, String optionName, String optionValue) {
        Options options = program.getOptions("Analyzers");
        String errorMsg = this.setAnalysisOption(options, optionName, optionValue);
        if (errorMsg.length() > 0) {
            if (this.isRunningHeadless()) {
                Msg.error((Object)this, (Object)errorMsg);
            } else {
                MultiLineMessageDialog.showMessageDialog(null, (String)"Analysis Options", (String)"Ghidra encountered error(s) when attempting to set analysis options.", (String)errorMsg, (int)2);
            }
        }
    }

    private String setAnalysisOption(Options options, String analysisOption, String analysisOptionValue) {
        Object changeFailedMessage = "";
        if (analysisOptionValue == null) {
            return (String)changeFailedMessage + " " + analysisOption + " Can not set an analyzer option to null value.";
        }
        if (!options.contains(analysisOption)) {
            return (String)changeFailedMessage + analysisOption + " could not be found for this program.";
        }
        OptionType optionType = options.getType(analysisOption);
        try {
            switch (optionType) {
                case INT_TYPE: {
                    options.setInt(analysisOption, Integer.valueOf(analysisOptionValue).intValue());
                    break;
                }
                case LONG_TYPE: {
                    options.setLong(analysisOption, Long.valueOf(analysisOptionValue).longValue());
                    break;
                }
                case STRING_TYPE: {
                    options.setString(analysisOption, analysisOptionValue);
                    break;
                }
                case DOUBLE_TYPE: {
                    options.setDouble(analysisOption, Double.valueOf(analysisOptionValue).doubleValue());
                    break;
                }
                case FLOAT_TYPE: {
                    options.setFloat(analysisOption, Float.valueOf(analysisOptionValue).floatValue());
                    break;
                }
                case BOOLEAN_TYPE: {
                    String tempBool = analysisOptionValue.toLowerCase();
                    if ("true".equals(tempBool) || "false".equals(tempBool)) {
                        options.setBoolean(analysisOption, Boolean.valueOf(tempBool).booleanValue());
                    }
                    break;
                }
                case ENUM_TYPE: {
                    this.setEnum(options, analysisOption, analysisOptionValue);
                    break;
                }
                case DATE_TYPE: 
                case BYTE_ARRAY_TYPE: 
                case COLOR_TYPE: 
                case CUSTOM_TYPE: 
                case FILE_TYPE: 
                case FONT_TYPE: 
                case KEYSTROKE_TYPE: {
                    changeFailedMessage = (String)changeFailedMessage + "Not allowed to change settings usings strings for type: " + String.valueOf(optionType);
                }
                default: {
                    changeFailedMessage = (String)changeFailedMessage + "The option could not be found for this program.";
                    break;
                }
            }
        }
        catch (NumberFormatException numFormatExc) {
            changeFailedMessage = (String)changeFailedMessage + "Could not convert '" + analysisOptionValue + "' to a number of type " + String.valueOf(optionType) + ".";
        }
        catch (IllegalArgumentException e) {
            changeFailedMessage = "Error changing setting for option '" + analysisOption + "'. ";
        }
        return changeFailedMessage;
    }

    private void setEnum(Options options, String analysisOption, String analysisOptionValue) {
        Enum enumm = options.getEnum(analysisOption, null);
        if (enumm == null) {
            throw new IllegalStateException("Attempted to set an Enum option without an existing enum value alreday set.");
        }
        Object newEnumm = Enum.valueOf(enumm.getClass(), analysisOptionValue);
        if (newEnumm != null) {
            options.setEnum(analysisOption, newEnumm);
        }
    }

    public void setCurrentSelection(AddressSetView addressSet) {
        this.currentSelection = addressSet == null || addressSet.isEmpty() ? null : new ProgramSelection(addressSet);
        this.state.setCurrentSelection(this.currentSelection);
    }

    public void createSelection(AddressSetView set) {
        this.setCurrentSelection(set);
    }

    public void removeSelection() {
        this.setCurrentSelection(null);
    }

    public void setCurrentHighlight(AddressSetView addressSet) {
        this.currentHighlight = addressSet == null || addressSet.isEmpty() ? null : new ProgramSelection(addressSet);
        this.state.setCurrentHighlight(this.currentHighlight);
    }

    public void createHighlight(AddressSetView set) {
        this.setCurrentHighlight(set);
    }

    public void removeHighlight() {
        this.createHighlight((AddressSetView)this.createAddressSet());
    }

    public void setBackgroundColor(Address address, Color color) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The setBackgroundColor() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        ColorizingService service = (ColorizingService)tool.getService(ColorizingService.class);
        if (service == null) {
            this.printerr("Cannot set background colors without the " + ColorizingService.class.getSimpleName() + " installed");
            return;
        }
        service.setBackgroundColor(address, address, color);
    }

    public void setBackgroundColor(AddressSetView addresses, Color color) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The setBackgroundColor() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        ColorizingService service = (ColorizingService)tool.getService(ColorizingService.class);
        if (service == null) {
            this.printerr("Cannot set background colors without the " + ColorizingService.class.getSimpleName() + " installed");
            return;
        }
        service.setBackgroundColor(addresses, color);
    }

    public void clearBackgroundColor(Address address) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The clearBackgroundColor() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        ColorizingService service = (ColorizingService)tool.getService(ColorizingService.class);
        if (service == null) {
            this.printerr("Cannot clear background colors without the " + ColorizingService.class.getSimpleName() + " installed");
            return;
        }
        service.clearBackgroundColor(address, address);
    }

    public void clearBackgroundColor(AddressSetView addresses) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The clearBackgroundColor() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        ColorizingService service = (ColorizingService)tool.getService(ColorizingService.class);
        if (service == null) {
            this.printerr("Cannot clear background colors without the " + ColorizingService.class.getSimpleName() + " installed");
            return;
        }
        service.clearBackgroundColor(addresses);
    }

    public TableChooserDialog createTableChooserDialog(String title, TableChooserExecutor executor) throws ImproperUseException {
        return this.createTableChooserDialog(title, executor, false);
    }

    public TableChooserDialog createTableChooserDialog(String title, TableChooserExecutor executor, boolean isModal) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The createTableChooserDialog() method can only be run within a headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            throw new ImproperUseException("The createTableChooserDialog() method can only be run within a headed Ghidra.");
        }
        Program program = this.state.getCurrentProgram();
        TableService service = (TableService)tool.getService(TableService.class);
        return service.createTableChooserDialog(executor, program, title, null, isModal);
    }

    public CodeUnitFormat getCodeUnitFormat() {
        PluginTool tool = this.state.getTool();
        if (this.cuFormat == null) {
            this.cuFormat = tool != null ? new BrowserCodeUnitFormat((ServiceProvider)tool) : new CodeUnitFormat(CodeUnitFormatOptions.ShowBlockName.NEVER, CodeUnitFormatOptions.ShowNamespace.NON_LOCAL);
        }
        return this.cuFormat;
    }

    public void popup(String message) {
        if (this.isRunningHeadless()) {
            Msg.info((Object)this, (Object)message);
        } else {
            String name = this.getClass().getName();
            Msg.showInfo(this.getClass(), null, (String)name, (Object)message);
        }
    }

    private String join(String ... input) {
        char separator = ' ';
        StringBuilder buffy = new StringBuilder("");
        for (String s : input) {
            if (s == null) continue;
            buffy.append(s.trim()).append(separator);
        }
        String newString = buffy.toString();
        return newString.trim();
    }

    private List<String> getValues(String s) {
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            String unquoted = s.substring(1, s.length() - 1);
            return Arrays.asList(unquoted.split(";"));
        }
        return Arrays.asList(s);
    }

    private <T> T loadAskValue(StringTransformer<T> transformer, String key) {
        T value = this.loadAskValue(null, transformer, key);
        return value;
    }

    private <T> T loadAskValue(T defaultValue, StringTransformer<T> transformer, String key) {
        boolean isHeadless = this.isRunningHeadless();
        if (isHeadless && this.scriptArgs.length > 0) {
            return transformer.apply(this.nextScriptArg());
        }
        boolean hasDefault = !this.isBlank(defaultValue);
        String propertyKey = key;
        if (this.propertiesFileParams == null) {
            if (isHeadless && !hasDefault) {
                throw new IllegalArgumentException("Error processing variable '" + propertyKey + "' in headless mode -- it was not found in script arguments or a .properties file.");
            }
            return defaultValue;
        }
        String storedValue = this.propertiesFileParams.getValue(propertyKey);
        if (storedValue.isEmpty()) {
            if (isHeadless && !hasDefault) {
                throw new IllegalArgumentException("Error processing variable '" + propertyKey + "' in headless mode -- it was not found in script arguments or a .properties file.");
            }
            return defaultValue;
        }
        try {
            T t = transformer.apply(storedValue);
            return t;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (isHeadless) {
                throw new IllegalArgumentException("Error processing variable '" + propertyKey + "' in headless mode -- its value '" + storedValue + "' is not a valid value.");
            }
            Msg.warn((Object)this, (Object)("Failed to parse script properties value '" + key + "' from file " + this.propertiesFileParams.getFilename()));
            return null;
        }
    }

    private <T> T doAsk(Class<?> clazz, String key1, String key2, T defaultValue, CancellableFunction<T, T> asker) throws CancelledException {
        Map<Class<?>, Object> map = this.getScriptMap(key1, key2);
        Object mappedValue = null;
        if (clazz != null && this.reusePreviousChoices) {
            mappedValue = map.get(clazz);
        }
        Object lastValue = mappedValue != null ? mappedValue : (Object)defaultValue;
        Object newValue = GhidraScript.swing(asker, lastValue);
        map.put(clazz, newValue);
        return (T)newValue;
    }

    public File askFile(String title, String approveButtonText) throws CancelledException {
        String key = this.join(title, approveButtonText);
        File existingValue = this.loadAskValue(File::new, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        File choice = this.doAsk(File.class, title, approveButtonText, existingValue, lastValue -> {
            GhidraFileChooser chooser = new GhidraFileChooser(null);
            chooser.setSelectedFile(lastValue);
            chooser.setTitle(title);
            chooser.setApproveButtonText(approveButtonText);
            chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            File file = chooser.getSelectedFile();
            chooser.dispose();
            if (chooser.wasCancelled()) {
                throw new CancelledException();
            }
            return file;
        });
        return choice;
    }

    public File parseDirectory(String val) {
        File dir = new File(val);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory: " + String.valueOf(dir));
        }
        return dir;
    }

    public File askDirectory(String title, String approveButtonText) throws CancelledException {
        String key = this.join(title, approveButtonText);
        File existingValue = this.loadAskValue(this::parseDirectory, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        File choice = this.doAsk(DIRECTORY.class, title, approveButtonText, existingValue, lastValue -> {
            GhidraFileChooser chooser = new GhidraFileChooser(null);
            chooser.setSelectedFile(lastValue);
            chooser.setTitle(title);
            chooser.setApproveButtonText(approveButtonText);
            chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            File file = chooser.getSelectedFile();
            chooser.dispose();
            if (chooser.wasCancelled()) {
                throw new CancelledException();
            }
            return file;
        });
        return choice;
    }

    public LanguageCompilerSpecPair parseLanguageCompileSpecPair(String val) {
        String storedCompilerSpecID;
        int lastColon;
        String storedLangID;
        LanguageCompilerSpecPair storedLCS;
        if (val.isEmpty()) {
            throw new IllegalArgumentException("No LanguageCompilerSpecPair specified");
        }
        HashSet<LanguageCompilerSpecPair> allPairs = new HashSet<LanguageCompilerSpecPair>();
        List languageDescriptions = DefaultLanguageService.getLanguageService().getLanguageDescriptions(false);
        if (languageDescriptions != null) {
            for (LanguageDescription description : languageDescriptions) {
                Collection csDescriptions = description.getCompatibleCompilerSpecDescriptions();
                if (csDescriptions == null) continue;
                for (CompilerSpecDescription csDescription : csDescriptions) {
                    allPairs.add(new LanguageCompilerSpecPair(description.getLanguageID(), csDescription.getCompilerSpecID()));
                }
            }
        }
        if (allPairs.contains(storedLCS = new LanguageCompilerSpecPair(storedLangID = val.substring(0, lastColon = val.lastIndexOf(58)), storedCompilerSpecID = val.substring(lastColon + 1)))) {
            return storedLCS;
        }
        throw new IllegalArgumentException("Invalid LanguageCompilerSpecPair: " + val);
    }

    public LanguageCompilerSpecPair askLanguage(String title, String approveButtonText) throws CancelledException {
        String key = this.join(title, approveButtonText);
        LanguageCompilerSpecPair existingValue = this.loadAskValue(this::parseLanguageCompileSpecPair, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Class<LanguageCompilerSpecPair> clazz = LanguageCompilerSpecPair.class;
        LanguageCompilerSpecPair choice = this.doAsk(clazz, title, approveButtonText, existingValue, lastValue -> {
            SelectLanguageDialog dialog = new SelectLanguageDialog(title, approveButtonText);
            dialog.setSelectedLanguage((LanguageCompilerSpecPair)lastValue);
            dialog.show();
            if (dialog.wasCancelled()) {
                throw new CancelledException();
            }
            return dialog.getSelectedLanguage();
        });
        return choice;
    }

    public DomainFolder parseProjectFolder(String val) {
        DomainFolder df;
        if (!((String)val).isEmpty() && ((String)val).charAt(0) != '/') {
            val = "/" + (String)val;
        }
        if ((df = this.state.getProject().getProjectData().getFolder((String)val)) != null) {
            return df;
        }
        throw new IllegalArgumentException("Invalid DomainFolder: " + (String)val);
    }

    public DomainFolder askProjectFolder(String title) throws CancelledException {
        DomainFolder existingValue = this.loadAskValue(this::parseProjectFolder, title);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        DomainFolder choice = this.doAsk(Program.class, title, "", existingValue, lastValue -> {
            DataTreeDialog dtd = new DataTreeDialog(null, title, DataTreeDialogType.CHOOSE_FOLDER);
            dtd.show();
            if (dtd.wasCancelled()) {
                throw new CancelledException();
            }
            return dtd.getDomainFolder();
        });
        return choice;
    }

    public int parseInt(String val) {
        try {
            return Integer.decode(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid integer: " + val);
        }
    }

    public GhidraValuesMap askValues(String title, String optionalMessage, GhidraValuesMap values) throws CancelledException {
        values.setTaskMonitor(this.monitor);
        for (AbstractValue value : values.getValues()) {
            String key = this.join(title, value.getName());
            this.loadAskValue(value.getValue(), s -> value.setAsText(s), key);
        }
        if (this.isRunningHeadless()) {
            ScriptStatusListener status = new ScriptStatusListener(this);
            if (!values.isValid(status)) {
                throw new IllegalArgumentException("Validation Failed!: " + status.toString());
            }
            return values;
        }
        String key = this.generateKey(values);
        return this.doAsk(GValuesMap.class, title, key, values, v -> {
            if (v != values) {
                values.copyValues((GValuesMap)v);
            }
            ValuesMapDialog dialog = new ValuesMapDialog(title, optionalMessage, (GValuesMap)values);
            DockingWindowManager.showDialog((DialogComponentProvider)dialog);
            if (dialog.isCancelled()) {
                throw new CancelledException();
            }
            return (GhidraValuesMap)dialog.getValues();
        });
    }

    private String generateKey(GValuesMap valuesMap) {
        return valuesMap.getValues().stream().map(v -> v.getName()).collect(Collectors.joining());
    }

    public int askInt(String title, String message) throws CancelledException {
        String key = this.join(title, message);
        Integer existingValue = this.loadAskValue(this::parseInt, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Integer choice = this.doAsk(Integer.class, title, message, existingValue, lastValue -> {
            AskDialog dialog = new AskDialog(title, message, 1, lastValue);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            Integer newValue = dialog.getValueAsInt();
            return newValue;
        });
        if (choice == null) {
            return 0;
        }
        return choice;
    }

    public long parseLong(String val) {
        try {
            return Long.decode(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid long: " + val);
        }
    }

    private String stringIdentity(String s) {
        return s;
    }

    public long askLong(String title, String message) throws CancelledException {
        String key = this.join(title, message);
        Long existingValue = this.loadAskValue(this::parseLong, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Long choice = this.doAsk(Long.class, title, message, existingValue, lastValue -> {
            AskDialog dialog = new AskDialog(title, message, 2, lastValue);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            return dialog.getValueAsLong();
        });
        if (choice == null) {
            return 0L;
        }
        return choice;
    }

    public Address parseAddress(String val) {
        Address addr = this.currentProgram.getAddressFactory().getAddress(val);
        if (addr == null) {
            throw new IllegalArgumentException("Invalid address " + val);
        }
        return addr;
    }

    public Address askAddress(String title, String message) throws CancelledException {
        return this.askAddress(title, message, null);
    }

    public Address askAddress(String title, String message, String defaultValue) throws CancelledException {
        String key = this.join(title, message);
        Address defaultAddr = null;
        if (defaultValue != null) {
            defaultAddr = this.currentProgram.getAddressFactory().getAddress(defaultValue);
        }
        Address existingValue = this.loadAskValue(defaultAddr, this::parseAddress, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Address choice = this.doAsk(Integer.class, title, message, existingValue, lastValue -> {
            AskAddrDialog dialog = new AskAddrDialog(title, message, this.currentProgram, (Address)lastValue);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            Address addr = dialog.getValueAsAddress();
            return addr;
        });
        return choice;
    }

    public byte[] parseBytes(String val) {
        try {
            return NumericUtilities.convertStringToBytes((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid bytes: " + val);
        }
    }

    public byte[] askBytes(String title, String message) throws CancelledException {
        String key = this.join(title, message);
        byte[] existingValue = this.loadAskValue(this::parseBytes, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        byte[] choice = this.doAsk(byte[].class, title, message, existingValue, lastValue -> {
            String lastByteString = NumericUtilities.convertBytesToString((byte[])lastValue, (String)" ");
            AskDialog dialog = new AskDialog(title, message, 4, lastByteString);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            String bytesString = dialog.getValueAsString();
            byte[] bytes = NumericUtilities.convertStringToBytes((String)bytesString);
            return bytes;
        });
        return choice;
    }

    public Program askProgram(String title) throws VersionException, IOException, CancelledException {
        return this.askProgram(title, false);
    }

    public Program askProgram(String title, boolean upgradeIfNeeded) throws VersionException, IOException, CancelledException {
        DomainFile choice = this.loadAskValue(this::parseDomainFile, title);
        if (!this.isRunningHeadless()) {
            choice = this.doAsk(Program.class, title, "", choice, lastValue -> {
                DataTreeDialog dtd = new DataTreeDialog(null, title, DataTreeDialogType.OPEN, (DomainFileFilter)new DefaultDomainFileFilter(Program.class, true));
                dtd.show();
                if (dtd.wasCancelled()) {
                    return null;
                }
                return dtd.getDomainFile();
            });
        }
        if (choice == null) {
            return null;
        }
        Program p = this.doOpenProgram(choice, upgradeIfNeeded);
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            return p;
        }
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        pm.openProgram(p);
        return p;
    }

    private Program doOpenProgram(DomainFile domainFile, boolean upgradeIfNeeded) throws CancelledException, IOException, VersionException {
        try {
            return (Program)domainFile.getDomainObject((Object)this, upgradeIfNeeded, false, this.monitor);
        }
        catch (VersionException e) {
            if (this.isRunningHeadless()) {
                throw e;
            }
            if (VersionExceptionHandler.isUpgradeOK(null, (DomainFile)domainFile, (String)"Open ", (VersionException)e)) {
                return (Program)domainFile.getDomainObject((Object)this, true, false, this.monitor);
            }
            throw e;
        }
    }

    public DomainFile parseDomainFile(String val) {
        DomainFile df;
        if (!((String)val).isEmpty() && ((String)val).charAt(0) != '/') {
            val = "/" + (String)val;
        }
        if ((df = this.state.getProject().getProjectData().getFile((String)val)) != null) {
            return df;
        }
        throw new IllegalArgumentException("Invalid DomainFile: " + (String)val);
    }

    public DomainFile askDomainFile(String title) throws CancelledException {
        DomainFile existingValue = this.loadAskValue(this::parseDomainFile, title);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        String message = "";
        DomainFile choice = this.doAsk(DomainFile.class, title, message, existingValue, lastValue -> {
            DataTreeDialog dtd = new DataTreeDialog(null, title, DataTreeDialogType.OPEN, DomainFileFilter.ALL_FILES_NO_EXTERNAL_FOLDERS_FILTER);
            dtd.show();
            if (dtd.wasCancelled()) {
                throw new CancelledException();
            }
            return dtd.getDomainFile();
        });
        return choice;
    }

    public double parseDouble(String val) {
        if ("pi".equalsIgnoreCase(val)) {
            return Math.PI;
        }
        if ("e".equalsIgnoreCase(val)) {
            return Math.E;
        }
        try {
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid double: " + val);
        }
    }

    public double askDouble(String title, String message) throws CancelledException {
        String key = this.join(title, message);
        Double existingValue = this.loadAskValue(this::parseDouble, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Double choice = this.doAsk(Double.class, title, message, existingValue, lastValue -> {
            AskDialog dialog = new AskDialog(title, message, 3, lastValue);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            return dialog.getValueAsDouble();
        });
        if (choice == null) {
            return 0.0;
        }
        return choice;
    }

    public String askString(String title, String message) throws CancelledException {
        return this.askString(title, message, "");
    }

    public String askString(String title, String message, String defaultValue) throws CancelledException {
        String key = this.join(title, message);
        String existingValue = this.loadAskValue(defaultValue, this::stringIdentity, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        String choice = this.doAsk(String.class, title, message, existingValue, lastValue -> {
            AskDialog dialog = new AskDialog(title, message, 0, lastValue);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            return dialog.getValueAsString();
        });
        return choice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Password askPassword(String title, String prompt) throws CancelledException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The askPassword() method can only be used when running headed Ghidra.");
        }
        PasswordDialog dialog = new PasswordDialog(title, null, null, prompt);
        try {
            this.state.getTool().showDialog((DialogComponentProvider)dialog);
            if (!dialog.okWasPressed()) {
                throw new CancelledException("User cancelled password prompt.");
            }
            Password password = Password.wrap((char[])dialog.getPassword());
            return password;
        }
        finally {
            dialog.dispose();
        }
    }

    public <T> T parseChoice(String val, List<T> validChoices) {
        for (T choice : validChoices) {
            if (!choice.toString().equals(val)) continue;
            return choice;
        }
        throw new IllegalArgumentException("Invalid choice: " + val);
    }

    public <T> T askChoice(String title, String message, List<T> choices, T defaultValue) throws CancelledException {
        StringTransformer<Object> curry = s -> this.parseChoice(s, choices);
        String key = this.join(title, message);
        Object existingValue = this.loadAskValue(defaultValue, curry, key);
        if (this.isRunningHeadless()) {
            return (T)existingValue;
        }
        Class<?> clazz = choices.get(0).getClass();
        Object choice = this.doAsk(clazz, title, message, existingValue, lastValue -> {
            AskDialog dialog = new AskDialog(null, title, message, 0, choices, lastValue);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            Object value = dialog.getChoiceValue();
            return value;
        });
        return (T)choice;
    }

    private boolean isBlank(Object o) {
        if (o == null) {
            return true;
        }
        return o.toString().trim().isEmpty();
    }

    public <T> List<T> parseChoices(String s, List<T> validChoices) {
        HashSet<String> choiceStringSet = new HashSet<String>(this.getValues(s));
        LinkedList<T> ret = new LinkedList<T>();
        for (T choice : validChoices) {
            if (!choiceStringSet.contains(choice.toString())) continue;
            ret.add(choice);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        throw new IllegalArgumentException("Invalid choices: " + s);
    }

    public <T> List<T> parseChoices(String val, List<T> validChoices, List<String> stringRepresentationOfValidChoices) {
        HashSet<String> choiceStringSet = new HashSet<String>(this.getValues(val));
        LinkedList<T> ret = new LinkedList<T>();
        for (int i = 0; i < stringRepresentationOfValidChoices.size(); ++i) {
            if (!choiceStringSet.contains(stringRepresentationOfValidChoices.get(i))) continue;
            ret.add(validChoices.get(i));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        throw new IllegalArgumentException("Invalid choices: " + val);
    }

    public <T> List<T> askChoices(String title, String message, List<T> choices) throws CancelledException {
        StringTransformer<List> curry = s -> this.parseChoices(s, choices);
        String key = this.join(title, message);
        List existingValue = this.loadAskValue(curry, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Class<?> clazz = choices.get(0).getClass();
        List choice = this.doAsk(clazz, title, message, existingValue, lastValue -> {
            MultipleOptionsDialog dialog = new MultipleOptionsDialog(title, message, choices, true);
            dialog.show();
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            return dialog.getUserChoices();
        });
        return choice;
    }

    public <T> List<T> askChoices(String title, String message, List<T> choices, List<String> choiceLabels) throws CancelledException {
        StringTransformer<List> curry = s -> this.parseChoices(s, choices, choiceLabels);
        String key = this.join(title, message);
        List existingValue = this.loadAskValue(curry, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        Class<?> clazz = choices.get(0).getClass();
        List choice = this.doAsk(clazz, title, message, existingValue, lastValue -> {
            MultipleOptionsDialog dialog = new MultipleOptionsDialog(title, message, choices, choiceLabels, true);
            dialog.show();
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            return dialog.getUserChoices();
        });
        return choice;
    }

    public Boolean parseBoolean(String val) {
        if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
            return Boolean.parseBoolean(val);
        }
        throw new IllegalArgumentException("Invalid boolean: " + val);
    }

    public boolean askYesNo(String title, String question) {
        String key = this.join(title, question);
        Boolean existingValue = this.loadAskValue(this::parseBoolean, key);
        if (this.isRunningHeadless()) {
            return existingValue;
        }
        return OptionDialog.showYesNoDialog(null, (String)title, (String)question) == 1;
    }

    public String toHexString(byte b, boolean zeropad, boolean header) {
        String str = Integer.toHexString(b & 0xFF);
        if (zeropad) {
            str = GhidraScript.zeropad(str, 2);
        }
        return (header ? "0x" : "") + str;
    }

    public String toHexString(short s, boolean zeropad, boolean header) {
        String str = Integer.toHexString(s & 0xFFFF);
        if (zeropad) {
            str = GhidraScript.zeropad(str, 4);
        }
        return (header ? "0x" : "") + str;
    }

    public String toHexString(int i, boolean zeropad, boolean header) {
        String s = Integer.toHexString(i);
        if (zeropad) {
            s = GhidraScript.zeropad(s, 8);
        }
        return (header ? "0x" : "") + s;
    }

    public String toHexString(long l, boolean zeropad, boolean header) {
        String s = Long.toHexString(l);
        if (zeropad) {
            s = GhidraScript.zeropad(s, 16);
        }
        return (header ? "0x" : "") + s;
    }

    public boolean goTo(Address address) {
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            return false;
        }
        GoToService gotoService = (GoToService)tool.getService(GoToService.class);
        if (gotoService != null) {
            return gotoService.goTo(address);
        }
        return false;
    }

    public boolean goTo(Symbol symbol) {
        return this.goTo(symbol.getAddress());
    }

    public boolean goTo(Function function) {
        return this.goTo(function.getEntryPoint());
    }

    public Program importFile(File file) throws Exception {
        LoadResults<Program> loadResults = ProgramLoader.builder().source(file).project(this.state.getProject()).monitor(this.monitor).load();
        try {
            Program program = loadResults.getPrimaryDomainObject(this);
            if (loadResults != null) {
                loadResults.close();
            }
            return program;
        }
        catch (Throwable throwable) {
            try {
                if (loadResults != null) {
                    try {
                        loadResults.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LoadException e) {
                return null;
            }
        }
    }

    public Program importFileAsBinary(File file, Language language, CompilerSpec compilerSpec) throws Exception {
        LoadResults<Program> loadResults = ProgramLoader.builder().source(file).project(this.state.getProject()).loaders(BinaryLoader.class).language(language).compiler(compilerSpec).monitor(this.monitor).load();
        try {
            Program program = loadResults.getPrimaryDomainObject(this);
            if (loadResults != null) {
                loadResults.close();
            }
            return program;
        }
        catch (Throwable throwable) {
            try {
                if (loadResults != null) {
                    try {
                        loadResults.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LoadException e) {
                return null;
            }
        }
    }

    public void openProgram(Program program) {
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            return;
        }
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        pm.openProgram(program);
        this.end(true);
        GhidraState newState = new GhidraState(tool, tool.getProject(), program, null, null, null);
        this.set(newState);
        this.start();
    }

    public void closeProgram(Program program) {
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            return;
        }
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        pm.closeProgram(program, false);
    }

    public Program createProgram(String programName, LanguageID languageID, CompilerSpecID compilerSpecID) throws Exception {
        Language language = this.getLanguage(languageID);
        return this.createProgram(programName, language, language.getCompilerSpecByID(compilerSpecID));
    }

    public Program createProgram(String programName, LanguageID languageID) throws Exception {
        Language language = this.getLanguage(languageID);
        CompilerSpec spec = language.getDefaultCompilerSpec();
        return this.createProgram(programName, language, spec);
    }

    public Program createProgram(String programName, Language language, CompilerSpec compilerSpec) throws Exception {
        ProgramDB program = new ProgramDB(programName, language, compilerSpec, (Object)this);
        this.openProgram((Program)program);
        program.release((Object)this);
        return program;
    }

    public void setToolStatusMessage(String msg, boolean beep) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The setToolStatusMessage() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            if (beep) {
                this.printerr(msg);
            }
            return;
        }
        tool.setStatusInfo(msg, beep);
    }

    public void show(Address[] addresses) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The show() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            return;
        }
        TableService ts = (TableService)tool.getService(TableService.class);
        if (ts == null) {
            this.println("Unable to show addresses, no table service exists.");
        } else {
            this.show("Addresses", ts, addresses);
        }
    }

    public void show(String title, AddressSetView addresses) throws ImproperUseException {
        if (this.isRunningHeadless()) {
            throw new ImproperUseException("The show() method can only be used when running headed Ghidra.");
        }
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            return;
        }
        TableService ts = (TableService)tool.getService(TableService.class);
        if (ts == null) {
            this.println("Unable to show addresses, no table service exists.");
            return;
        }
        this.show(title, ts, addresses);
    }

    public String getPlateCommentAsRendered(Address address) {
        String comment = this.currentProgram.getListing().getComment(CommentType.PLATE, address);
        PluginTool tool = this.state.getTool();
        if (tool != null) {
            comment = CommentUtils.getDisplayString(comment, this.currentProgram);
        }
        return comment;
    }

    public String getPreCommentAsRendered(Address address) {
        String comment = this.currentProgram.getListing().getComment(CommentType.PRE, address);
        PluginTool tool = this.state.getTool();
        if (tool != null) {
            comment = CommentUtils.getDisplayString(comment, this.currentProgram);
        }
        return comment;
    }

    public String getPostCommentAsRendered(Address address) {
        String comment = this.currentProgram.getListing().getComment(CommentType.POST, address);
        PluginTool tool = this.state.getTool();
        if (tool != null) {
            comment = CommentUtils.getDisplayString(comment, this.currentProgram);
        }
        return comment;
    }

    public String getEOLCommentAsRendered(Address address) {
        String comment = this.currentProgram.getListing().getComment(CommentType.EOL, address);
        PluginTool tool = this.state.getTool();
        if (tool != null) {
            comment = CommentUtils.getDisplayString(comment, this.currentProgram);
        }
        return comment;
    }

    public String getRepeatableCommentAsRendered(Address address) {
        String comment = this.currentProgram.getListing().getComment(CommentType.REPEATABLE, address);
        PluginTool tool = this.state.getTool();
        if (tool != null) {
            comment = CommentUtils.getDisplayString(comment, this.currentProgram);
        }
        return comment;
    }

    private void show(String title, TableService table, Address[] addresses) {
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            this.println("Couldn't show table!");
            return;
        }
        Runnable runnable = () -> {
            AddressArrayTableModel model = new AddressArrayTableModel(this.getScriptName(), (ServiceProvider)this.state.getTool(), this.currentProgram, addresses);
            TableComponentProvider<Address> tableProvider = table.showTableWithMarkers(title + " " + model.getName(), "Addresses", model, (Color)GThemeDefaults.Colors.Palette.GREEN, null, "Script Results", null);
            tableProvider.installRemoveItemsAction();
        };
        Swing.runLater((Runnable)runnable);
    }

    private void show(String title, TableService table, AddressSetView addresses) {
        PluginTool tool = this.state.getTool();
        if (tool == null) {
            this.println("Couldn't show table!");
            return;
        }
        Swing.runLater(() -> {
            AddressSetTableModel model = new AddressSetTableModel(title, (ServiceProvider)this.state.getTool(), this.currentProgram, addresses, null);
            TableComponentProvider<Address> tableProvider = table.showTableWithMarkers(title, "Addresses", model, (Color)GThemeDefaults.Colors.Palette.GREEN, null, "Script Results", null);
            tableProvider.installRemoveItemsAction();
        });
    }

    private Map<Class<?>, Object> getScriptMap(String title, String message) {
        Map<Class<?>, Object> scriptMap = askMap.get(title + message);
        if (scriptMap == null) {
            scriptMap = new HashMap();
            askMap.put(title + message, scriptMap);
        }
        return scriptMap;
    }

    private static String zeropad(String s, int len) {
        if (s == null) {
            s = "";
        }
        StringBuffer buffer = new StringBuffer(s);
        int zerosNeeded = len - s.length();
        for (int i = 0; i < zerosNeeded; ++i) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }

    private static <T> T swing(CancellableFunction<T, T> f, T t) throws CancelledException {
        AtomicBoolean wasCancelled = new AtomicBoolean();
        Object result = Swing.runNow(() -> {
            try {
                return f.apply(t);
            }
            catch (CancelledException e) {
                wasCancelled.set(true);
                return null;
            }
        });
        if (wasCancelled.get()) {
            throw new CancelledException();
        }
        return (T)result;
    }

    public static enum AnalysisMode {
        ENABLED,
        DISABLED,
        SUSPENDED;

    }

    private static interface CancellableFunction<T, R> {
        public R apply(T var1) throws CancelledException;
    }

    private static class DIRECTORY {
        private DIRECTORY() {
        }
    }

    private class ScriptStatusListener
    implements StatusListener {
        StringBuilder errors = new StringBuilder();

        private ScriptStatusListener(GhidraScript ghidraScript) {
        }

        public void setStatusText(String text) {
            this.errors.append(text);
            this.errors.append("\n");
        }

        public void setStatusText(String text, MessageType messageType) {
            this.setStatusText(text);
        }

        public void setStatusText(String text, MessageType type, boolean alert) {
            this.setStatusText(text);
        }

        public void clearStatusText() {
        }

        public final String toString() {
            return this.errors.toString();
        }
    }
}

