/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeClass;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFBooleanAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFDeferredStringAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFFormContext;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFIndirectAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFStringAttribute;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum DWARFForm {
    DW_FORM_addr(1, -1, new DWARFAttributeClass[]{DWARFAttributeClass.address}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            return context.compUnit().getPointerSize();
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFNumericAttribute(context.reader().readNextUnsignedValue(context.compUnit().getPointerSize()), context.def());
        }
    }
    ,
    DW_FORM_block2(3, -1, new DWARFAttributeClass[]{DWARFAttributeClass.block}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            int arraySize = context.reader().readNextUnsignedShort();
            return 2 + arraySize;
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int length = context.reader().readNextUnsignedShort();
            return new DWARFBlobAttribute(context.reader().readNextByteArray(length), context.def());
        }
    }
    ,
    DW_FORM_block4(4, -1, new DWARFAttributeClass[]{DWARFAttributeClass.block}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            int arraySize = context.reader().readNextUnsignedIntExact();
            return 4 + arraySize;
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int length = context.reader().readNextUnsignedIntExact();
            if (length < 0 || length > 0x100000) {
                throw new IOException("Invalid/bad dw_form_block4 size: " + length);
            }
            return new DWARFBlobAttribute(context.reader().readNextByteArray(length), context.def());
        }
    }
    ,
    DW_FORM_data2(5, 2, DWARFAttributeClass.constant),
    DW_FORM_data4(6, 4, DWARFAttributeClass.constant),
    DW_FORM_data8(7, 8, DWARFAttributeClass.constant),
    DW_FORM_string(8, -1, new DWARFAttributeClass[]{DWARFAttributeClass.string}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            long start = context.reader().getPointerIndex();
            context.reader().readNextString(context.dprog().getCharset(), 1);
            return context.reader().getPointerIndex() - start;
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            String s = context.reader().readNextString(context.dprog().getCharset(), 1);
            return new DWARFStringAttribute(s, context.def());
        }
    }
    ,
    DW_FORM_block(9, -1, new DWARFAttributeClass[]{DWARFAttributeClass.block}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            LEB128Info uleb128 = context.reader().readNext(LEB128Info::unsigned);
            return uleb128.getLength() + uleb128.asUInt32();
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int length = context.reader().readNextUnsignedVarIntExact(LEB128::unsigned);
            if (length < 0 || length > 0x100000) {
                throw new IOException("Invalid/bad dw_form_block size: " + length);
            }
            return new DWARFBlobAttribute(context.reader().readNextByteArray(length), context.def());
        }
    }
    ,
    DW_FORM_block1(10, -1, new DWARFAttributeClass[]{DWARFAttributeClass.block}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            int length = context.reader().readNextUnsignedByte();
            return 1 + length;
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int length = context.reader().readNextUnsignedByte();
            return new DWARFBlobAttribute(context.reader().readNextByteArray(length), context.def());
        }
    }
    ,
    DW_FORM_data1(11, 1, DWARFAttributeClass.constant),
    DW_FORM_flag(12, 1, new DWARFAttributeClass[]{DWARFAttributeClass.flag}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFBooleanAttribute(context.reader().readNextByte() != 0, context.def());
        }
    }
    ,
    DW_FORM_sdata(13, -3, new DWARFAttributeClass[]{DWARFAttributeClass.constant}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFNumericAttribute(64, context.reader().readNext(LEB128::signed), true, context.def());
        }
    }
    ,
    DW_FORM_strp(14, -2, new DWARFAttributeClass[]{DWARFAttributeClass.string}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            long stringOffset = context.reader().readNextUnsignedValue(context.dwarfIntSize());
            return new DWARFDeferredStringAttribute(stringOffset, context.def());
        }
    }
    ,
    DW_FORM_udata(15, -3, new DWARFAttributeClass[]{DWARFAttributeClass.constant}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFNumericAttribute(64, context.reader().readNext(LEB128::unsigned), false, context.def());
        }
    }
    ,
    DW_FORM_ref_addr(16, -2, new DWARFAttributeClass[]{DWARFAttributeClass.reference}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            long addr = context.reader().readNextUnsignedValue(context.dwarfIntSize());
            return new DWARFNumericAttribute(addr, context.def());
        }
    }
    ,
    DW_FORM_ref1(17, 1, DWARFAttributeClass.reference),
    DW_FORM_ref2(18, 2, DWARFAttributeClass.reference),
    DW_FORM_ref4(19, 4, DWARFAttributeClass.reference),
    DW_FORM_ref8(20, 8, DWARFAttributeClass.reference),
    DW_FORM_ref_udata(21, -3, new DWARFAttributeClass[]{DWARFAttributeClass.constant}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            long uoffset = context.reader().readNext(LEB128::unsigned);
            return new DWARFNumericAttribute(uoffset + context.compUnit().getStartOffset(), context.def());
        }
    }
    ,
    DW_FORM_indirect(22, -1, new DWARFAttributeClass[0]){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            long start = context.reader().getPointerIndex();
            int indirectFormInt = context.reader().readNextUnsignedVarIntExact(LEB128::unsigned);
            long firstSize = context.reader().getPointerIndex() - start;
            DWARFForm indirectForm = DWARFForm.of(indirectFormInt);
            DWARFAttributeDef<?> indirectAS = context.def().withForm(indirectForm);
            DWARFFormContext indirectContext = new DWARFFormContext(context.reader(), context.compUnit(), indirectAS, context.dwarfIntSize());
            long indirectSize = indirectForm.getSize(indirectContext);
            return firstSize + indirectSize;
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int indirectFormInt = context.reader().readNextUnsignedVarIntExact(LEB128::unsigned);
            DWARFForm indirectForm = DWARFForm.of(indirectFormInt);
            DWARFAttributeDef<?> indirectAS = context.def().withForm(indirectForm);
            DWARFFormContext indirectContext = new DWARFFormContext(context.reader(), context.compUnit(), indirectAS, context.dwarfIntSize());
            return indirectForm.readValue(indirectContext);
        }
    }
    ,
    DW_FORM_sec_offset(23, -2, new DWARFAttributeClass[]{DWARFAttributeClass.addrptr, DWARFAttributeClass.lineptr, DWARFAttributeClass.loclist, DWARFAttributeClass.loclistsptr, DWARFAttributeClass.macptr, DWARFAttributeClass.rnglist, DWARFAttributeClass.rnglistsptr, DWARFAttributeClass.stroffsetsptr}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            long addr = context.reader().readNextUnsignedValue(context.dwarfIntSize());
            return new DWARFNumericAttribute(addr, context.def());
        }
    }
    ,
    DW_FORM_exprloc(24, -1, new DWARFAttributeClass[]{DWARFAttributeClass.exprloc}){

        @Override
        public long getSize(DWARFFormContext context) throws IOException {
            LEB128Info uleb128 = context.reader().readNext(LEB128Info::unsigned);
            return uleb128.getLength() + uleb128.asInt32();
        }

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int length = context.reader().readNextUnsignedVarIntExact(LEB128::unsigned);
            if (length < 0 || length > 0x100000) {
                throw new IOException("Invalid/bad dw_form_exprloc size: " + length);
            }
            return new DWARFBlobAttribute(context.reader().readNextByteArray(length), context.def());
        }
    }
    ,
    DW_FORM_flag_present(25, 0, new DWARFAttributeClass[]{DWARFAttributeClass.flag}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFBooleanAttribute(true, context.def());
        }
    }
    ,
    DW_FORM_strx(26, -3, new DWARFAttributeClass[]{DWARFAttributeClass.string}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int index = context.reader().readNextUnsignedVarIntExact(LEB128::unsigned);
            return new DWARFDeferredStringAttribute(index, context.def());
        }
    }
    ,
    DW_FORM_addrx(27, -3, new DWARFAttributeClass[]{DWARFAttributeClass.address}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            int index = context.reader().readNextUnsignedVarIntExact(LEB128::unsigned);
            return new DWARFIndirectAttribute(index, context.def());
        }
    }
    ,
    DW_FORM_ref_sup4(28, 4, DWARFAttributeClass.reference),
    DW_FORM_strp_sup(29, -2, DWARFAttributeClass.string),
    DW_FORM_data16(30, 16, new DWARFAttributeClass[]{DWARFAttributeClass.constant}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFBlobAttribute(context.reader().readNextByteArray(16), context.def());
        }
    }
    ,
    DW_FORM_line_strp(31, -2, new DWARFAttributeClass[]{DWARFAttributeClass.string}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFDeferredStringAttribute(context.reader().readNextUnsignedValue(context.dwarfIntSize()), context.def());
        }
    }
    ,
    DW_FORM_ref_sig8(32, 8, DWARFAttributeClass.reference),
    DW_FORM_implicit_const(33, 0, new DWARFAttributeClass[0]){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFNumericAttribute(64, context.def().getImplicitValue(), true, context.def());
        }
    }
    ,
    DW_FORM_loclistx(34, -3, new DWARFAttributeClass[]{DWARFAttributeClass.loclist}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFIndirectAttribute(context.reader().readNext(LEB128::unsigned), context.def());
        }
    }
    ,
    DW_FORM_rnglistx(35, -3, new DWARFAttributeClass[]{DWARFAttributeClass.rnglist}){

        @Override
        public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
            return new DWARFIndirectAttribute(context.reader().readNext(LEB128::unsigned), context.def());
        }
    }
    ,
    DW_FORM_ref_sup8(36, 8, DWARFAttributeClass.reference),
    DW_FORM_strx1(37, 1, DWARFAttributeClass.string),
    DW_FORM_strx2(38, 2, DWARFAttributeClass.string),
    DW_FORM_strx3(39, 3, DWARFAttributeClass.string),
    DW_FORM_strx4(40, 4, DWARFAttributeClass.string),
    DW_FORM_addrx1(41, 1, DWARFAttributeClass.address),
    DW_FORM_addrx2(42, 2, DWARFAttributeClass.address),
    DW_FORM_addrx3(43, 3, DWARFAttributeClass.address),
    DW_FORM_addrx4(44, 4, DWARFAttributeClass.address);

    private final int id;
    private final int size;
    private final Set<DWARFAttributeClass> attributeClasses;
    private static final Map<Integer, DWARFForm> lookupMap;
    public static final int EOL = 0;
    public static final int MAX_BLOCK4_SIZE = 0x100000;
    private static final int LEB128_SIZE = -3;
    private static final int DWARF_INTSIZE = -2;
    private static final int DYNAMIC_SIZE = -1;

    private DWARFForm(int id, int size, DWARFAttributeClass ... attributeClasses) {
        this.id = id;
        this.size = size;
        this.attributeClasses = EnumSet.noneOf(DWARFAttributeClass.class);
        this.attributeClasses.addAll(List.of(attributeClasses));
    }

    public int getId() {
        return this.id;
    }

    public Set<DWARFAttributeClass> getFormClasses() {
        return this.attributeClasses;
    }

    public boolean isClass(DWARFAttributeClass attrClass) {
        return this.attributeClasses.size() == 1 && this.attributeClasses.contains((Object)attrClass);
    }

    public long getSize(DWARFFormContext context) throws IOException {
        switch (this.size) {
            case -2: {
                return context.dwarfIntSize();
            }
            case -3: {
                return context.reader().readNext(LEB128::getLength).intValue();
            }
            case -1: {
                throw new IOException("Unimplemented size for " + String.valueOf((Object)this));
            }
        }
        return this.size;
    }

    public DWARFAttributeValue readValue(DWARFFormContext context) throws IOException {
        switch (this.ordinal()) {
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                long index = context.reader().readNextUnsignedValue(this.size);
                return new DWARFIndirectAttribute(index, context.def());
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                long val = context.reader().readNextValue(this.size);
                return new DWARFNumericAttribute(this.size * 8, val, true, true, context.def());
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                long uoffset = context.reader().readNextUnsignedValue(this.size);
                return new DWARFNumericAttribute(uoffset + context.compUnit().getStartOffset(), context.def());
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                long index = context.reader().readNextUnsignedValue(this.size);
                return new DWARFDeferredStringAttribute(index, context.def());
            }
        }
        throw new IllegalArgumentException("Unsupported DWARF Form: " + String.valueOf((Object)this));
    }

    public static DWARFForm of(int key) {
        return lookupMap.get(key);
    }

    private static Map<Integer, DWARFForm> buildLookupmap() {
        HashMap<Integer, DWARFForm> result = new HashMap<Integer, DWARFForm>();
        for (DWARFForm form : DWARFForm.values()) {
            result.put(form.getId(), form);
        }
        return result;
    }

    static {
        lookupMap = DWARFForm.buildLookupmap();
    }
}

