/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheImageInfoExtra
implements StructConverter {
    private long exportsTrieAddr;
    private long weakBindingsAddr;
    private int exportsTrieSize;
    private int weakBindingsSize;
    private int dependentsStartArrayIndex;
    private int reExportsStartArrayIndex;

    public DyldCacheImageInfoExtra(BinaryReader reader) throws IOException {
        this.exportsTrieAddr = reader.readNextLong();
        this.weakBindingsAddr = reader.readNextLong();
        this.exportsTrieSize = reader.readNextInt();
        this.weakBindingsSize = reader.readNextInt();
        this.dependentsStartArrayIndex = reader.readNextInt();
        this.reExportsStartArrayIndex = reader.readNextInt();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_image_info_extra", 0);
        struct.add(QWORD, "exportsTrieAddr", "");
        struct.add(QWORD, "weakBindingsAddr", "");
        struct.add(DWORD, "exportsTrieSize", "");
        struct.add(DWORD, "weakBindingsSize", "");
        struct.add(DWORD, "dependentsStartArrayIndex", "");
        struct.add(DWORD, "reExportsStartArrayIndex", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

