/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Protocol
implements StructConverter {
    public static final String NAME = "protocol_t";
    private ObjectiveC2_State _state;
    private long _index;
    private long isa;
    private String name;
    private ObjectiveC2_ProtocolList protocols;
    private ObjectiveC2_MethodList instanceMethods;
    private ObjectiveC2_MethodList classMethods;
    private ObjectiveC2_MethodList optionalInstanceMethods;
    private ObjectiveC2_MethodList optionalClassMethods;
    private ObjectiveC2_PropertyList instanceProperties;
    private long unknown0;
    private long unknown1;

    public ObjectiveC2_Protocol(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.isa = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
        this.readName(reader);
        this.readProtocols(reader);
        this.readInstanceMethods(reader);
        this.readClassMethods(reader);
        this.readOptionalInstanceMethods(reader);
        this.readOptionalClassMethods(reader);
        this.readInstanceProperties(reader);
        if (state.is32bit) {
            this.unknown0 = reader.readNextUnsignedInt();
            this.unknown1 = reader.readNextUnsignedInt();
        } else {
            this.unknown0 = reader.readNextLong();
            this.unknown1 = reader.readNextLong();
        }
    }

    public long getIsa() {
        return this.isa;
    }

    public String getName() {
        return this.name;
    }

    public ObjectiveC2_ProtocolList getProtocols() {
        return this.protocols;
    }

    public ObjectiveC2_MethodList getInstanceMethods() {
        return this.instanceMethods;
    }

    public ObjectiveC2_MethodList getClassMethods() {
        return this.classMethods;
    }

    public ObjectiveC2_MethodList getOptionalInstanceMethods() {
        return this.optionalInstanceMethods;
    }

    public ObjectiveC2_MethodList getOptionalClassMethods() {
        return this.optionalClassMethods;
    }

    public ObjectiveC2_PropertyList getInstanceProperties() {
        return this.instanceProperties;
    }

    public long getUnknown0() {
        return this.unknown0;
    }

    public long getUnknown1() {
        return this.unknown1;
    }

    public long getIndex() {
        return this._index;
    }

    private void readProtocols(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.protocols = new ObjectiveC2_ProtocolList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readName(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            this.name = reader.readAsciiString(index);
        }
    }

    private void readInstanceMethods(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readClassMethods(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.classMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.CLASS);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readOptionalInstanceMethods(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.optionalInstanceMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readOptionalClassMethods(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.optionalClassMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.CLASS);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceProperties(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceProperties = new ObjectiveC2_PropertyList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (this._state.is32bit) {
            struct.add(DWORD, "isa", null);
        } else {
            struct.add(QWORD, "isa", null);
        }
        struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "name", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_ProtocolList.toGenericDataType(this._state)), this._state.pointerSize, "protocols", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "instanceMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "classMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "optionalInstanceMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "optionalClassMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_PropertyList.toGenericDataType()), this._state.pointerSize, "instanceProperties", null);
        if (this._state.is32bit) {
            struct.add(DWORD, "unknown0", null);
            struct.add(DWORD, "unknown1", null);
        } else {
            struct.add(QWORD, "unknown0", null);
            struct.add(QWORD, "unknown1", null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo(Namespace namespace) throws Exception {
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace protocolNamespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", NAME);
            ObjectiveC1_Utilities.createSymbol(this._state.program, protocolNamespace, this.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocols != null) {
            this.protocols.applyTo(namespace);
        }
        if (this.instanceMethods != null) {
            this.instanceMethods.applyTo(namespace);
        }
        if (this.classMethods != null) {
            this.classMethods.applyTo(namespace);
        }
        if (this.optionalInstanceMethods != null) {
            this.optionalInstanceMethods.applyTo(namespace);
        }
        if (this.optionalClassMethods != null) {
            this.optionalClassMethods.applyTo(namespace);
        }
        if (this.instanceProperties != null) {
            this.instanceProperties.applyTo(namespace);
        }
    }
}

