/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pdb.PdbInfo;
import ghidra.framework.options.Options;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Conv;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;

public class PdbInfoCodeView
implements StructConverter,
PdbInfo {
    private static final int MAGIC = 1312960816;
    private byte[] magic;
    private int offset;
    private int sig;
    private int age;
    private String pdbName;
    private String pdbPath;

    public static boolean isMatch(BinaryReader reader, long offset) throws IOException {
        int value = reader.asBigEndian().readInt(offset);
        return 1312960816 == value;
    }

    public static PdbInfoCodeView read(BinaryReader reader, long offset) throws IOException {
        reader = reader.clone(offset);
        PdbInfoCodeView result = new PdbInfoCodeView();
        result.magic = reader.readNextByteArray(4);
        result.offset = reader.readNextInt();
        result.sig = reader.readNextInt();
        result.age = reader.readNextInt();
        result.pdbPath = reader.readNextAsciiString();
        result.pdbName = FilenameUtils.getName((String)result.pdbPath);
        return result;
    }

    private PdbInfoCodeView() {
    }

    @Override
    public boolean isValid() {
        return this.magic.length == 4 && !this.pdbName.isBlank();
    }

    @Override
    public void serializeToOptions(Options options) {
        options.setString("PDB Version", new String(this.magic, StandardCharsets.US_ASCII));
        options.setString("PDB Signature", Conv.toHexString((int)this.sig));
        options.setString("PDB Age", Integer.toHexString(this.age));
        options.setString("PDB File", this.pdbName);
    }

    @Override
    public DataType toDataType() {
        StructureDataType struct = new StructureDataType("PdbInfo", 0);
        struct.add((DataType)new StringDataType(), this.magic.length, "signature", null);
        struct.add((DataType)new DWordDataType(), "offset", null);
        struct.add((DataType)new DWordDataType(), "sig", null);
        struct.add((DataType)new DWordDataType(), "age", null);
        if (this.pdbPath.length() > 0) {
            struct.add((DataType)new StringDataType(), this.pdbPath.length(), "pdbpath", null);
        }
        struct.setCategoryPath(new CategoryPath("/PDB"));
        return struct;
    }
}

