/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.RowSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LazyMap;

public class RowSegmentList<E> {
    protected List<RowSegment<E>> edgeSegments = new ArrayList<RowSegment<E>>();
    int row;

    public RowSegmentList(int row) {
        this.row = row;
    }

    protected void addSegment(RowSegment<E> segment) {
        this.edgeSegments.add(segment);
    }

    public String toString() {
        return this.edgeSegments.toString();
    }

    public int getRow() {
        return this.row;
    }

    public int getMinOffset() {
        int minOffset = 0;
        for (EdgeSegment edgeSegment : this.edgeSegments) {
            minOffset = Math.min(minOffset, edgeSegment.getOffset());
        }
        return minOffset;
    }

    public int getMaxOffset() {
        int maxOffset = 0;
        for (EdgeSegment edgeSegment : this.edgeSegments) {
            maxOffset = Math.max(maxOffset, edgeSegment.getOffset());
        }
        return maxOffset;
    }

    public void assignOffsets() {
        this.sort();
        LazyMap offsetMap = LazyMap.lazyMap(new HashMap(), k -> new RowSegmentList(0));
        for (int i = 0; i < this.edgeSegments.size(); ++i) {
            RowSegment<E> segment = this.edgeSegments.get(i);
            this.assignOffset((Map<Integer, RowSegmentList<E>>)offsetMap, segment);
        }
    }

    private void sort() {
        if (this.isUniformFlow()) {
            Collections.sort(this.edgeSegments, (s1, s2) -> s1.compareToUsingFlows(s2));
        } else {
            Collections.sort(this.edgeSegments, (s1, s2) -> s1.compareToIgnoreFlows(s2));
        }
    }

    private boolean isUniformFlow() {
        if (this.edgeSegments.isEmpty()) {
            return true;
        }
        boolean firstSegmentIsFlowingLeft = this.edgeSegments.get(0).isFlowingLeft();
        for (RowSegment<E> rowSegment : this.edgeSegments) {
            if (rowSegment.isFlowingLeft() == firstSegmentIsFlowingLeft) continue;
            return false;
        }
        return true;
    }

    protected void assignOffset(Map<Integer, RowSegmentList<E>> offsetMap, RowSegment<E> segment) {
        int offset = 0;
        RowSegmentList<E> segments = offsetMap.get(offset);
        while (segments.hasOverlappingSegment(segment)) {
            segments = offsetMap.get(offset += 2);
        }
        segment.setOffset(offset);
        segments.addSegment(segment);
    }

    private boolean hasOverlappingSegment(RowSegment<E> segment) {
        for (RowSegment<E> edgeSegment : this.edgeSegments) {
            if (!segment.overlaps(edgeSegment)) continue;
            return true;
        }
        return false;
    }
}

