/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntUnOpGen;
import ghidra.pcode.emu.jit.op.JitIntNegateOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntNegateOpGen implements IntUnOpGen<JitIntNegateOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    private void generateMpIntNegate(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int legCount = type.legsAlloc();
        try (JitAllocationModel.JvmTempAlloc temp = gen.getAllocationModel().allocateTemp(mv, "temp", legCount);){
            int i;
            for (i = 0; i < legCount; ++i) {
                mv.visitVarInsn(54, temp.idx(i));
            }
            i = legCount;
            for (JitType.SimpleJitType simpleJitType : type.legTypes()) {
                mv.visitVarInsn(21, temp.idx(--i));
                mv.visitLdcInsn((Object)(-1 >>> 32 - simpleJitType.size() * 8));
                mv.visitInsn(130);
            }
        }
    }

    @Override
    public JitType generateUnOpRunCode(JitCodeGenerator gen, JitIntNegateOp op, JitControlFlowModel.JitBlock block, JitType uType, MethodVisitor rv) {
        JitType jitType = uType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                rv.visitLdcInsn((Object)(-1 >>> 32 - t.size() * 8));
                rv.visitInsn(130);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                rv.visitLdcInsn((Object)(-1L >>> 64 - t.size() * 8));
                rv.visitInsn(131);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                this.generateMpIntNegate(gen, t, rv);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return uType;
    }
}

