/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.op;

import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitSyntheticOp;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import java.util.List;
import org.apache.commons.collections4.iterators.ReverseListIterator;

public record JitCatenateOp(JitOutVar out, List<JitVal> parts) implements JitDefOp,
JitSyntheticOp
{
    public JitCatenateOp {
        if (parts.size() <= 1) {
            throw new IllegalArgumentException("Must have at least 2 parts");
        }
    }

    @Override
    public void link() {
        JitDefOp.super.link();
        for (int i = 0; i < this.parts.size(); ++i) {
            this.parts.get(i).addUse(this, i);
        }
    }

    @Override
    public void unlink() {
        JitDefOp.super.unlink();
        for (int i = 0; i < this.parts.size(); ++i) {
            this.parts.get(i).removeUse(this, i);
        }
    }

    public Iterable<JitVal> iterParts(boolean bigEndian) {
        if (bigEndian) {
            return this.parts;
        }
        return () -> new ReverseListIterator(this.parts);
    }

    @Override
    public List<JitVal> inputs() {
        return this.parts;
    }

    @Override
    public JitTypeBehavior typeFor(int position) {
        if (position > this.parts.size() || position < 0) {
            throw new AssertionError();
        }
        return this.partType();
    }

    public JitTypeBehavior partType() {
        return JitTypeBehavior.INTEGER;
    }

    @Override
    public JitTypeBehavior type() {
        return JitTypeBehavior.INTEGER;
    }
}

