/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.op;

import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.PcodeOp;
import java.util.List;

public record JitStoreOp(PcodeOp op, AddressSpace space, JitVal offset, JitVal value) implements JitOp
{
    @Override
    public boolean canBeRemoved() {
        return false;
    }

    @Override
    public void link() {
        this.offset.addUse(this, 0);
        this.value.addUse(this, 1);
    }

    @Override
    public void unlink() {
        this.offset.removeUse(this, 0);
        this.value.removeUse(this, 1);
    }

    @Override
    public List<JitVal> inputs() {
        return List.of(this.offset, this.value);
    }

    @Override
    public JitTypeBehavior typeFor(int position) {
        return switch (position) {
            case 0 -> this.offsetType();
            case 1 -> this.valueType();
            default -> throw new AssertionError();
        };
    }

    public JitTypeBehavior offsetType() {
        return JitTypeBehavior.INTEGER;
    }

    public JitTypeBehavior valueType() {
        return JitTypeBehavior.ANY;
    }
}

